/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JMethod;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadGroupGenerator
extends ClassComponent {
    private static final L10N L = new L10N(LoadGroupGenerator.class);
    private String _extClassName;
    private EntityType _entityType;
    private int _index;

    public LoadGroupGenerator(String extClassName, EntityType entityType, int index) {
        this._extClassName = extClassName;
        this._entityType = entityType;
        this._index = index;
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        out.println();
        out.println("protected void __caucho_load_" + this._index + "(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("{");
        out.pushDepth();
        int group = this._index / 64;
        long mask = 1L << this._index % 64;
        out.println("boolean isLoaded = (__caucho_loadMask_" + group + " & " + mask + "L) != 0;");
        if (this._entityType.getTable() != null) {
            int min = 0;
            if (this._entityType.getParentType() == null) {
                min = this._index;
            }
            int max = this._index;
            this.generateTransactionChecks(out, group, mask, min, max);
            if (min <= max) {
                out.println("else {");
                out.pushDepth();
            }
            for (int i = min; i <= max; ++i) {
                out.println("if ((__caucho_loadMask_" + group + " & " + (1L << i % 64) + "L) == 0)");
                out.println("  __caucho_load_select_" + i + "(aConn);");
            }
            if (min <= max) {
                out.popDepth();
                out.println("}");
            }
            out.println();
            this._entityType.generatePostLoadSelect(out, 1, this._index);
            out.println();
            out.println("if (__caucho_log.isLoggable(java.util.logging.Level.FINER))");
            out.println("  __caucho_log.finer(getClass().getSimpleName() + \"[\" + __caucho_getPrimaryKey() + \"] amber load-" + this._index + "\");");
            out.println();
            out.println("if (! isLoaded) {");
            out.pushDepth();
            if (this._entityType.getHasLoadCallback() && this._index == 0) {
                out.println();
                out.println("__caucho_load_callback();");
            }
            out.println();
            out.println("if (__caucho_home != null)");
            out.println("  __caucho_home.postLoad(this);");
            this.generateCallbacks(out, this._entityType.getPostLoadCallbacks());
            out.popDepth();
            out.println("}");
        }
        out.popDepth();
        out.println("}");
        if (this._index == 0 && this._entityType.getHasLoadCallback()) {
            out.println();
            out.println("protected void __caucho_load_callback() {}");
        }
        this.generateLoadSelect(out, group, mask);
        if (this._index == 0) {
            this.generateLoadNative(out);
        }
    }

    private void generateLoadNative(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_load_native(java.sql.ResultSet rs, String []columnNames)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        this._entityType.generateLoadNative(out);
        out.println("__caucho_loadMask_0 |= 1L;");
        out.popDepth();
        out.println("}");
    }

    private void generateTransactionChecks(JavaWriter out, int group, long mask, int min, int max) throws IOException {
        if (!this._entityType.isReadOnly()) {
            int i;
            out.println("if (aConn.isInTransaction()) {");
            out.pushDepth();
            out.println("if (__caucho_state.isDeleting()) {");
            out.println("  return;");
            out.println("}");
            out.println("else if (__caucho_state.isNonTransactional()) {");
            out.pushDepth();
            out.println("__caucho_state = com.caucho.amber.entity.EntityState.P_TRANSACTIONAL;");
            out.println();
            int dirtyCount = this._entityType.getDirtyIndex();
            for (i = 0; i <= dirtyCount / 64; ++i) {
                out.println("__caucho_dirtyMask_" + i + " = 0;");
            }
            out.popDepth();
            out.println("}");
            for (i = min; i <= max; ++i) {
                out.println();
                out.println("if ((__caucho_loadMask_" + group + " & " + (1L << i % 64) + "L) == 0)");
                out.println("  __caucho_load_select_" + i + "(aConn);");
            }
            out.popDepth();
            out.println("}");
            out.print("else ");
        }
        out.println("if ((__caucho_loadMask_" + group + " & " + mask + "L) != 0) {");
        out.println("}");
        out.println("else if (__caucho_cacheItem != null) {");
        out.pushDepth();
        out.println(this._extClassName + " item = (" + this._extClassName + ") __caucho_cacheItem.getEntity();");
        out.println("item.__caucho_load_select_" + this._index + "(aConn);");
        this._entityType.generateCopyLoadObject(out, "super", "item", this._index);
        out.println("__caucho_loadMask_" + group + " |= item.__caucho_loadMask_" + group + " & " + mask + "L;");
        out.popDepth();
        out.println("}");
    }

    private void generateLoadSelect(JavaWriter out, int group, long mask) throws IOException {
        if (this._index == 0 && this._entityType.getDiscriminator() != null) {
            out.println();
            out.println("String __caucho_discriminator;");
        }
        out.println();
        out.println("protected void __caucho_load_select_" + this._index + "(com.caucho.amber.manager.AmberConnection aConn)");
        out.println("{");
        out.pushDepth();
        if (this._entityType.getTable() == null) {
            out.popDepth();
            out.println("}");
            return;
        }
        out.println("if ((__caucho_loadMask_" + group + " & " + mask + "L) != 0)");
        out.println("  return;");
        Table table = this._entityType.getTable();
        String from = null;
        String select = null;
        String where = null;
        String subSelect = null;
        Table mainTable = null;
        String tableName = null;
        select = this._entityType.generateLoadSelect(table, "o", this._index);
        if (select != null) {
            from = table.getName() + " o";
            where = this._entityType.getId().generateMatchArgWhere("o");
            mainTable = table;
            tableName = "o";
        }
        ArrayList<Table> subTables = this._entityType.getSecondaryTables();
        for (int i = 0; i < subTables.size(); ++i) {
            Table subTable = subTables.get(i);
            subSelect = this._entityType.generateLoadSelect(subTable, "o" + i, this._index);
            if (subSelect == null) continue;
            select = select != null ? select + ", " + subSelect : subSelect;
            from = from != null ? from + ", " + subTable.getName() + " o" + i : subTable.getName() + " o" + i;
            if (where != null) {
                LinkColumns link = subTable.getDependentIdLink();
                where = where + " and " + link.generateJoin("o" + i, "o");
                continue;
            }
            throw new IllegalStateException();
        }
        if (select == null) {
            if (this._index > 0) {
                out.println("return;");
                out.popDepth();
                out.println("}");
                return;
            }
            select = "1";
        }
        if (where == null) {
            from = table.getName() + " o";
            where = this._entityType.getId().generateMatchArgWhere("o");
        }
        String sql = "select " + select + " from " + from + " where " + where;
        out.println();
        out.println("java.sql.ResultSet rs = null;");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println();
        out.print("String sql = \"");
        out.printJavaString(sql);
        out.println("\";");
        out.println();
        out.println("java.sql.PreparedStatement pstmt = aConn.prepareStatement(sql);");
        out.println("int index = 1;");
        this._entityType.getId().generateSet(out, "pstmt", "index", "super");
        out.println();
        out.println("rs = pstmt.executeQuery();");
        out.println("if (rs.next()) {");
        out.pushDepth();
        if (this._index == 0 && this._entityType.getDiscriminator() != null) {
            out.println();
            out.println("__caucho_discriminator = rs.getString(1);");
        }
        this._entityType.generateLoad(out, "rs", "", 1, this._index);
        out.println("__caucho_loadMask_" + group + " |= " + mask + "L;");
        out.popDepth();
        out.println("}");
        out.println("else {");
        String errorString = "(\"amber load: no matching object " + this._entityType.getName() + "[\" + __caucho_getPrimaryKey() + \"]\")";
        out.println("  throw new com.caucho.amber.AmberObjectNotFoundException(" + errorString + ");");
        out.println("}");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("} finally {");
        out.println("  aConn.close(rs);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateCallbacks(JavaWriter out, ArrayList<JMethod> callbacks) throws IOException {
        if (callbacks.size() == 0) {
            return;
        }
        out.println();
        for (JMethod method : callbacks) {
            out.println(method.getName() + "();");
        }
    }
}

