/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberObjectNotFoundException;
import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.EntityResultConfig;
import com.caucho.amber.cfg.NamedNativeQueryConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.CacheableEntityItem;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityFactory;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.EntityKey;
import com.caucho.amber.entity.EntityState;
import com.caucho.amber.entity.RowInsertCompletion;
import com.caucho.amber.entity.RowInvalidateCompletion;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.manager.QueryImpl;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.jca.BeginResource;
import com.caucho.jca.CloseResource;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberConnection
implements BeginResource,
CloseResource,
Synchronization {
    private static final L10N L = new L10N(AmberConnection.class);
    private static final Logger log = Logger.getLogger(AmberConnection.class.getName());
    private static final Entity[] NULL_ENTITIES = new Entity[0];
    private AmberPersistenceUnit _persistenceUnit;
    private boolean _isRegistered;
    private boolean _isThreadConnection;
    private Entity[] _entities = new Entity[32];
    private int _entitiesTop;
    private Entity[] _txEntities = NULL_ENTITIES;
    private int _txEntitiesTop;
    private ArrayList<AmberCompletion> _completionList = new ArrayList();
    private ArrayList<AmberCollection> _queries = new ArrayList();
    private EntityTransaction _trans;
    private long _xid;
    private boolean _isInTransaction;
    private boolean _isXA;
    private boolean _isExtended;
    private boolean _isAppManaged;
    private Connection _conn;
    private Connection _readConn;
    private boolean _isAutoCommit = true;
    private int _depth;
    private LruCache<String, PreparedStatement> _preparedStatementMap = new LruCache(32);
    private ArrayList<Statement> _statements = new ArrayList();
    private EntityKey _entityKey = new EntityKey();
    private QueryCacheKey _queryKey = new QueryCacheKey();
    private ArrayList<Entity> _mergingEntities = new ArrayList();
    private boolean _isFlushAllowed = true;

    AmberConnection(AmberPersistenceUnit persistenceUnit, boolean isExtended, boolean isAppManaged) {
        this._persistenceUnit = persistenceUnit;
        this._isExtended = isExtended;
        this._isAppManaged = isAppManaged;
    }

    AmberConnection(AmberPersistenceUnit persistenceUnit, boolean isExtended) {
        this(persistenceUnit, isExtended, false);
    }

    public AmberPersistenceUnit getPersistenceUnit() {
        return this._persistenceUnit;
    }

    public boolean isJPA() {
        return this._persistenceUnit.isJPA();
    }

    public void initThreadConnection() {
        this._isThreadConnection = true;
        this.initJta();
    }

    public void initJta() {
        if (this._persistenceUnit.isJta()) {
            this.register();
        }
    }

    public void persist(Object entityObject) {
        Object exn = null;
        try {
            if (entityObject == null) {
                return;
            }
            Entity entity = this.checkEntityType(entityObject, "persist");
            this.checkTransactionRequired("persist");
            this.persistInternal(entity);
            if (!this._persistenceUnit.isJta()) {
                this.flushInternal();
            }
        }
        catch (RuntimeException e) {
            exn = e;
        }
        catch (SQLException e) {
            exn = new IllegalStateException(e);
        }
        catch (Exception e) {
            exn = new EJBExceptionWrapper(e);
        }
        if (exn != null) {
            if (!this._persistenceUnit.isJta() && this._trans != null) {
                this._trans.setRollbackOnly();
            }
            throw exn;
        }
    }

    public Object persistFromCascade(Object o) {
        try {
            if (o == null) {
                return null;
            }
            Entity entity = (Entity)o;
            return this.persistInternal(entity);
        }
        catch (EntityExistsException e) {
            log.log(Level.FINER, e.toString(), e);
            return o;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T merge(T entityT) {
        Object exn = null;
        try {
            this.flushInternal();
            this._isFlushAllowed = false;
            entityT = this.recursiveMerge(entityT);
        }
        catch (RuntimeException e) {
            exn = e;
        }
        catch (Exception e) {
            exn = new EJBExceptionWrapper(e);
        }
        finally {
            this._isFlushAllowed = true;
            try {
                this.flushInternal();
            }
            catch (RuntimeException e) {
                if (exn == null) {
                    exn = e;
                }
            }
            catch (Exception e) {
                if (exn == null) {
                    exn = new EJBExceptionWrapper(e);
                }
            }
            finally {
                this._mergingEntities.clear();
            }
        }
        if (exn != null) {
            throw exn;
        }
        return entityT;
    }

    public void remove(Object entity) {
        try {
            if (entity == null) {
                return;
            }
            Entity instance = this.checkEntityType(entity, "remove");
            this.checkTransactionRequired("remove");
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("removing entity class " + instance.getClass().getName() + " PK: " + instance.__caucho_getPrimaryKey() + " state: " + (Object)((Object)instance.__caucho_getEntityState())));
            }
            EntityState state = instance.__caucho_getEntityState();
            if (EntityState.P_DELETING.ordinal() <= state.ordinal()) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("remove is ignoring entity in state " + (Object)((Object)state)));
                }
                return;
            }
            if (instance.__caucho_getConnection() == null) {
                if (instance.__caucho_getEntityType() == null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, L.l("remove is ignoring entity; performing only cascade post-remove"));
                    }
                    instance.__caucho_cascadePostRemove(this);
                    return;
                }
                throw new IllegalArgumentException(L.l("remove() operation can only be applied to a managed entity. This entity instance '{0}' PK: '{1}' is detached which means it was probably removed or needs to be merged.", (Object)instance.getClass().getName(), instance.__caucho_getPrimaryKey()));
            }
            instance.__caucho_setEntityState(EntityState.P_DELETING);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("remove is flushing any lazy cascading operation"));
            }
            this.updateFlushPriority(instance);
            instance.__caucho_setEntityState(state);
            Entity oldEntity = this.getEntity(instance.getClass(), instance.__caucho_getPrimaryKey());
            if (oldEntity == null) {
                throw new IllegalArgumentException(L.l("remove() operation can only be applied to a managed entity instance."));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("remove is performing cascade pre-remove"));
            }
            instance.__caucho_cascadePreRemove(this);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("remove is performing delete on the target entity"));
            }
            this.delete(instance);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("remove is performing cascade post-remove"));
            }
            instance.__caucho_cascadePostRemove(this);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("DONE successful remove for entity class " + instance.getClass().getName() + " PK: " + instance.__caucho_getPrimaryKey()));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        boolean oldIsFlushAllowed = this._isFlushAllowed;
        try {
            this._isFlushAllowed = false;
            Object entity = this.load(entityClass, primaryKey, true);
            if (!this.isActiveTransaction()) {
                this.detach();
            }
            Object object = entity;
            return (T)object;
        }
        catch (AmberObjectNotFoundException e) {
            if (this._persistenceUnit.isJPA()) {
                T t = null;
                return t;
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
        finally {
            this._isFlushAllowed = oldIsFlushAllowed;
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) throws EntityNotFoundException, IllegalArgumentException {
        Object reference = null;
        try {
            reference = this.load(entityClass, primaryKey, false);
            if (reference == null) {
                throw new EntityNotFoundException(L.l("entity with primary key {0} not found in getReference()", primaryKey));
            }
            return (T)reference;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void clear() {
        this._entitiesTop = 0;
        this._txEntitiesTop = 0;
    }

    public Query createQuery(String sql) {
        try {
            AbstractQuery queryProgram = this.parseQuery(sql, false);
            return new QueryImpl(queryProgram, this);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public Query createNamedQuery(String name) {
        String sql = this._persistenceUnit.getNamedQuery(name);
        if (sql != null) {
            return this.createQuery(sql);
        }
        NamedNativeQueryConfig nativeQuery = this._persistenceUnit.getNamedNativeQuery(name);
        sql = nativeQuery.getQuery();
        String resultSetMapping = nativeQuery.getResultSetMapping();
        if (resultSetMapping != null && !"".equals(resultSetMapping)) {
            return this.createNativeQuery(sql, resultSetMapping);
        }
        String resultClass = nativeQuery.getResultClass();
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(resultClass);
        EntityType entityType = entityHome.getEntityType();
        try {
            return this.createNativeQuery(sql, entityType.getInstanceClass());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Query createNativeQuery(String sql) {
        char ch = (sql = sql.trim()).charAt(0);
        if (ch == 'S' || ch == 's') {
            throw new UnsupportedOperationException(L.l("createNativeQuery(String sql) is not supported for select statements. Please use createNativeQuery(String sql, String map) or createNativeQuery(String sql, Class cl) to map the result to scalar values or bean classes."));
        }
        return this.createInternalNativeQuery(sql);
    }

    public Query createNativeQuery(String sql, String map) {
        SqlResultSetMappingConfig resultSet = this._persistenceUnit.getSqlResultSetMapping(map);
        if (resultSet == null) {
            throw new IllegalArgumentException(L.l("createNativeQuery() cannot create a native query for a result set named '{0}'", (Object)map));
        }
        return this.createInternalNativeQuery(sql, resultSet);
    }

    public Query createNativeQuery(String sql, Class type) {
        SqlResultSetMappingConfig resultSet = new SqlResultSetMappingConfig();
        EntityResultConfig entityResult = new EntityResultConfig();
        entityResult.setEntityClass(type.getName());
        resultSet.addEntityResult(entityResult);
        return this.createInternalNativeQuery(sql, resultSet);
    }

    public void refresh(Object entity) {
        try {
            if (entity == null) {
                return;
            }
            if (!(entity instanceof Entity)) {
                throw new IllegalArgumentException(L.l("refresh() operation can only be applied to an entity instance. This object is of class '{0}'", (Object)entity.getClass().getName()));
            }
            this.checkTransactionRequired("refresh");
            Entity instance = (Entity)entity;
            String className = instance.getClass().getName();
            Object pk = instance.__caucho_getPrimaryKey();
            Entity oldEntity = this.getEntity(instance.getClass(), pk);
            if (oldEntity != null) {
                EntityState state = instance.__caucho_getEntityState();
                if (state.ordinal() <= EntityState.TRANSIENT.ordinal() || EntityState.P_DELETING.ordinal() <= state.ordinal()) {
                    throw new IllegalArgumentException(L.l("refresh() operation can only be applied to a managed entity instance. The entity state is '{0}' for object of class '{0}' with PK '{1}'", (Object)className, pk, (Object)(state == EntityState.TRANSIENT ? "TRANSIENT" : "DELETING or DELETED")));
                }
            } else {
                throw new IllegalArgumentException(L.l("refresh() operation can only be applied to a managed entity instance. There was no managed instance of class '{0}' with PK '{1}'", (Object)className, pk));
            }
            instance.__caucho_expire();
            instance.__caucho_makePersistent(this, (EntityType)null);
            instance.__caucho_retrieve_eager(this);
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public FlushModeType getFlushMode() {
        return FlushModeType.AUTO;
    }

    public void setExtended(boolean isExtended) {
        this._isExtended = isExtended;
    }

    public void setFlushMode(FlushModeType mode) {
        throw new UnsupportedOperationException();
    }

    public void lock(Object entity, LockModeType lockMode) {
        throw new UnsupportedOperationException();
    }

    public EntityTransaction getTransaction() {
        if (this._isXA) {
            throw new IllegalStateException(L.l("Cannot call EntityManager.getTransaction() inside a distributed transaction."));
        }
        if (this._trans == null) {
            this._trans = new EntityTransactionImpl();
        }
        return this._trans;
    }

    public boolean isOpen() {
        return this._persistenceUnit != null;
    }

    void register() {
        if (!this._isRegistered) {
            if (!this._isAppManaged) {
                UserTransactionProxy.getInstance().enlistCloseResource(this);
            }
            UserTransactionProxy.getInstance().enlistBeginResource(this);
        }
        this._isRegistered = true;
    }

    public void joinTransaction() {
        this._isInTransaction = true;
    }

    public Object getDelegate() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this._persistenceUnit == null) {
            throw new IllegalStateException("Entity manager is already closed.");
        }
        try {
            if (this._isThreadConnection) {
                this._persistenceUnit.removeThreadConnection();
            }
            this._isRegistered = false;
            this.cleanup();
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            this._persistenceUnit = null;
        }
    }

    public AmberPersistenceUnit getAmberManager() {
        return this._persistenceUnit;
    }

    public void register(AmberCollection query) {
        this._queries.add(query);
    }

    public void addCompletion(AmberCompletion completion) {
        if (!this._completionList.contains(completion)) {
            this._completionList.add(completion);
        }
    }

    public boolean isActiveTransaction() {
        return this._isInTransaction || this._isExtended;
    }

    public boolean isInTransaction() {
        return this._isInTransaction;
    }

    public int getCacheChunkSize() {
        return 25;
    }

    public Object load(Class cl, Object key, boolean isEager) throws AmberException {
        if (this._persistenceUnit == null) {
            throw new IllegalStateException(L.l("AmberConnection is closed"));
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(L.l("{0}[1] amber loading entity class", (Object)cl.getSimpleName(), key));
        }
        Entity entity = null;
        if (key == null) {
            return null;
        }
        entity = this.getEntity(cl, key);
        if (entity != null) {
            return entity;
        }
        this._entityKey.init(cl, key);
        EntityItem cacheItem = this.loadCacheItem(cl, key, null);
        if (cacheItem == null) {
            return null;
        }
        boolean isLoad = isEager;
        try {
            entity = cacheItem.createEntity(this, key);
            if (entity == null) {
                return null;
            }
            this.addInternalEntity(entity);
            boolean isXA = this.isActiveTransaction();
            if (isLoad) {
                entity.__caucho_retrieve_eager(this);
            } else if (isXA) {
                entity.__caucho_retrieve_self(this);
            }
        }
        catch (SQLException e) {
            if (this._persistenceUnit.isJPA()) {
                log.log(Level.FINER, e.toString(), e);
                return null;
            }
            throw new AmberObjectNotFoundException(L.l("{0}[{1}] is an unknown amber object", (Object)cl.getName(), key), e);
        }
        catch (AmberObjectNotFoundException e) {
            if (entity != null) {
                this.removeEntity(entity);
            }
            if (this._persistenceUnit.isJPA()) {
                return null;
            }
            throw e;
        }
        Entity txEntity = this.getTransactionEntity(entity.getClass(), entity.__caucho_getPrimaryKey());
        if (txEntity != null) {
            this.setTransactionalState(txEntity);
        }
        return entity;
    }

    public EntityItem loadCacheItem(Class cl, Object key, AmberEntityHome entityHome) throws AmberException {
        this._entityKey.init(cl, key);
        EntityItem cacheItem = this._persistenceUnit.getEntity(this._entityKey);
        if (cacheItem != null) {
            return cacheItem;
        }
        if (entityHome == null) {
            entityHome = this._persistenceUnit.getEntityHome(cl.getName());
        }
        if (entityHome == null) {
            throw new IllegalArgumentException(L.l("'{0}' is an unknown class in persistence-unit '{1}'.  find() operation can only be applied if the entity class is specified in the scope of a persistence unit.", (Object)cl.getName(), (Object)this._persistenceUnit.getName()));
        }
        cacheItem = entityHome.findEntityItem(this, key);
        if (cacheItem == null) {
            if (this._persistenceUnit.isJPA()) {
                return null;
            }
            throw new AmberObjectNotFoundException("amber find: no matching object " + cl.getName() + "[" + key + "]");
        }
        if (cacheItem instanceof CacheableEntityItem) {
            cacheItem = this._persistenceUnit.putEntity(cl, key, cacheItem);
        }
        return cacheItem;
    }

    public Object load(String entityName, Object key) throws AmberException {
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(entityName);
        if (entityHome == null) {
            return null;
        }
        Entity entity = null;
        entity = this.getEntity(entityHome.getJavaClass(), key);
        if (entity != null) {
            return entity;
        }
        try {
            entityHome.init();
        }
        catch (ConfigException e) {
            throw new AmberException(e);
        }
        entity = (Entity)this.find(entityHome.getEntityType().getInstanceClass(), key);
        return entity;
    }

    public Entity getEntity(EntityItem item) {
        Object pk;
        Entity itemEntity = item.getEntity();
        Class<?> cl = itemEntity.getClass();
        Entity entity = this.getEntity(cl, pk = itemEntity.__caucho_getPrimaryKey());
        if (entity != null) {
            if (entity.__caucho_getEntityState().isManaged()) {
                return entity;
            }
        } else {
            try {
                entity = item.createEntity(this, pk);
            }
            catch (SQLException e) {
                throw new AmberRuntimeException(e);
            }
            this.addInternalEntity(entity);
        }
        entity.__caucho_retrieve_eager(this);
        return entity;
    }

    public Entity getEntityLazy(EntityItem item) {
        Object pk;
        Entity itemEntity = item.getEntity();
        Class<?> cl = itemEntity.getClass();
        Entity entity = this.getEntity(cl, pk = itemEntity.__caucho_getPrimaryKey());
        if (entity != null) {
            if (entity.__caucho_getEntityState().isManaged()) {
                return entity;
            }
        } else {
            try {
                entity = item.createEntity(this, pk);
            }
            catch (SQLException e) {
                throw new AmberRuntimeException(e);
            }
            this.addInternalEntity(entity);
        }
        return entity;
    }

    public Object makePersistent(Object obj) throws SQLException {
        Entity entity = (Entity)obj;
        if (entity == null) {
            throw new NullPointerException();
        }
        Class<?> cl = entity.getClass();
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(entity.getClass().getName());
        if (entityHome == null) {
            throw new AmberException(L.l("{0}: entity has no matching home", (Object)entity.getClass().getName()));
        }
        entityHome.makePersistent(entity, this, false);
        return entity;
    }

    public Entity loadLazy(Class cl, String name, Object key) {
        return this.loadLazy(cl.getName(), name, key);
    }

    public Entity loadLazy(String className, String name, Object key) {
        if (key == null) {
            return null;
        }
        try {
            AmberEntityHome home = this._persistenceUnit.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", (Object)className));
            }
            home.init();
            Object obj = this.load(home.getEntityType().getInstanceClass(), key, false);
            Entity entity = (Entity)obj;
            return entity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        catch (ConfigException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public EntityItem findEntityItem(String name, Object key) {
        try {
            AmberEntityHome home = this._persistenceUnit.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", (Object)name));
            }
            home.init();
            return this.loadCacheItem(home.getJavaClass(), key, home);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public EntityItem setEntityItem(String name, Object key, EntityItem item) {
        try {
            AmberEntityHome home = this._persistenceUnit.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", (Object)name));
            }
            home.init();
            return home.setEntityItem(key, item);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public Entity loadFromHome(String name, Object key) {
        try {
            AmberEntityHome home = this._persistenceUnit.getEntityHome(name);
            if (home == null) {
                throw new RuntimeException(L.l("no matching home for {0}", (Object)name));
            }
            home.init();
            return (Entity)this.load(home.getEntityType().getInstanceClass(), key, true);
        }
        catch (AmberObjectNotFoundException e) {
            if (this._persistenceUnit.isJPA()) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, e.toString(), e);
                }
                return null;
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public Object loadProxy(String name, Object key) {
        if (key == null) {
            return null;
        }
        AmberEntityHome home = this._persistenceUnit.getEntityHome(name);
        if (home == null) {
            throw new RuntimeException(L.l("no matching home for {0}", (Object)name));
        }
        return this.loadProxy(home.getEntityType(), key);
    }

    public Object loadProxy(EntityType type, Object key) {
        if (key == null) {
            return null;
        }
        Entity entity = this.getEntity(type.getInstanceClass(), key);
        if (entity != null) {
            return entity;
        }
        try {
            AmberEntityHome home = type.getHome();
            EntityItem item = home.findEntityItem(this, key);
            if (item == null) {
                return null;
            }
            EntityFactory factory = home.getEntityFactory();
            Object newEntity = factory.getEntity(this, item);
            if (this._persistenceUnit.isJPA()) {
                Entity instance = (Entity)newEntity;
                this.setTransactionalState(instance);
            }
            return newEntity;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public Object loadProxy(EntityItem entityItem) {
        Entity itemEntity = entityItem.getEntity();
        AmberEntityHome home = entityItem.getEntityHome();
        EntityFactory factory = home.getEntityFactory();
        Object newEntity = factory.getEntity(this, entityItem);
        return newEntity;
    }

    public Object load(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.load(cl, key, true);
    }

    public Object loadLazy(Class cl, long intKey) throws AmberException {
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(cl.getName());
        if (entityHome == null) {
            return null;
        }
        Object key = entityHome.toObjectKey(intKey);
        return this.loadLazy(cl, cl.getName(), key);
    }

    public Entity getEntity(Class cl, Object key) {
        Entity[] entities = this._entities;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            Entity entity = entities[i];
            if (!entity.__caucho_match(cl, key)) continue;
            return entity;
        }
        return null;
    }

    public Entity getEntity(int index) {
        return this._entities[index];
    }

    public Entity getEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        return this.getEntity(entity.getClass(), entity.__caucho_getPrimaryKey());
    }

    public Entity getSubEntity(Class cl, Object key) {
        Entity[] entities = this._entities;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            Entity entity = entities[i];
            if (!entity.__caucho_getPrimaryKey().equals(key) || !cl.isAssignableFrom(entity.getClass())) continue;
            return entity;
        }
        return null;
    }

    public EntityItem getSubEntityCacheItem(Class cl, Object key) {
        Entity[] entities = this._entities;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            Entity entity = entities[i];
            if (!entity.__caucho_getPrimaryKey().equals(key) || !cl.isAssignableFrom(entity.getClass())) continue;
            return entity.__caucho_getCacheItem();
        }
        return null;
    }

    public Entity getTransactionEntity(Class cl, Object key) {
        Entity[] entities = this._txEntities;
        for (int i = this._txEntitiesTop - 1; i >= 0; --i) {
            Entity entity = entities[i];
            if (!entity.__caucho_match(cl, key)) continue;
            return entity;
        }
        return null;
    }

    public Entity getTransactionEntity(int index) {
        return this._txEntities[index];
    }

    public Entity addNewEntity(Class cl, Object key) throws InstantiationException, IllegalAccessException {
        Entity entity = this.getSubEntity(cl, key);
        if (entity != null) {
            return null;
        }
        if (this._persistenceUnit.isJPA()) {
            entity = (Entity)cl.newInstance();
            entity.__caucho_setEntityState(EntityState.P_NON_TRANSACTIONAL);
        } else {
            String className = cl.getSuperclass().getName();
            AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(className);
            if (entityHome == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("Amber.addNewEntity: home not found for entity (class: '{0}' PK: '{1}')", (Object)className, key));
                }
                return null;
            }
            EntityFactory factory = entityHome.getEntityFactory();
            Object value = factory.getEntity(key);
            Method cauchoGetBeanMethod = entityHome.getCauchoGetBeanMethod();
            if (cauchoGetBeanMethod != null) {
                try {
                    entity = (Entity)cauchoGetBeanMethod.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (entity == null) {
                throw new IllegalStateException(L.l("AmberConnection.addNewEntity unable to instantiate new entity with cauchoGetBeanMethod"));
            }
        }
        entity.__caucho_setPrimaryKey(key);
        this.addInternalEntity(entity);
        return entity;
    }

    public Entity loadEntity(Class cl, Object key, boolean isEager) {
        if (key == null) {
            return null;
        }
        Entity entity = this.getSubEntity(cl, key);
        if (entity != null) {
            return entity;
        }
        if (this._persistenceUnit.isJPA()) {
            try {
                entity = (Entity)this.load(cl, key, isEager);
            }
            catch (AmberException e) {
                throw new AmberRuntimeException(e);
            }
        }
        String className = cl.getSuperclass().getName();
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(className);
        if (entityHome == null) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("Amber.addNewEntity: home not found for entity (class: '{0}' PK: '{1}')", (Object)className, key));
            }
            return null;
        }
        EntityFactory factory = entityHome.getEntityFactory();
        Object value = factory.getEntity(key);
        Method cauchoGetBeanMethod = entityHome.getCauchoGetBeanMethod();
        if (cauchoGetBeanMethod != null) {
            try {
                entity = (Entity)cauchoGetBeanMethod.invoke(value, new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (entity == null) {
            throw new IllegalStateException(L.l("AmberConnection.addNewEntity unable to instantiate new entity with cauchoGetBeanMethod"));
        }
        entity.__caucho_setPrimaryKey(key);
        this.addInternalEntity(entity);
        return entity;
    }

    public boolean removeEntity(Entity entity) {
        this.removeEntityImpl(entity);
        if (this.isActiveTransaction()) {
            this.removeTxEntity(entity);
        }
        return true;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            throw new IllegalArgumentException(L.l("contains() operation can only be applied to an entity instance."));
        }
        Entity entity = (Entity)obj;
        if (entity.__caucho_getConnection() != this) {
            return false;
        }
        EntityState state = entity.__caucho_getEntityState();
        if (this.isInTransaction() && !state.isTransactional()) {
            return false;
        }
        return EntityState.P_DELETING.ordinal() > state.ordinal();
    }

    @Override
    public void begin(Transaction xa) {
        try {
            xa.registerSynchronization((Synchronization)this);
            this._isInTransaction = true;
            this._isXA = true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void beginTransaction() throws SQLException {
        this._isInTransaction = true;
        if (this._conn != null && this._isAutoCommit) {
            this._isAutoCommit = false;
            this._conn.setAutoCommit(false);
        }
    }

    public void setXA(boolean isXA) {
        this._isXA = isXA;
        this._isInTransaction = isXA;
        if (isXA && !this._isRegistered) {
            this.register();
        }
    }

    public void commit() throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "AmberConnection.commit");
        }
        try {
            this.flushInternal();
            this._xid = 0L;
            if (this._conn != null) {
                this._conn.commit();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
        finally {
            if (!this._isXA) {
                this._isInTransaction = false;
            }
            for (int i = 0; i < this._txEntitiesTop; ++i) {
                Entity entity = this._txEntities[i];
                entity.__caucho_afterCommit();
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "cleaning up txEntities");
            }
            this._txEntitiesTop = 0;
        }
    }

    public void beforeCompletion() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this + " beforeCompletion");
        }
        try {
            this.beforeCommit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void afterCompletion(int status) {
        if (log.isLoggable(Level.FINER)) {
            if (status == 3) {
                log.finer(this + " afterCompletion(commit)");
            } else {
                log.finer(this + " afterCompletion(rollback)");
            }
        }
        this.afterCommit(status == 3);
        this._isXA = false;
        this._isInTransaction = false;
        this._isRegistered = false;
    }

    public void beforeCommit() throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " beforeCommit");
        }
        try {
            this.flushInternal();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(boolean isCommit) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "AmberConnection.afterCommit: " + isCommit);
            }
            if (!this._isXA) {
                this._isInTransaction = false;
            }
            if (isCommit && this._completionList.size() > 0) {
                this._persistenceUnit.complete(this._completionList);
            }
            for (int i = 0; i < this._txEntitiesTop; ++i) {
                Entity entity = this._txEntities[i];
                try {
                    if (isCommit) {
                        entity.__caucho_afterCommit();
                        continue;
                    }
                    entity.__caucho_afterRollback();
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "cleaning up txEntities");
            }
            this._txEntitiesTop = 0;
            Entity[] entities = this._entities;
            for (int i = this._entitiesTop - 1; i >= 0; --i) {
                entities[i].__caucho_detach();
            }
            this._entitiesTop = 0;
        }
        finally {
            this._completionList.clear();
        }
    }

    public PersistenceException rollback(Exception e) {
        try {
            this.rollback();
        }
        catch (Exception e1) {
            log.log(Level.FINE, e1.toString(), e1);
        }
        return new PersistenceException((Throwable)e);
    }

    public void rollback() throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "AmberConnection.rollback");
        }
        try {
            this.flushInternal();
            this._xid = 0L;
            if (this._conn != null) {
                this._conn.rollback();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
        finally {
            if (!this._isXA) {
                this._isInTransaction = false;
            }
            this._completionList.clear();
            for (int i = 0; i < this._txEntitiesTop; ++i) {
                Entity entity = this._txEntities[i];
                entity.__caucho_afterRollback();
            }
            this._txEntitiesTop = 0;
        }
    }

    public void flush() {
        try {
            this.checkTransactionRequired("flush");
            this.flushInternal();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void flushNoChecks() {
        try {
            this.flushInternal();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void expire() throws SQLException {
        Entity[] entities = this._entities;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            Entity entity = entities[i];
            if (entity.__caucho_getEntityState().isPersist()) continue;
            entity.__caucho_expire();
        }
    }

    public Connection getConnection() throws SQLException {
        DataSource readDataSource = this._persistenceUnit.getReadDataSource();
        if (!this._isXA && !this._isInTransaction && readDataSource != null) {
            if (this._readConn == null) {
                this._readConn = readDataSource.getConnection();
            } else if (this._readConn.isClosed()) {
                this.closeConnectionImpl();
                this._readConn = this._persistenceUnit.getDataSource().getConnection();
            }
            return this._readConn;
        }
        if (this._conn == null) {
            this._conn = this._persistenceUnit.getDataSource().getConnection();
            this._isAutoCommit = true;
        } else if (this._conn.isClosed()) {
            this.closeConnectionImpl();
            this._conn = this._persistenceUnit.getDataSource().getConnection();
            this._isAutoCommit = true;
        }
        if (!this._isXA) {
            if (this._isInTransaction && this._isAutoCommit) {
                this._isAutoCommit = false;
                this._conn.setAutoCommit(false);
            } else if (!this._isInTransaction && !this._isAutoCommit) {
                this._isAutoCommit = true;
                this._conn.setAutoCommit(true);
            }
        }
        return this._conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            PreparedStatement pstmt = (PreparedStatement)this._preparedStatementMap.get((Object)sql);
            if (pstmt == null) {
                Connection conn = this.getConnection();
                if (this._statements.size() > 0) {
                    conn = this._statements.get(0).getConnection();
                }
                pstmt = conn.prepareStatement(sql, 1003, 1007);
                this._statements.add(pstmt);
                this._preparedStatementMap.put((Object)sql, (Object)pstmt);
            }
            return pstmt;
        }
        catch (SQLException e) {
            this.closeConnectionImpl();
            throw e;
        }
    }

    public void closeStatement(String sql) throws SQLException {
        PreparedStatement pstmt = (PreparedStatement)this._preparedStatementMap.remove((Object)sql);
        if (pstmt != null) {
            this._statements.remove(pstmt);
            pstmt.close();
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
    }

    public PreparedStatement prepareInsertStatement(String sql, boolean isGeneratedId) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = (PreparedStatement)this._preparedStatementMap.get((Object)sql);
            if (pstmt != null) {
                return pstmt;
            }
            Connection conn = this.getConnection();
            if (this._statements.size() > 0) {
                conn = this._statements.get(0).getConnection();
            }
            pstmt = isGeneratedId && this._persistenceUnit.hasReturnGeneratedKeys() ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this._statements.add(pstmt);
            this._preparedStatementMap.put((Object)sql, (Object)pstmt);
            return pstmt;
        }
        catch (SQLException e) {
            this.closeStatement(sql);
            throw e;
        }
    }

    public void update(Object obj) {
    }

    public void create(Object obj) throws SQLException {
        try {
            this.createInternal(obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void create(String homeName, Object obj) throws SQLException {
        try {
            this.createInternal(homeName, obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void create(AmberEntityHome home, Object obj) throws SQLException {
        try {
            this.createInternal(home, obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void update(Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.__caucho_getEntityType() == null) {
            return;
        }
        if (!this.isActiveTransaction()) {
            return;
        }
        Table table = entity.__caucho_getEntityType().getTable();
        Object key = entity.__caucho_getPrimaryKey();
        this.addCompletion(new RowInvalidateCompletion(table.getName(), key));
        Entity oldEntity = this.getTransactionEntity(entity.getClass(), key);
        if (oldEntity == null) {
            this.addTxEntity(entity);
        }
    }

    public void delete(Entity entity) throws SQLException {
        Entity oldEntity = this.getEntity(entity.getClass(), entity.__caucho_getPrimaryKey());
        if (oldEntity == null) {
            throw new IllegalStateException(L.l("AmberEntity[{0}:{1}] cannot be deleted since it is not managed", (Object)entity.getClass().getName(), entity.__caucho_getPrimaryKey()));
        }
        oldEntity.__caucho_setConnection(this);
        entity = oldEntity;
        entity.__caucho_delete();
    }

    public AmberQuery prepareQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, false);
    }

    public AmberQuery prepareLazyQuery(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    public AmberQuery prepareUpdate(String queryString) throws AmberException {
        return this.prepareQuery(queryString, true);
    }

    private AmberQuery prepareQuery(String queryString, boolean isLazy) throws AmberException {
        AbstractQuery queryProgram = this.parseQuery(queryString, isLazy);
        UserQuery query = new UserQuery(queryProgram);
        query.setSession(this);
        return query;
    }

    public AbstractQuery parseQuery(String sql, boolean isLazy) throws AmberException {
        try {
            this._persistenceUnit.initEntityHomes();
        }
        catch (Exception e) {
            throw AmberRuntimeException.create(e);
        }
        AbstractQuery query = this._persistenceUnit.getQueryParseCache(sql);
        if (query == null) {
            QueryParser parser = new QueryParser(sql);
            parser.setPersistenceUnit(this._persistenceUnit);
            parser.setLazyResult(isLazy);
            query = parser.parse();
            this._persistenceUnit.putQueryParseCache(sql, query);
        }
        return query;
    }

    public ResultSet query(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.executeQuery();
    }

    public ResultSetCacheChunk getQueryCacheChunk(String sql, Object[] args, int startRow) {
        this._queryKey.init(sql, args, startRow);
        return this._persistenceUnit.getQueryChunk(this._queryKey);
    }

    public ResultSetMetaData getQueryMetaData() {
        return this._persistenceUnit.getQueryMetaData(this._queryKey);
    }

    public void putQueryCacheChunk(String sql, Object[] args, int startRow, ResultSetCacheChunk cacheChunk, ResultSetMetaData cacheMetaData) {
        QueryCacheKey key = new QueryCacheKey();
        Object[] newArgs = new Object[args.length];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        key.init(sql, newArgs, startRow);
        this._persistenceUnit.putQueryChunk(key, cacheChunk);
        this._persistenceUnit.putQueryMetaData(key, cacheMetaData);
    }

    public int update(String hsql) throws SQLException {
        AmberQuery query = this.prepareUpdate(hsql);
        return query.executeUpdate();
    }

    public List find(String hsql) throws SQLException {
        AmberQuery query = this.prepareQuery(hsql);
        return query.list();
    }

    public void cleanup() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "AmberConnection.cleanup");
        }
        try {
            if (this.isActiveTransaction()) {
                this.flushInternal();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
        finally {
            this._depth = 0;
            for (int i = this._entitiesTop - 1; i >= 0; --i) {
                this._entities[i].__caucho_detach();
            }
            this._entitiesTop = 0;
            this._txEntitiesTop = 0;
            this._completionList.clear();
            this.freeConnection();
        }
    }

    public void pushDepth() {
    }

    public void popDepth() {
    }

    public void freeConnection() {
        this.closeConnectionImpl();
    }

    private void closeConnectionImpl() {
        Connection conn = this._conn;
        this._conn = null;
        Connection readConn = this._readConn;
        this._readConn = null;
        boolean isAutoCommit = this._isAutoCommit;
        this._isAutoCommit = true;
        try {
            if (conn != null && !isAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        for (Statement stmt : this._statements) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        try {
            this._preparedStatementMap.clear();
            this._statements.clear();
            if (conn != null) {
                conn.close();
            }
            if (readConn != null) {
                readConn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        if (this._persistenceUnit != null) {
            return "AmberConnection[" + this._persistenceUnit.getName() + "]";
        }
        return "AmberConnection[closed]";
    }

    public void finalize() {
        this.cleanup();
    }

    public boolean shouldRetrieveFromCache() {
        return !this.isActiveTransaction();
    }

    public void setTransactionalState(Entity entity) {
        if (this.isActiveTransaction()) {
            entity.__caucho_setConnection(this);
            EntityState state = entity.__caucho_getEntityState();
            if (state == EntityState.P_NON_TRANSACTIONAL) {
                entity.__caucho_setEntityState(EntityState.P_TRANSACTIONAL);
            }
        }
    }

    public boolean isCacheEntity(Entity entity) {
        return entity == this.getCacheEntity(entity, true);
    }

    public Entity getCacheEntity(Entity entity) {
        return this.getCacheEntity(entity, false);
    }

    public Entity getCacheEntity(Entity entity, boolean isDebug) {
        if (entity == null) {
            return null;
        }
        Entity cacheEntity = entity.__caucho_getCacheEntity();
        if (cacheEntity != null) {
            return cacheEntity;
        }
        return this.getCacheEntity(entity.getClass(), entity.__caucho_getPrimaryKey(), isDebug);
    }

    public Entity getCacheEntity(Class cl, Object pk) {
        return this.getCacheEntity(cl, pk, false);
    }

    public Entity getCacheEntity(Class cl, Object pk, boolean isDebug) {
        if (pk == null) {
            return null;
        }
        String className = cl.getName();
        AmberEntityHome entityHome = this._persistenceUnit.getEntityHome(className);
        if (entityHome == null) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("Home not found for entity (class: '{0}' PK: '{1}')", (Object)className, pk));
            }
            return null;
        }
        EntityType rootType = entityHome.getRootType();
        EntityItem item = this._persistenceUnit.getEntity(rootType, pk);
        if (item == null) {
            return null;
        }
        if (isDebug) {
            return item.getEntity();
        }
        if (this.isActiveTransaction()) {
            Entity txEntity = this.getTransactionEntity(cl, pk);
            if (txEntity != null) {
                txEntity.__caucho_getEntityState();
            } else {
                item.getEntity().__caucho_expire();
            }
            return null;
        }
        return item.getEntity();
    }

    private void addInternalEntity(Entity entity) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, L.l("amber {0}[{1}] addInternalEntity", (Object)entity.getClass().getName(), entity.__caucho_getPrimaryKey()));
        }
        this.addEntity(entity);
        if (this.isActiveTransaction()) {
            this.addTxEntity(entity);
            this.setTransactionalState(entity);
        }
    }

    private void createInternal(Object obj) throws Exception {
        AmberEntityHome home = null;
        for (Class<?> cl = obj.getClass(); home == null && cl != null; cl = cl.getSuperclass()) {
            home = this._persistenceUnit.getHome(cl);
        }
        if (home == null) {
            throw new AmberException(L.l("'{0}' is not a known entity class.", (Object)obj.getClass().getName()));
        }
        this.createInternal(home, obj);
    }

    private void createInternal(String homeName, Object obj) throws Exception {
        AmberEntityHome home = this._persistenceUnit.getEntityHome(homeName);
        if (home == null) {
            throw new AmberException(L.l("'{0}' is not a known entity class.", (Object)obj.getClass().getName()));
        }
        this.createInternal(home, obj);
    }

    private void createInternal(AmberEntityHome home, Object obj) throws Exception {
        if (this.contains(obj)) {
            return;
        }
        Entity entity = (Entity)obj;
        if (this._persistenceUnit.isJPA()) {
            this.addEntity(entity);
            entity.__caucho_lazy_create(this, home.getEntityType());
        } else {
            home.save(this, entity);
        }
        Table table = home.getEntityType().getTable();
        this.addCompletion(new RowInsertCompletion(table.getName()));
    }

    private void checkTransactionRequired(String operation) throws TransactionRequiredException, SQLException {
        if (!this._isXA && !this.isActiveTransaction()) {
            throw new TransactionRequiredException(L.l("{0}() operation can only be executed in the scope of a transaction or with an extended persistence context.", (Object)operation));
        }
    }

    private Entity checkEntityType(Object entity, String operation) {
        String className;
        EntityType entityType;
        if (!(entity instanceof Entity)) {
            throw new IllegalArgumentException(L.l("{0}() operation can only be applied to an entity instance. If the argument is an entity, the corresponding class must be specified in the scope of a persistence unit.", (Object)operation));
        }
        if (this._persistenceUnit.isJPA() && (entityType = this._persistenceUnit.getEntityType(className = entity.getClass().getName())) == null) {
            throw new IllegalArgumentException(L.l("{0}() operation can only be applied to an entity instance. If the argument is an entity, the class '{1}' must be specified in the orm.xml or annotated with @Entity and must be in the scope of a persistence unit.", (Object)operation, (Object)className));
        }
        return (Entity)entity;
    }

    public void detach() {
        if (this._isXA || this._isInTransaction) {
            throw new IllegalStateException(L.l("detach cannot be called within transaction"));
        }
        this._completionList.clear();
        this._txEntitiesTop = 0;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            this._entities[i].__caucho_detach();
        }
        this._entitiesTop = 0;
    }

    private void flushInternal() throws Exception {
        Entity entity;
        int i;
        if (!this._isFlushAllowed) {
            return;
        }
        for (i = 0; i < this._txEntitiesTop; ++i) {
            entity = this._txEntities[i];
            if (!entity.__caucho_getEntityState().isPersist()) continue;
            try {
                entity.__caucho_flush();
                continue;
            }
            catch (SQLException e) {
                this.throwPersistException(e, entity);
            }
        }
        for (i = this._txEntitiesTop - 1; i >= 0; --i) {
            entity = this._txEntities[i];
            if (entity.__caucho_getEntityState().isPersist()) continue;
            entity.__caucho_flush();
        }
        if (!this.isInTransaction()) {
            if (this._completionList.size() > 0) {
                this._persistenceUnit.complete(this._completionList);
            }
            this._completionList.clear();
            for (i = 0; i < this._txEntitiesTop; ++i) {
                entity = this._txEntities[i];
                entity.__caucho_afterCommit();
            }
            this._txEntitiesTop = 0;
        }
    }

    private void throwPersistException(SQLException e, Entity entity) throws SQLException {
        log.log(Level.FINER, e.toString(), e);
        String sqlState = e.getSQLState();
        JdbcMetaData metaData = this._persistenceUnit.getMetaData();
        if (metaData.isUniqueConstraintSQLState(sqlState)) {
            throw new EntityExistsException(L.l("Trying to persist an entity '{0}[{1}]' that already exists. Entity state '{2}'", (Object)entity.getClass().getName(), entity.__caucho_getPrimaryKey(), (Object)entity.__caucho_getEntityState()));
        }
        if (metaData.isForeignKeyViolationSQLState(sqlState)) {
            throw new IllegalStateException(L.l("Trying to persist an entity of class '{0}' with PK '{1}' would break a foreign key constraint. The entity state is '{2}'. Please make sure there are associated entities for all required relationships. If you are merging an entity make sure the association fields are annotated with cascade=MERGE or cascade=ALL.", (Object)entity.getClass().getName(), entity.__caucho_getPrimaryKey(), (Object)entity.__caucho_getEntityState()));
        }
        throw e;
    }

    private Entity persistInternal(Entity entity) throws Exception {
        EntityState state = entity.__caucho_getEntityState();
        switch (state) {
            case TRANSIENT: {
                Entity contextEntity = this.getEntity(entity.getClass(), entity.__caucho_getPrimaryKey());
                if (contextEntity != null) {
                    if (contextEntity.__caucho_getEntityState().isDeleting()) {
                        contextEntity.__caucho_flush();
                    } else if (entity != contextEntity) {
                        return contextEntity;
                    }
                }
                entity.__caucho_cascadePrePersist(this);
                this.createInternal(entity);
                break;
            }
            case P_DELETING: 
            case P_DELETED: {
                entity.__caucho_cascadePrePersist(this);
                entity.__caucho_makePersistent(null, (EntityType)null);
                this.createInternal(entity);
                break;
            }
            case P_PERSISTING: 
            case P_PERSISTED: {
                entity.__caucho_cascadePrePersist(this);
                break;
            }
            default: {
                if (entity.__caucho_getConnection() == this) {
                    return entity;
                }
                throw new EntityExistsException(L.l("Trying to persist an entity that is detached or already exists. Entity state '{0}'", (Object)state));
            }
        }
        this.updateFlushPriority(entity);
        entity.__caucho_cascadePostPersist(this);
        return entity;
    }

    private void updateFlushPriority(Entity updateEntity) {
        if (!this.isActiveTransaction()) {
            return;
        }
        this.removeTxEntity(updateEntity);
        int updatePriority = updateEntity.__caucho_getEntityType().getFlushPriority();
        for (int i = this._txEntitiesTop - 1; i >= 0; --i) {
            Entity entity = this._txEntities[i];
            int currentPriority = entity.__caucho_getEntityType().getFlushPriority();
            if (currentPriority >= updatePriority) continue;
            this.addTxEntity(i + 1, updateEntity);
            return;
        }
        this.addTxEntity(0, updateEntity);
    }

    public <T> T recursiveMerge(T entityT) {
        try {
            if (entityT == null) {
                return null;
            }
            Entity entity = this.checkEntityType(entityT, "merge");
            if (log.isLoggable(Level.FINER)) {
                String className = entity.getClass().getName();
                Object pk = entity.__caucho_getPrimaryKey();
                EntityState state = entity.__caucho_getEntityState();
                log.finer(L.l("recursiveMerge({0}[{1}] state: '{2}'", (Object)className, pk, (Object)state));
            }
            if (this.containsMergingEntity(entity)) {
                return (T)entity;
            }
            return (T)this.mergeDetachedEntity(entity);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public Entity mergeDetachedEntity(Entity newEntity) {
        try {
            Entity existingEntity;
            block10: {
                if (newEntity == null) {
                    return newEntity;
                }
                Class<?> entityClass = newEntity.getClass();
                String className = newEntity.getClass().getName();
                EntityState state = newEntity.__caucho_getEntityState();
                Object pk = newEntity.__caucho_getPrimaryKey();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(L.l("{0}[{1}] amber merge state='{2}'", (Object)entityClass.getSimpleName(), pk, (Object)state));
                }
                if (state.isDeleting()) {
                    throw new IllegalArgumentException(L.l("{0}: merge operation cannot be applied to a removed entity instance", entityClass));
                }
                existingEntity = null;
                try {
                    existingEntity = (Entity)this.load(entityClass, pk, true);
                }
                catch (AmberObjectNotFoundException e) {
                    if (!log.isLoggable(Level.FINER)) break block10;
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (existingEntity != null) {
                if (this.containsMergingEntity(existingEntity)) {
                    return existingEntity;
                }
                this._mergingEntities.add(existingEntity);
                existingEntity.__caucho_mergeFrom(this, newEntity);
                return existingEntity;
            }
            this.persist(newEntity);
            return newEntity;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    private Query createInternalNativeQuery(String sql) {
        try {
            QueryImpl query = new QueryImpl(this);
            query.setNativeSql(sql);
            return query;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    private Query createInternalNativeQuery(String sql, SqlResultSetMappingConfig map) {
        Query query = this.createInternalNativeQuery(sql);
        QueryImpl queryImpl = (QueryImpl)query;
        queryImpl.setSqlResultSetMapping(map);
        return query;
    }

    private boolean containsMergingEntity(Entity entity) {
        if (this._mergingEntities.contains(entity)) {
            return true;
        }
        int index = AmberConnection.getEntityMatch(this._mergingEntities, entity.getClass(), entity.__caucho_getPrimaryKey());
        return index >= 0;
    }

    public void addEntity(Entity entity) {
        Entity[] entities = this._entities;
        if (this._entitiesTop == entities.length) {
            entities = new Entity[this._entities.length + 32];
            System.arraycopy(this._entities, 0, entities, 0, this._entities.length);
            this._entities = entities;
        }
        entities[this._entitiesTop++] = entity;
    }

    private void removeEntityImpl(Entity entity) {
        Entity[] entities = this._entities;
        for (int i = this._entitiesTop - 1; i >= 0; --i) {
            if (entities[i] != entity) continue;
            System.arraycopy(entities, i + 1, entities, i, this._entitiesTop - i - 1);
            --this._entitiesTop;
            return;
        }
    }

    private void addTxEntity(Entity entity) {
        Entity[] entities = this._txEntities;
        if (this._txEntitiesTop == entities.length) {
            entities = new Entity[entities.length + 32];
            System.arraycopy(this._txEntities, 0, entities, 0, this._txEntities.length);
            this._txEntities = entities;
        }
        entities[this._txEntitiesTop++] = entity;
    }

    private void removeTxEntity(Entity entity) {
        Entity[] entities = this._txEntities;
        for (int i = this._txEntitiesTop - 1; i >= 0; --i) {
            if (entities[i] != entity) continue;
            System.arraycopy(entities, i + 1, entities, i, this._txEntitiesTop - i - 1);
            --this._txEntitiesTop;
            return;
        }
    }

    private void addTxEntity(int index, Entity entity) {
        Entity[] entities = this._txEntities;
        if (this._txEntitiesTop == entities.length) {
            entities = new Entity[this._txEntities.length + 32];
            System.arraycopy(this._txEntities, 0, entities, 0, this._txEntities.length);
            this._txEntities = entities;
        }
        if (index < this._txEntitiesTop) {
            System.arraycopy(entities, index, entities, index + 1, this._txEntitiesTop - index);
        }
        entities[index] = entity;
        ++this._txEntitiesTop;
    }

    private static int getEntityMatch(ArrayList<Entity> list, Class cl, Object key) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Entity entity = list.get(i);
            if (!entity.__caucho_match(cl, key)) continue;
            return i;
        }
        return -1;
    }

    private class EntityTransactionImpl
    implements EntityTransaction {
        private boolean _rollbackOnly;

        private EntityTransactionImpl() {
        }

        public void begin() {
            if (AmberConnection.this.isActiveTransaction()) {
                throw new IllegalStateException("begin() cannot be called when the entity transaction is already active.");
            }
            this._rollbackOnly = false;
            try {
                AmberConnection.this.beginTransaction();
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        public void commit() {
            if (!AmberConnection.this.isActiveTransaction()) {
                throw new IllegalStateException("commit() cannot be called when the entity transaction is not active.");
            }
            if (this.getRollbackOnly()) {
                throw new RollbackException("commit() cannot be called when the entity transaction is marked for rollback only.");
            }
            try {
                AmberConnection.this.beforeCommit();
                AmberConnection.this._isInTransaction = false;
                if (AmberConnection.this._conn != null) {
                    AmberConnection.this._conn.commit();
                }
                AmberConnection.this.afterCommit(true);
                if (AmberConnection.this._conn != null) {
                    AmberConnection.this.closeConnectionImpl();
                }
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rollback() {
            if (!AmberConnection.this.isActiveTransaction()) {
                throw new IllegalStateException("rollback() cannot be called when the entity transaction is not active.");
            }
            this.setRollbackOnly();
            PersistenceException exn = null;
            try {
                AmberConnection.this.rollback();
            }
            catch (Exception e) {
                exn = new PersistenceException((Throwable)e);
            }
            finally {
                try {
                    AmberConnection.this.afterCommit(false);
                }
                catch (PersistenceException e) {
                    exn = e;
                }
                catch (Exception e) {
                    exn = new PersistenceException((Throwable)e);
                }
                finally {
                    if (AmberConnection.this._conn != null) {
                        AmberConnection.this.closeConnectionImpl();
                    }
                }
            }
            if (exn != null) {
                throw exn;
            }
        }

        public void setRollbackOnly() {
            if (!AmberConnection.this.isActiveTransaction()) {
                throw new IllegalStateException("setRollbackOnly() cannot be called when the entity transaction is not active.");
            }
            this._rollbackOnly = true;
        }

        public boolean getRollbackOnly() {
            if (!AmberConnection.this.isActiveTransaction()) {
                throw new IllegalStateException("getRollbackOnly() cannot be called when the entity transaction is not active.");
            }
            return this._rollbackOnly;
        }

        public boolean isActive() {
            return AmberConnection.this._isInTransaction;
        }
    }
}

