/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.cfg.PersistenceConfig;
import com.caucho.amber.cfg.PersistenceUnitConfig;
import com.caucho.amber.gen.AmberEnhancer;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.manager.AmberEntityManagerFactory;
import com.caucho.amber.manager.AmberPersistenceProvider;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.manager.EntityManagerExtendedProxy;
import com.caucho.amber.manager.EntityManagerFactoryComponent;
import com.caucho.amber.manager.EntityManagerProxy;
import com.caucho.amber.manager.EntityManagerTransactionProxy;
import com.caucho.amber.manager.PersistenceContextComponent;
import com.caucho.amber.manager.RootContext;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.ListenerType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberContainer
implements ScanListener,
EnvironmentListener {
    private static final L10N L = new L10N(AmberContainer.class);
    private static final Logger log = Logger.getLogger(AmberContainer.class.getName());
    private static final EnvironmentLocal<AmberContainer> _localContainer = new EnvironmentLocal();
    private EnvironmentClassLoader _parentLoader;
    private ClassLoader _tempLoader;
    private AmberContainer _parentAmberContainer;
    private JClassLoader _jClassLoader;
    private AmberEnhancer _enhancer;
    private DataSource _dataSource;
    private DataSource _readDataSource;
    private DataSource _xaDataSource;
    private boolean _createDatabaseTables;
    private ArrayList<PersistenceUnitConfig> _unitConfigList = new ArrayList();
    private HashMap<String, AmberPersistenceUnit> _unitMap = new HashMap();
    private HashMap<String, EntityManagerFactory> _factoryMap = new HashMap();
    private HashMap<String, EntityManager> _persistenceContextMap = new HashMap();
    private HashMap<String, EmbeddableType> _embeddableMap = new HashMap();
    private HashMap<String, EntityType> _entityMap = new HashMap();
    private HashMap<String, MappedSuperclassType> _mappedSuperclassMap = new HashMap();
    private HashMap<String, ListenerType> _defaultListenerMap = new HashMap();
    private HashMap<String, ArrayList<ListenerType>> _entityListenerMap = new HashMap();
    private Throwable _exception;
    private HashMap<String, Throwable> _embeddableExceptionMap = new HashMap();
    private HashMap<String, Throwable> _entityExceptionMap = new HashMap();
    private HashMap<String, Throwable> _listenerExceptionMap = new HashMap();
    private HashMap<Path, RootContext> _persistenceRootMap = new HashMap();
    private ArrayList<RootContext> _pendingRootList = new ArrayList();
    private ArrayList<AmberPersistenceUnit> _pendingUnitList = new ArrayList();
    private ArrayList<LazyEntityManagerFactory> _pendingFactoryList = new ArrayList();
    private HashSet<URL> _persistenceURLSet = new HashSet();
    private ArrayList<String> _pendingClasses = new ArrayList();

    private AmberContainer(ClassLoader loader) {
        this._parentAmberContainer = _localContainer.get(loader);
        this._parentLoader = Environment.getEnvironmentClassLoader(loader);
        _localContainer.set(this, this._parentLoader);
        this._tempLoader = this._parentLoader.getNewTempClassLoader();
        this._jClassLoader = EnhancerManager.create(this._parentLoader).getJavaClassLoader();
        this._enhancer = new AmberEnhancer(this);
        EnhancerManager.create(this._parentLoader).addClassEnhancer(this._enhancer);
        if (this._parentAmberContainer != null) {
            this.copyContainerDefaults(this._parentAmberContainer);
        }
        this._parentLoader.addScanListener(this);
        Environment.addEnvironmentListener(this, this._parentLoader);
        try {
            if (this._parentLoader instanceof DynamicClassLoader) {
                this._parentLoader.make();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AmberContainer create() {
        return AmberContainer.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmberContainer create(ClassLoader loader) {
        EnvironmentLocal<AmberContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            AmberContainer container = _localContainer.getLevel(loader);
            if (container == null) {
                container = new AmberContainer(loader);
                _localContainer.set(container, loader);
            }
            return container;
        }
    }

    public static AmberContainer getCurrent() {
        return AmberContainer.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmberContainer getCurrent(ClassLoader loader) {
        EnvironmentLocal<AmberContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            return _localContainer.get(loader);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setReadDataSource(DataSource dataSource) {
        this._readDataSource = dataSource;
    }

    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    public void setXADataSource(DataSource dataSource) {
        this._xaDataSource = dataSource;
    }

    public DataSource getXADataSource() {
        return this._xaDataSource;
    }

    public boolean getCreateDatabaseTables() {
        return this._createDatabaseTables;
    }

    public void setCreateDatabaseTables(boolean isCreate) {
        this._createDatabaseTables = isCreate;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    public ClassLoader getEnhancedLoader() {
        return this._parentLoader;
    }

    public AmberGenerator getGenerator() {
        return this._enhancer;
    }

    public static String getPersistenceUnitJndiPrefix() {
        return "java:comp/env/persistence/_amber_PersistenceUnit/";
    }

    public static String getPersistenceContextJndiPrefix() {
        return "java:comp/env/persistence/";
    }

    public JClassLoader getJClassLoader() {
        return this._jClassLoader;
    }

    private void copyContainerDefaults(AmberContainer parent) {
        this._dataSource = parent._dataSource;
        this._xaDataSource = parent._xaDataSource;
        this._readDataSource = parent._readDataSource;
        this._createDatabaseTables = parent._createDatabaseTables;
    }

    public void init() {
    }

    public EmbeddableType getEmbeddable(String className) {
        Throwable e = this._embeddableExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._embeddableMap.get(className);
    }

    public EntityType getEntity(String className) {
        Throwable e = this._entityExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._entityMap.get(className);
    }

    public MappedSuperclassType getMappedSuperclass(String className) {
        Throwable e = this._entityExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        MappedSuperclassType type = this._mappedSuperclassMap.get(className);
        return type;
    }

    public ListenerType getDefaultListener(String className) {
        return null;
    }

    public ListenerType getEntityListener(String className) {
        return null;
    }

    public ListenerType getListener(String className) {
        return null;
    }

    public ArrayList<ListenerType> getEntityListeners(String entityClassName) {
        return null;
    }

    public void addEntityException(String className, Throwable e) {
        this._entityExceptionMap.put(className, e);
    }

    public void addException(Throwable e) {
        if (this._exception == null) {
            this._exception = e;
            Environment.setConfigException(e);
        }
    }

    public Throwable getConfigException() {
        return this._exception;
    }

    public void addEmbeddable(String className, EmbeddableType type) {
        this._embeddableMap.put(className, type);
    }

    public void addEntity(String className, EntityType type) {
        this._entityMap.put(className, type);
    }

    public void addMappedSuperclass(String className, MappedSuperclassType type) {
        this._mappedSuperclassMap.put(className, type);
    }

    public void addDefaultListener(String className, ListenerType type) {
        this._defaultListenerMap.put(className, type);
    }

    public void addEntityListener(String entityClassName, ListenerType listenerType) {
        ArrayList<ListenerType> listenerList = this._entityListenerMap.get(entityClassName);
        if (listenerList == null) {
            listenerList = new ArrayList();
            this._entityListenerMap.put(entityClassName, listenerList);
        }
        listenerList.add(listenerType);
    }

    public void initEntityHomes() {
        throw new UnsupportedOperationException();
    }

    public AmberPersistenceUnit createPersistenceUnit(String name) {
        AmberPersistenceUnit unit = new AmberPersistenceUnit(this, name);
        this._unitMap.put(unit.getName(), unit);
        return unit;
    }

    public void start() {
        this.configurePersistenceRoots();
        this.startPersistenceUnits();
    }

    public AmberPersistenceUnit getPersistenceUnit(String name) {
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._unitMap.get(name);
    }

    public EntityManagerFactory getEntityManagerFactory(String name) {
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        EntityManagerFactory factory = this._factoryMap.get(name);
        if (factory != null) {
            return factory;
        }
        if (this._pendingRootList.size() > 0) {
            this.configurePersistenceRoots();
        }
        if ((factory = this._factoryMap.get(name)) != null) {
            return factory;
        }
        AmberPersistenceUnit amberUnit = this._unitMap.get(name);
        if (amberUnit != null) {
            factory = new AmberEntityManagerFactory(amberUnit);
            this._factoryMap.put(name, factory);
            return factory;
        }
        if ("".equals(name) && this._factoryMap.size() == 1) {
            return this._factoryMap.values().iterator().next();
        }
        if ("".equals(name) && this._unitMap.size() == 1) {
            amberUnit = this._unitMap.values().iterator().next();
            factory = new AmberEntityManagerFactory(amberUnit);
            this._factoryMap.put(name, factory);
            return factory;
        }
        if (this._parentAmberContainer != null) {
            return this._parentAmberContainer.getEntityManagerFactory(name);
        }
        return null;
    }

    public EntityManager getPersistenceContext(String name) {
        EntityManager context;
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((context = this._persistenceContextMap.get(name)) != null) {
            return context;
        }
        if (this._pendingRootList.size() > 0) {
            this.configurePersistenceRoots();
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((context = this._persistenceContextMap.get(name)) != null) {
            return context;
        }
        AmberPersistenceUnit amberUnit = this._unitMap.get(name);
        if (amberUnit != null) {
            context = new EntityManagerProxy(amberUnit);
            this._persistenceContextMap.put(name, context);
            return context;
        }
        return null;
    }

    public EntityManager getExtendedPersistenceContext(String name) {
        AmberPersistenceUnit amberUnit;
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if (this._pendingRootList.size() > 0) {
            this.configurePersistenceRoots();
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((amberUnit = this._unitMap.get(name)) != null) {
            return new EntityManagerExtendedProxy(amberUnit);
        }
        return null;
    }

    public void addPersistenceUnit(Path root) {
        if (this._persistenceRootMap.get(root) != null) {
            return;
        }
        RootContext context = new RootContext(root);
        this._persistenceRootMap.put(root, context);
        this._pendingRootList.add(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurePersistenceRoots() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._parentLoader);
            ArrayList<RootContext> rootList = new ArrayList<RootContext>(this._pendingRootList);
            this._pendingRootList.clear();
            for (RootContext rootContext : rootList) {
                this.configureRoot(rootContext);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void configureRoot(RootContext rootContext) {
        Path root = rootContext.getRoot();
        try {
            Path ormXml = root.lookup("META-INF/orm.xml");
            EntityMappingsConfig entityMappings = this.configureMappingFile(root, ormXml);
            ArrayList<PersistenceUnitConfig> unitList = this.parsePersistenceConfig(root);
            if (unitList == null) {
                return;
            }
            HashMap<String, JClass> classMap = new HashMap<String, JClass>();
            for (PersistenceUnitConfig unitConfig : unitList) {
                Class provider = unitConfig.getProvider();
                if (provider != null && !AmberPersistenceProvider.class.equals((Object)provider)) {
                    this.addProviderUnit(unitConfig);
                    continue;
                }
                try {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Amber PersistenceUnit[" + unitConfig.getName() + "] configuring " + rootContext.getRoot().getURL());
                    }
                    if (!unitConfig.isExcludeUnlistedClasses()) {
                        classMap.clear();
                        for (String className : rootContext.getClassNameList()) {
                            this.lookupClass(className, classMap, entityMappings);
                        }
                        unitConfig.addAllClasses(classMap);
                    }
                    ArrayList<EntityMappingsConfig> entityMappingsList = new ArrayList<EntityMappingsConfig>();
                    if (entityMappings != null) {
                        entityMappingsList.add(entityMappings);
                    }
                    for (String fileName : unitConfig.getJarFiles()) {
                        Path parent = root;
                        if (root instanceof JarPath) {
                            parent = ((JarPath)root).getContainer().getParent();
                        }
                        JarPath jarFile = JarPath.create(parent.lookup(fileName));
                        classMap.clear();
                        unitConfig.addAllClasses(classMap);
                    }
                    for (String fileName : unitConfig.getMappingFiles()) {
                        Path mappingFile = root.lookup(fileName);
                        EntityMappingsConfig mappingFileConfig = this.configureMappingFile(root, mappingFile);
                        if (mappingFileConfig == null) continue;
                        entityMappingsList.add(mappingFileConfig);
                        classMap.clear();
                        unitConfig.addAllClasses(classMap);
                    }
                    AmberPersistenceUnit unit = unitConfig.init(this, entityMappingsList);
                    this._pendingUnitList.add(unit);
                    this._unitMap.put(unit.getName(), unit);
                }
                catch (Exception e) {
                    this.addException(e);
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPersistenceUnits() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._parentLoader);
            ArrayList<AmberPersistenceUnit> unitList = new ArrayList<AmberPersistenceUnit>(this._pendingUnitList);
            this._pendingUnitList.clear();
            ArrayList<LazyEntityManagerFactory> lazyEmfList = new ArrayList<LazyEntityManagerFactory>(this._pendingFactoryList);
            this._pendingFactoryList.clear();
            for (LazyEntityManagerFactory lazyEmf : lazyEmfList) {
                lazyEmf.init();
            }
            for (AmberPersistenceUnit unit : unitList) {
                unit.initEntityHomes();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProviderUnit(PersistenceUnitConfig unit) {
        try {
            Class cl = unit.getProvider();
            if (log.isLoggable(Level.CONFIG)) {
                log.config("JPA PersistenceUnit[" + unit.getName() + "] handled by " + cl.getName());
            }
            PersistenceProvider provider = (PersistenceProvider)cl.newInstance();
            String unitName = unit.getName();
            Map props = null;
            AmberContainer amberContainer = this;
            synchronized (amberContainer) {
                LazyEntityManagerFactory lazyFactory = new LazyEntityManagerFactory(unit, provider, props);
                this._pendingFactoryList.add(lazyFactory);
            }
            EntityManagerTransactionProxy persistenceContext = new EntityManagerTransactionProxy(this, unitName, props);
            this._persistenceContextMap.put(unitName, persistenceContext);
            WebBeansContainer webBeans = WebBeansContainer.create(this._parentLoader);
            webBeans.addComponent(new EntityManagerFactoryComponent(this, provider, unit));
            webBeans.addComponent(new PersistenceContextComponent(unitName, persistenceContext));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private ArrayList<PersistenceUnitConfig> parsePersistenceConfig(Path root) {
        Path persistenceXml = root.lookup("META-INF/persistence.xml");
        if (!persistenceXml.canRead()) {
            return null;
        }
        persistenceXml.setUserPath(persistenceXml.getURL());
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " parsing " + persistenceXml.getURL());
        }
        ReadStream is = null;
        try {
            is = persistenceXml.openRead();
            PersistenceConfig persistence = new PersistenceConfig();
            persistence.setRoot(root);
            new Config().configure((Object)persistence, (InputStream)is, "com/caucho/amber/cfg/persistence-30.rnc");
            ArrayList<PersistenceUnitConfig> unitList = persistence.getUnitList();
            this._unitConfigList.addAll(unitList);
            ArrayList<PersistenceUnitConfig> arrayList = unitList;
            return arrayList;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw LineConfigException.create((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private EntityMappingsConfig configureMappingFile(Path root, Path xmlFile) throws Exception {
        EntityMappingsConfig entityMappings = null;
        if (xmlFile.exists()) {
            ReadStream is = xmlFile.openRead();
            entityMappings = new EntityMappingsConfig();
            entityMappings.setRoot(root);
            new Config().configure((Object)entityMappings, (InputStream)is, "com/caucho/amber/cfg/mapping-30.rnc");
        }
        return entityMappings;
    }

    private void lookupClass(String className, HashMap<String, JClass> classMap, EntityMappingsConfig entityMappings) throws Exception {
        JClass type = this._jClassLoader.forName(className);
        if (type != null) {
            boolean isEntity = type.getAnnotation(Entity.class) != null;
            boolean isEmbeddable = type.getAnnotation(Embeddable.class) != null;
            boolean isMappedSuperclass = type.getAnnotation(MappedSuperclass.class) != null;
            MappedSuperclassConfig mappedSuperclassOrEntityConfig = null;
            if (entityMappings != null && (mappedSuperclassOrEntityConfig = entityMappings.getEntityConfig(className)) == null) {
                mappedSuperclassOrEntityConfig = entityMappings.getMappedSuperclass(className);
            }
            if (isEntity || isEmbeddable || isMappedSuperclass || mappedSuperclassOrEntityConfig != null) {
                classMap.put(className, type);
            }
        }
    }

    @Override
    public boolean isRootScannable(Path root) {
        if (!root.lookup("META-INF/persistence.xml").canRead()) {
            return false;
        }
        RootContext context = this._persistenceRootMap.get(root);
        if (context == null) {
            context = new RootContext(root);
            this._pendingRootList.add(context);
            this._persistenceRootMap.put(root, context);
        }
        if (context.isScanComplete()) {
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " scanning " + root);
        }
        context.setScanComplete(true);
        return true;
    }

    @Override
    public boolean isScanMatch(CharBuffer annotationName) {
        if (annotationName.matches("javax.persistence.Entity")) {
            return true;
        }
        if (annotationName.matches("javax.persistence.Embeddable")) {
            return true;
        }
        return annotationName.matches("javax.persistence.MappedSuperclass");
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        RootContext context = this._persistenceRootMap.get(root);
        if (context == null) {
            context = new RootContext(root);
            this._persistenceRootMap.put(root, context);
            this._pendingRootList.add(context);
        }
        context.addClassName(className);
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
        this.configurePersistenceRoots();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public String toString() {
        return "AmberContainer[" + this._parentLoader.getId() + "]";
    }

    class LazyEntityManagerFactory {
        private final PersistenceUnitConfig _unit;
        private final PersistenceProvider _provider;
        private final Map _props;

        LazyEntityManagerFactory(PersistenceUnitConfig unit, PersistenceProvider provider, Map props) {
            this._unit = unit;
            this._provider = provider;
            this._props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            AmberContainer amberContainer = AmberContainer.this;
            synchronized (amberContainer) {
                String unitName = this._unit.getName();
                EntityManagerFactory factory = (EntityManagerFactory)AmberContainer.this._factoryMap.get(unitName);
                if (factory == null) {
                    factory = this._provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this._unit, this._props);
                    if (factory == null) {
                        throw new ConfigException(L.l("'{0}' must return an EntityManagerFactory", (Object)this._provider.getClass().getName()));
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(L.l("Amber creating persistence unit '{0}' created with provider '{1}'", (Object)unitName, (Object)this._provider.getClass().getName()));
                    }
                    AmberContainer.this._factoryMap.put(unitName, factory);
                }
            }
        }
    }
}

