/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.manager.AmberContainer;
import com.caucho.jca.CloseResource;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.util.L10N;
import com.caucho.webbeans.component.HandleAware;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerTransactionProxy
implements EntityManager,
Serializable,
HandleAware {
    private static final L10N L = new L10N(EntityManagerTransactionProxy.class);
    private static final Logger log = Logger.getLogger(EntityManagerTransactionProxy.class.getName());
    private final AmberContainer _amber;
    private final String _unitName;
    private final Map _props;
    private EntityManagerFactory _emf;
    private final UserTransactionProxy _ut;
    private final ThreadLocal<EntityManager> _threadEntityManager = new ThreadLocal();
    private Object _serializationHandle;

    public EntityManagerTransactionProxy(AmberContainer amber, String unitName, Map props) {
        this._amber = amber;
        this._unitName = unitName;
        this._props = props;
        this._ut = UserTransactionProxy.getCurrent();
    }

    public void persist(Object entity) {
        this.getCurrent().persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.getCurrent().merge(entity);
    }

    public void remove(Object entity) {
        this.getCurrent().remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.getCurrent().find(entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.getCurrent().getReference(entityClass, primaryKey);
    }

    public FlushModeType getFlushMode() {
        return this.getCurrent().getFlushMode();
    }

    public void setFlushMode(FlushModeType mode) {
        this.getCurrent().setFlushMode(mode);
    }

    public void setExtended(boolean isExtended) {
        throw new IllegalStateException(L.l("Container-managed @PersistenceContext may not be converted to extended"));
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getCurrent().lock(entity, lockMode);
    }

    public void clear() {
        this.getCurrent().clear();
    }

    public void flush() {
        this.getCurrent().flush();
    }

    public void joinTransaction() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not use joinTransaction."));
    }

    public Object getDelegate() {
        return this._threadEntityManager.get();
    }

    public void close() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not be closed."));
    }

    public Query createQuery(String sql) {
        return this.getCurrent().createQuery(sql);
    }

    public Query createNamedQuery(String sql) {
        return this.getCurrent().createNamedQuery(sql);
    }

    public Query createNativeQuery(String sql) {
        return this.getCurrent().createNativeQuery(sql);
    }

    public Query createNativeQuery(String sql, String map) {
        return this.getCurrent().createNativeQuery(sql, map);
    }

    public Query createNativeQuery(String sql, Class retType) {
        return this.getCurrent().createNativeQuery(sql, retType);
    }

    public void refresh(Object entity) {
        this.getCurrent().refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.getCurrent().contains(entity);
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException(L.l("Container-manager @PersistenceContext may not use getTransaction."));
    }

    public boolean isOpen() {
        return true;
    }

    private EntityManager getCurrent() {
        EntityManager em = this._threadEntityManager.get();
        if (em != null) {
            return em;
        }
        try {
            Transaction xa;
            if (this._emf == null) {
                this._emf = this._amber.getEntityManagerFactory(this._unitName);
            }
            if ((xa = this._ut.getTransaction()) != null) {
                em = this._emf.createEntityManager(this._props);
                this._threadEntityManager.set(em);
                xa.registerSynchronization((Synchronization)new EntityManagerSynchronization(em));
                return em;
            }
            UserTransactionImpl ut = this._ut.getCurrentUserTransactionImpl();
            if (ut != null && ut.isInContext()) {
                em = this._emf.createEntityManager(this._props);
                this._threadEntityManager.set(em);
                ut.enlistCloseResource(new EntityManagerCloseResource(em));
                return em;
            }
            throw new IllegalStateException(L.l("{0}: @PersistenceContext EntityManager may not be used outside of a transaction", (Object)this));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._unitName + "," + this._emf + "]";
    }

    class EntityManagerCloseResource
    implements CloseResource {
        private EntityManager _em;

        EntityManagerCloseResource(EntityManager em) {
            this._em = em;
        }

        public void close() {
            EntityManagerTransactionProxy.this._threadEntityManager.set(null);
            this._em.close();
        }
    }

    class EntityManagerSynchronization
    implements Synchronization {
        private EntityManager _em;

        EntityManagerSynchronization(EntityManager em) {
            this._em = em;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            EntityManagerTransactionProxy.this._threadEntityManager.set(null);
            this._em.close();
        }
    }
}

