/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityListener;
import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ColumnCompare;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private static final L10N L = new L10N(Table.class);
    private String _name;
    private String _configLocation;
    private AmberPersistenceUnit _manager;
    private EntityType _type;
    private ArrayList<Column> _columns = new ArrayList();
    private ArrayList<LinkColumns> _incomingLinks = new ArrayList();
    private ArrayList<LinkColumns> _outgoingLinks = new ArrayList();
    private ArrayList<Column> _idColumns = new ArrayList();
    private LinkColumns _dependentIdLink;
    private boolean _isReadOnly;
    private long _cacheTimeout = 250L;
    private ArrayList<EntityListener> _entityListeners = new ArrayList();
    private TableInvalidateCompletion _invalidateCompletion;

    public Table(AmberPersistenceUnit manager, String name) {
        this._manager = manager;
        this._name = name;
    }

    public ArrayList<LinkColumns> getIncomingLinks() {
        return this._incomingLinks;
    }

    public ArrayList<LinkColumns> getOutgoingLinks() {
        return this._outgoingLinks;
    }

    public String getName() {
        return this._name;
    }

    public void setConfigLocation(String location) {
        this._configLocation = location;
    }

    public String getLocation() {
        return this._configLocation;
    }

    public AmberPersistenceUnit getAmberManager() {
        return this._manager;
    }

    public void setType(EntityType type) {
        if (this._type == null) {
            this._type = type;
        }
    }

    public EntityType getType() {
        return this._type;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public long getCacheTimeout() {
        return this._cacheTimeout;
    }

    public void setCacheTimeout(long timeout) {
        this._cacheTimeout = timeout;
    }

    public Column createColumn(String name, Type type) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(name)) continue;
            return oldColumn;
        }
        Column column = new Column(this, name, type);
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public ForeignColumn createForeignColumn(String name, Column key) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(name)) continue;
            if (oldColumn instanceof ForeignColumn) {
                return (ForeignColumn)oldColumn;
            }
            ForeignColumn column = new ForeignColumn(this, name, key);
            this._columns.set(i, column);
            return column;
        }
        ForeignColumn column = new ForeignColumn(this, name, key);
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public Column addColumn(Column column) {
        for (int i = 0; i < this._columns.size(); ++i) {
            Column oldColumn = this._columns.get(i);
            if (!oldColumn.getName().equals(column.getName())) continue;
            if (oldColumn instanceof ForeignColumn) {
                return oldColumn;
            }
            if (column instanceof ForeignColumn) {
                this._columns.set(i, column);
                return column;
            }
            return oldColumn;
        }
        this._columns.add(column);
        Collections.sort(this._columns, new ColumnCompare());
        return column;
    }

    public ArrayList<Column> getColumns() {
        return this._columns;
    }

    public boolean removeColumn(Column column) {
        return this._columns.remove(column);
    }

    void addIncomingLink(LinkColumns link) {
        assert (!this._incomingLinks.contains(link));
        if (this._manager.isJPA()) {
            for (LinkColumns l : this._incomingLinks) {
                if (!l.getSourceTable().equals(link.getSourceTable()) || !l.getTargetTable().equals(link.getTargetTable())) continue;
                return;
            }
        }
        this._incomingLinks.add(link);
    }

    void addOutgoingLink(LinkColumns link) {
        assert (!this._outgoingLinks.contains(link));
        this._outgoingLinks.add(link);
    }

    public void addIdColumn(Column column) {
        this._idColumns.add(column);
    }

    public ArrayList<Column> getIdColumns() {
        return this._idColumns;
    }

    public void setDependentIdLink(LinkColumns link) {
        this._dependentIdLink = link;
    }

    public LinkColumns getDependentIdLink() {
        return this._dependentIdLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabaseTable(AmberPersistenceUnit amberPersistenceUnit) throws ConfigException {
        try {
            DataSource ds = amberPersistenceUnit.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                try {
                    String sql = "select 1 from " + this.getName() + " o where 1=0";
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                    return;
                }
                catch (SQLException e) {
                    String createSQL = this.generateCreateTableSQL(amberPersistenceUnit);
                    stmt.executeUpdate(createSQL);
                    stmt.close();
                    conn.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    private String generateCreateTableSQL(AmberPersistenceUnit amberPersistenceUnit) {
        CharBuffer cb = new CharBuffer();
        cb.append("create table " + this.getName() + " (");
        boolean hasColumn = false;
        for (Column column : this._columns) {
            String columnSQL = column.generateCreateTableSQL(amberPersistenceUnit);
            if (columnSQL == null) continue;
            if (!hasColumn) {
                hasColumn = true;
                cb.append("\n  " + columnSQL);
                continue;
            }
            cb.append(",\n  " + columnSQL);
        }
        cb.append("\n)");
        return cb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDatabaseTable(AmberPersistenceUnit amberPersistenceUnit) throws ConfigException {
        try {
            DataSource ds = amberPersistenceUnit.getDataSource();
            Connection conn = ds.getConnection();
            try {
                Statement stmt = conn.createStatement();
                try {
                    String sql = "select 1 from " + this.getName() + " o where 1=0";
                    ResultSet rs = stmt.executeQuery(sql);
                    rs.close();
                }
                catch (SQLException e) {
                    throw this.error(L.l("'{0}' is not a valid database table.  Either the table needs to be created or the create-database-tables attribute must be set.\n\n{1}", (Object)this.getName(), (Object)e.toString()), e);
                }
            }
            finally {
                conn.close();
            }
            for (Column column : this._columns) {
                column.validateDatabase(amberPersistenceUnit);
            }
        }
        catch (ConfigException e) {
            if (this._type != null) {
                this._type.setConfigException(e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this._type != null) {
                this._type.setConfigException(e);
            }
            throw this.error(e);
        }
    }

    public AmberCompletion getInvalidateCompletion() {
        if (this._invalidateCompletion == null) {
            this._invalidateCompletion = new TableInvalidateCompletion(this.getName());
        }
        return this._invalidateCompletion;
    }

    public AmberCompletion getUpdateCompletion() {
        return this.getInvalidateCompletion();
    }

    public AmberCompletion getDeleteCompletion() {
        return this.getInvalidateCompletion();
    }

    public void addEntityListener(EntityListener listener) {
        if (!this._entityListeners.contains(listener)) {
            this._entityListeners.add(listener);
        }
    }

    public boolean hasListeners() {
        return this._entityListeners.size() > 0;
    }

    public boolean isCascadeDelete() {
        LinkColumns link;
        int i;
        for (i = 0; i < this._incomingLinks.size(); ++i) {
            link = this._incomingLinks.get(i);
            if (!link.isSourceCascadeDelete()) continue;
            return true;
        }
        for (i = 0; i < this._outgoingLinks.size(); ++i) {
            link = this._outgoingLinks.get(i);
            if (!link.isTargetCascadeDelete()) continue;
            return true;
        }
        return false;
    }

    public void beforeEntityDelete(AmberConnection aConn, Entity entity) {
        try {
            int i;
            for (i = 0; i < this._entityListeners.size(); ++i) {
                EntityListener listener = this._entityListeners.get(i);
                listener.beforeEntityDelete(aConn, entity);
            }
            for (i = 0; i < this._incomingLinks.size(); ++i) {
                LinkColumns link = this._incomingLinks.get(i);
                link.beforeTargetDelete(aConn, entity);
            }
            aConn.addCompletion(this.getDeleteCompletion());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    protected ConfigException error(String msg, Throwable e) {
        if (this._configLocation != null) {
            return new LineConfigException(this._configLocation + msg, e);
        }
        return new ConfigException(msg, e);
    }

    protected RuntimeException error(Throwable e) {
        if (this._configLocation != null) {
            return ConfigException.create((String)this._configLocation, (Throwable)e);
        }
        return ConfigException.create((Throwable)e);
    }

    public String toString() {
        return "Table[" + this.getName() + "]";
    }
}

