/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.AmberFieldCompare;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassDependency;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.make.ClassDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanType
extends AbstractEnhancedType {
    private static final Logger log = Logger.getLogger(BeanType.class.getName());
    private static final L10N L = new L10N(BeanType.class);
    private boolean _isFieldAccess;
    private ArrayList<AmberField> _selfFields = new ArrayList();
    private volatile boolean _isConfigured;
    private ArrayList<PersistentDependency> _dependencies = new ArrayList();
    private HashMap<String, String> _completionFields = new HashMap();
    private Column _discriminator;

    public BeanType(AmberPersistenceUnit amberPersistenceUnit) {
        super(amberPersistenceUnit);
    }

    public boolean isEntity() {
        return false;
    }

    public void setFieldAccess(boolean isFieldAccess) {
        this._isFieldAccess = isFieldAccess;
    }

    public boolean isFieldAccess() {
        return this._isFieldAccess;
    }

    public boolean isEmbeddable() {
        return false;
    }

    public Column getDiscriminator() {
        return this._discriminator;
    }

    public void setDiscriminator(Column discriminator) {
        this._discriminator = discriminator;
    }

    @Override
    public String getJavaTypeName() {
        return this.getInstanceClassName();
    }

    public void addField(AmberField field) {
        this._selfFields.add(field);
        Collections.sort(this._selfFields, new AmberFieldCompare());
    }

    public ArrayList<AmberField> getSelfFields() {
        return this._selfFields;
    }

    public ArrayList<AmberField> getFields() {
        return this._selfFields;
    }

    public AmberField getField(String name) {
        for (AmberField field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public void setBeanClass(JClass beanClass) {
        super.setBeanClass(beanClass);
        this.addDependency(this._beanClass);
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public void addDependency(JClass cl) {
        this.addDependency(new JClassDependency(cl));
    }

    public void addDependency(PersistentDependency depend) {
        if (!this._dependencies.contains(depend)) {
            this._dependencies.add(depend);
        }
    }

    public ArrayList<PersistentDependency> getDependencies() {
        return this._dependencies;
    }

    public void addCompletionField(String name) {
        this._completionFields.put(name, name);
    }

    public boolean containsCompletionField(String completionField) {
        return this._completionFields.containsKey(completionField);
    }

    public void removeAllCompletionFields() {
        this._completionFields.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startConfigure() {
        BeanType beanType = this;
        synchronized (beanType) {
            if (this._isConfigured) {
                return false;
            }
            this._isConfigured = true;
            return true;
        }
    }

    @Override
    public void init() throws ConfigException {
        for (AmberField field : this._selfFields) {
            if (!this.getPersistenceUnit().isJPA() || !(field instanceof EntityManyToOneField)) continue;
            ((EntityManyToOneField)field).init((EntityType)this);
        }
    }

    @Override
    public String generateCastFromObject(String value) {
        return "((" + this.getInstanceClassName() + ") " + value + ")";
    }

    public void generateLoadSelect(StringBuilder sb, Table table, String id, int loadGroup) {
        for (AmberField field : this.getFields()) {
            String propSelect;
            if (field.getLoadGroupIndex() != loadGroup || (propSelect = field.generateLoadSelect(table, id)) == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(propSelect);
        }
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index, int loadGroupIndex) throws IOException {
        if (this.getDiscriminator() != null) {
            boolean isAbstractParent;
            EntityType parent = null;
            if (this instanceof EntityType) {
                parent = ((EntityType)this).getParentType();
            }
            boolean bl = isAbstractParent = this.getPersistenceUnit().isJPA() && (parent == null || parent.getBeanClass().isAbstract());
            if (loadGroupIndex == 0 || isAbstractParent) {
                ++index;
            }
        }
        for (AmberField field : this.getFields()) {
            if (field.getLoadGroupIndex() != loadGroupIndex) continue;
            index = field.generateLoad(out, rs, indexVar, index);
        }
        return index;
    }

    public abstract String generateLoadSelect(Table var1, String var2);

    public String generateLoadSelect(Table table, String id, int loadGroup) {
        StringBuilder sb = new StringBuilder();
        this.generateLoadSelect(sb, table, id, loadGroup);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public void generatePrePersist(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePrePersist(out);
        }
    }

    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateInvalidateForeign(out);
        }
    }

    public void generateExpire(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateExpire(out);
        }
    }

    public JMethod getGetter(String name) {
        return BeanType.getGetter(this._beanClass, name);
    }

    public static JMethod getGetter(JClass cl, String name) {
        JMethod[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JClass[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 0) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return BeanType.getGetter(cl, name);
        }
        return null;
    }

    public static JField getField(JClass cl, String name) {
        JField[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return BeanType.getField(cl, name);
        }
        return null;
    }

    public static JMethod getSetter(JClass cl, String name) {
        JMethod[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            JClass[] param = methods[i].getParameterTypes();
            String methodName = methods[i].getName();
            if (!name.equals(methodName) || param.length != 1) continue;
            return methods[i];
        }
        if ((cl = cl.getSuperClass()) != null) {
            return BeanType.getSetter(cl, name);
        }
        return null;
    }

    public long getCreateLoadMask(int group) {
        long mask = 0L;
        for (AmberField field : this.getFields()) {
            mask |= field.getCreateLoadMask(group);
        }
        return mask;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanClass.getName() + "]";
    }
}

