/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanType
extends Type {
    private static final L10N L = new L10N(BooleanType.class);
    private static final BooleanType BOOLEAN_TYPE = new BooleanType();

    private BooleanType() {
    }

    public static BooleanType create() {
        return BOOLEAN_TYPE;
    }

    public String getName() {
        return "java.lang.Boolean";
    }

    public boolean isBoolean() {
        return true;
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(16, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.BooleanType.toBoolean(" + rs + ".getBoolean(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.BooleanType.toBoolean(rs.getBoolean(columnNames[" + index + "])," + "rs.wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.BIT);");
        out.println("else");
        out.println("  " + pstmt + ".setBoolean(" + index + "++, " + value + ".booleanValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIT);");
    }

    public static Boolean toBoolean(boolean value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Boolean(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        boolean value = rs.getBoolean(index);
        return rs.wasNull() ? null : (value ? Boolean.TRUE : Boolean.FALSE);
    }
}

