/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.ArrayType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ByteArrayType
extends ArrayType {
    private static final L10N L = new L10N(ByteArrayType.class);

    private ByteArrayType() {
    }

    public static ByteArrayType create() {
        return new ByteArrayType();
    }

    public String getName() {
        return "java.lang.Byte[]";
    }

    public String getJavaTypeName() {
        return "java.lang.Byte[]";
    }

    public String getJavaObjectTypeName() {
        return "java.lang.Byte";
    }

    public String getPrimitiveArrayTypeName() {
        return "byte[]";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getBytes(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getBytes(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.LONGVARBINARY);");
        out.println("else {");
        out.println("  java.lang.Byte[] super_temp_" + index + " = " + value + ";");
        out.println("  byte[] temp_" + index + " = new byte[super_temp_" + index + ".length];");
        out.println("  for (int i=0; i < temp_" + index + ".length; i++)");
        out.println("    temp_" + index + "[i] = super_temp_" + index + "[i].byteValue();");
        out.println("  " + pstmt + ".setBytes(" + index + "++, temp_" + index + ");");
        out.println("}");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        Byte[] wrapperByte = (Byte[])value;
        byte[] primitiveByte = new byte[wrapperByte.length];
        for (int i = 0; i < wrapperByte.length; ++i) {
            primitiveByte[i] = wrapperByte[i];
        }
        pstmt.setBytes(index, primitiveByte);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        byte[] primitiveByte = rs.getBytes(index);
        if (rs.wasNull()) {
            return null;
        }
        Byte[] wrapperByte = new Byte[primitiveByte.length];
        for (int i = 0; i < primitiveByte.length; ++i) {
            wrapperByte[i] = new Byte(primitiveByte[i]);
        }
        return wrapperByte;
    }
}

