/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ByteType
extends Type {
    private static final L10N L = new L10N(ByteType.class);
    private static final ByteType BYTE_TYPE = new ByteType();

    private ByteType() {
    }

    public static ByteType create() {
        return BYTE_TYPE;
    }

    public String getName() {
        return "java.lang.Byte";
    }

    public boolean isNumeric() {
        return true;
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-6, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.ByteType.toByte(" + rs + ".getByte(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.ByteType.toByte(rs.getByte(columnNames[" + index + "])," + "rs.wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
        out.println("else");
        out.println("  " + pstmt + ".setByte(" + index + "++, " + value + ".byteValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
    }

    public static Byte toByte(int value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Byte((byte)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        byte value = rs.getByte(index);
        return rs.wasNull() ? null : new Byte(value);
    }
}

