/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.TemporalType;

public class CalendarType
extends Type {
    private static final L10N L = new L10N(CalendarType.class);
    public static final CalendarType TEMPORAL_DATE_TYPE = new CalendarType(TemporalType.DATE);
    public static final CalendarType TEMPORAL_TIME_TYPE = new CalendarType(TemporalType.TIME);
    public static final CalendarType TEMPORAL_TIMESTAMP_TYPE = new CalendarType(TemporalType.TIMESTAMP);
    private TemporalType _temporalType;

    private CalendarType(TemporalType temporalType) {
        this._temporalType = temporalType;
    }

    public static CalendarType create() {
        return TEMPORAL_TIMESTAMP_TYPE;
    }

    public String getName() {
        return "java.util.Calendar";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.CalendarType.toCalendar(" + rs + ".getTimestamp(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.CalendarType.toCalendar(rs.getTimestamp(columnNames[" + index + "]))");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TIMESTAMP);");
        out.println("else");
        out.println("  " + pstmt + ".setTimestamp(" + index + "++, new java.sql.Timestamp(" + value + ".getTimeInMillis()));");
    }

    public static Calendar toCalendar(Date time) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        Timestamp time = rs.getTimestamp(index);
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        Timestamp timestamp = new Timestamp(((Calendar)value).getTimeInMillis());
        switch (this._temporalType) {
            case DATE: {
                pstmt.setObject(index, (Object)timestamp, 91);
                break;
            }
            case TIME: {
                pstmt.setObject(index, (Object)timestamp, 92);
                break;
            }
            default: {
                pstmt.setObject(index, (Object)timestamp, 93);
            }
        }
    }
}

