/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobType
extends Type {
    private static final L10N L = new L10N(ClobType.class);
    private static final ClobType BLOB_TYPE = new ClobType();

    private ClobType() {
    }

    public static ClobType create() {
        return BLOB_TYPE;
    }

    public String getName() {
        return "java.sql.Clob";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("" + rs + ".getClob(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setClob(" + index + "++, " + value + ");");
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getClob(index);
    }
}

