/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.AbstractConfigIntrospector;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.AmberFieldCompare;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.VersionField;
import com.caucho.amber.gen.EntityComponent;
import com.caucho.amber.idgen.AmberTableGenerator;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.ListenerCallback;
import com.caucho.amber.type.ListenerType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityType
extends BeanType {
    private static final Logger log = Logger.getLogger(EntityType.class.getName());
    private static final L10N L = new L10N(EntityType.class);
    private EntityType _parentType;
    Table _table;
    private String _rootTableName;
    private ArrayList<Table> _secondaryTables = new ArrayList();
    private ArrayList<ListenerType> _listeners = new ArrayList();
    private ArrayList<ListenerCallback> _postLoadCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _prePersistCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _postPersistCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _preUpdateCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _postUpdateCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _preRemoveCallbacks = new ArrayList();
    private ArrayList<ListenerCallback> _postRemoveCallbacks = new ArrayList();
    private Id _id;
    private String _discriminatorValue;
    private boolean _isJoinedSubClass;
    private HashSet<String> _eagerFieldNames;
    private HashMap<String, EntityType> _subEntities;
    private ArrayList<AmberField> _mappedSuperclassFields = new ArrayList();
    private ArrayList<AmberField> _fields;
    private boolean _hasDependent;
    private JClass _proxyClass;
    private AmberEntityHome _home;
    protected int _defaultLoadGroupIndex;
    protected int _loadGroupIndex;
    protected int _minDirtyIndex;
    protected int _dirtyIndex;
    private boolean _excludeDefaultListeners;
    private boolean _excludeSuperclassListeners;
    protected boolean _hasLoadCallback;
    private HashMap<String, IdGenerator> _idGenMap = new HashMap();
    private final Lifecycle _lifecycle = new Lifecycle();
    private VersionField _versionField;
    private int _flushPriority;
    private boolean _isIdentityGenerator;
    private boolean _isSequenceGenerator;

    public EntityType(AmberPersistenceUnit amberPersistenceUnit) {
        super(amberPersistenceUnit);
    }

    @Override
    public boolean isEntity() {
        return !this.getBeanClass().isAbstract();
    }

    public void setTable(Table table) {
        this._table = table;
        if (table == null) {
            return;
        }
        table.setType(this);
        if (this._rootTableName == null) {
            this._rootTableName = table.getName();
        }
    }

    public Table getTable() {
        if (this._table == null && !this.isAbstractClass()) {
            String sqlName = AbstractConfigIntrospector.toSqlName(this.getName());
            this.setTable(this._amberPersistenceUnit.createTable(sqlName));
        }
        return this._table;
    }

    @Override
    public Class getInstanceClass() {
        return this.getInstanceClass(Entity.class);
    }

    @Override
    public String getComponentInterfaceName() {
        return "com.caucho.amber.entity.Entity";
    }

    @Override
    public ClassComponent getComponentGenerator() {
        return new EntityComponent();
    }

    public int getFlushPriority() {
        return this._flushPriority;
    }

    public void addMappedSuperclassField(AmberField field) {
        if (this._mappedSuperclassFields.contains(field)) {
            return;
        }
        this._mappedSuperclassFields.add(field);
        Collections.sort(this._mappedSuperclassFields, new AmberFieldCompare());
    }

    public ArrayList<AmberField> getMappedSuperclassFields() {
        return this._mappedSuperclassFields;
    }

    public AmberField getMappedSuperclassField(String name) {
        for (int i = 0; i < this._mappedSuperclassFields.size(); ++i) {
            AmberField field = this._mappedSuperclassFields.get(i);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public ArrayList<AmberField> getFields() {
        if (this._fields != null) {
            return this._fields;
        }
        return super.getFields();
    }

    public String getRootTableName() {
        return this._rootTableName;
    }

    public void setRootTableName(String rootTableName) {
        this._rootTableName = rootTableName;
    }

    public VersionField getVersionField() {
        return this._versionField;
    }

    public void setVersionField(VersionField versionField) {
        this.addField(versionField);
        this._versionField = versionField;
    }

    public void addSecondaryTable(Table table) {
        if (!this._secondaryTables.contains(table)) {
            this._secondaryTables.add(table);
        }
        table.setType(this);
    }

    public ArrayList<Table> getSecondaryTables() {
        return this._secondaryTables;
    }

    public void addListener(ListenerType listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public ArrayList<ListenerType> getListeners() {
        return this._listeners;
    }

    public Table getSecondaryTable(String name) {
        for (Table table : this._secondaryTables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public boolean hasDependent() {
        return this._hasDependent;
    }

    public void setHasDependent(boolean hasDependent) {
        this._hasDependent = hasDependent;
    }

    @Override
    public String getForeignTypeName() {
        return this.getId().getForeignTypeName();
    }

    public JClass getProxyClass() {
        if (this._proxyClass != null) {
            return this._proxyClass;
        }
        return this._beanClass;
    }

    public void setProxyClass(JClass proxyClass) {
        this._proxyClass = proxyClass;
    }

    public boolean isAbstractClass() {
        return this.getBeanClass().isAbstract() && this._proxyClass == null;
    }

    public void setId(Id id) {
        this._id = id;
    }

    public Id getId() {
        return this._id;
    }

    public void setJoinedSubClass(boolean isJoinedSubClass) {
        this._isJoinedSubClass = isJoinedSubClass;
    }

    public boolean isJoinedSubClass() {
        if (this.getParentType() != null) {
            return this.getParentType().isJoinedSubClass();
        }
        return this._isJoinedSubClass;
    }

    public String getDiscriminatorValue() {
        if (this._discriminatorValue != null) {
            return this._discriminatorValue;
        }
        return this.getBeanClass().getSimpleName();
    }

    public void setDiscriminatorValue(String value) {
        this._discriminatorValue = value;
    }

    public boolean isReadOnly() {
        return this.getTable().isReadOnly();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.getTable().setReadOnly(isReadOnly);
    }

    public long getCacheTimeout() {
        return this.getTable().getCacheTimeout();
    }

    public void setCacheTimeout(long timeout) {
        this.getTable().setCacheTimeout(timeout);
    }

    @Override
    public void addField(AmberField field) {
        super.addField(field);
        if (!field.isLazy()) {
            if (this._eagerFieldNames == null) {
                this._eagerFieldNames = new HashSet();
            }
            this._eagerFieldNames.add(field.getName());
        }
    }

    public HashSet<String> getEagerFieldNames() {
        return this._eagerFieldNames;
    }

    @Override
    public AmberField getField(String name) {
        if (this._id != null) {
            ArrayList<IdField> keys = this._id.getKeys();
            for (int i = 0; i < keys.size(); ++i) {
                IdField key = keys.get(i);
                if (!key.getName().equals(name)) continue;
                return key;
            }
        }
        return super.getField(name);
    }

    public ArrayList<Column> getColumns() {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().getColumns();
    }

    public boolean getExcludeDefaultListeners() {
        return this._excludeDefaultListeners;
    }

    public void setExcludeDefaultListeners(boolean b) {
        this._excludeDefaultListeners = b;
    }

    public boolean getExcludeSuperclassListeners() {
        return this._excludeSuperclassListeners;
    }

    public void setExcludeSuperclassListeners(boolean b) {
        this._excludeSuperclassListeners = b;
    }

    public void setHasLoadCallback(boolean hasCallback) {
        this._hasLoadCallback = hasCallback;
    }

    public boolean getHasLoadCallback() {
        return this._hasLoadCallback;
    }

    public EntityType getRootType() {
        EntityType parent = this.getParentType();
        if (parent != null) {
            return parent.getRootType();
        }
        return this;
    }

    public EntityType getParentType() {
        return this._parentType;
    }

    public void setParentType(EntityType parentType) {
        this._parentType = parentType;
    }

    public void addSubClass(EntityType type) {
        if (this._subEntities == null) {
            this._subEntities = new HashMap();
        }
        this._subEntities.put(type.getDiscriminatorValue(), type);
    }

    public EntityType getSubClass(String discriminator) {
        if (this._subEntities == null) {
            return this;
        }
        EntityType subType = this._subEntities.get(discriminator);
        if (subType != null) {
            return subType;
        }
        for (EntityType subEntity : this._subEntities.values()) {
            subType = subEntity.getSubClass(discriminator);
            if (subType == subEntity) continue;
            return subType;
        }
        return this;
    }

    public Entity createBean() {
        try {
            Entity entity = (Entity)this.getInstanceClass().newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new AmberRuntimeException(e);
        }
    }

    public AmberEntityHome getHome() {
        if (this._home == null) {
            this._home = this.getPersistenceUnit().getEntityHome(this.getName());
        }
        return this._home;
    }

    public int nextLoadGroupIndex() {
        int nextLoadGroupIndex;
        this._loadGroupIndex = nextLoadGroupIndex = this.getLoadGroupIndex() + 1;
        return nextLoadGroupIndex;
    }

    public int getLoadGroupIndex() {
        return this._loadGroupIndex;
    }

    public void nextDefaultLoadGroupIndex() {
        this._defaultLoadGroupIndex = this.nextLoadGroupIndex();
    }

    public int getDefaultLoadGroupIndex() {
        return this._defaultLoadGroupIndex;
    }

    public boolean isLoadGroupOwnedByType(int i) {
        return this.getDefaultLoadGroupIndex() <= i && i <= this.getLoadGroupIndex();
    }

    public int nextDirtyIndex() {
        int dirtyIndex = this.getDirtyIndex();
        this._dirtyIndex = dirtyIndex + 1;
        return dirtyIndex;
    }

    public int getDirtyIndex() {
        return this._dirtyIndex;
    }

    public int getMinDirtyIndex() {
        return this._minDirtyIndex;
    }

    public boolean isDirtyIndexOwnedByType(int i) {
        return this.getMinDirtyIndex() <= i && i < this.getDirtyIndex();
    }

    @Override
    public void init() throws ConfigException {
        if (this.getConfigException() != null) {
            return;
        }
        if (!this._lifecycle.toInit()) {
            return;
        }
        super.init();
        this.getTable();
        this.initId();
        this._fields = this.getMergedFields();
        for (AmberField field : this.getFields()) {
            if (field.isUpdateable()) {
                field.setIndex(this.nextDirtyIndex());
            }
            field.init();
        }
        if (this.getMappedSuperclassFields() == null) {
            return;
        }
        for (AmberField field : this.getMappedSuperclassFields()) {
            if (field.isUpdateable()) {
                field.setIndex(this.nextDirtyIndex());
            }
            field.init();
        }
    }

    protected void initId() {
        assert (this.getId() != null) : "null id for " + this.getName();
        this.getId().init();
    }

    protected ArrayList<AmberField> getMergedFields() {
        ArrayList<AmberField> mappedFields = this.getMappedSuperclassFields();
        if (mappedFields == null) {
            return this.getFields();
        }
        ArrayList<AmberField> resultFields = new ArrayList<AmberField>();
        resultFields.addAll(this.getFields());
        for (AmberField field : mappedFields) {
            resultFields.add(field);
        }
        Collections.sort(resultFields, new AmberFieldCompare());
        return resultFields;
    }

    public void start() throws ConfigException {
        this.init();
        this.startGenerator();
        this.startImpl();
        if (!this._lifecycle.toActive()) {
            return;
        }
    }

    private void startGenerator() {
        IdField idGenField = this.getId().getGeneratedIdField();
        if (idGenField == null) {
            return;
        }
        JdbcMetaData md = this.getPersistenceUnit().getMetaData();
        if ("sequence".equals(idGenField.getGenerator())) {
            this._isIdentityGenerator = false;
            this._isSequenceGenerator = true;
            if (!md.supportsSequences()) {
                throw new ConfigException(L.l("'{0}' does not support sequences", (Object)md.getDatabaseName()));
            }
        } else if ("identity".equals(idGenField.getGenerator())) {
            this._isIdentityGenerator = true;
            this._isSequenceGenerator = false;
            if (!md.supportsIdentity()) {
                throw new ConfigException(L.l("'{0}' does not support identity", (Object)md.getDatabaseName()));
            }
        } else if ("auto".equals(idGenField.getGenerator())) {
            if (md.supportsIdentity()) {
                this._isIdentityGenerator = true;
            } else if (md.supportsSequences()) {
                this._isSequenceGenerator = true;
            }
        }
        if (!this._isIdentityGenerator && this.getGenerator(idGenField.getName()) == null) {
            IdGenerator gen;
            if (this._isSequenceGenerator) {
                String name = this.getTable().getName() + "_cseq";
                gen = this.getPersistenceUnit().createSequenceGenerator(name, 1);
            } else {
                gen = this.getPersistenceUnit().getTableGenerator("caucho");
            }
            this._idGenMap.put(idGenField.getName(), gen);
        }
        for (IdGenerator idGen : this._idGenMap.values()) {
            try {
                if (idGen instanceof SequenceIdGenerator) {
                    ((SequenceIdGenerator)idGen).init(this._amberPersistenceUnit);
                    continue;
                }
                if (!(idGen instanceof AmberTableGenerator)) continue;
                ((AmberTableGenerator)idGen).init(this._amberPersistenceUnit);
            }
            catch (SQLException e) {
                throw ConfigException.create((Throwable)e);
            }
        }
    }

    private void startImpl() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (ListenerType listenerType : this.getListeners()) {
                Method method;
                Object listener;
                String listenerClass = listenerType.getBeanClass().getName();
                Class<?> cl = Class.forName(listenerClass, false, loader);
                try {
                    listener = cl.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ConfigException(L.l("'{0}' could not be instantiated.", cl));
                }
                for (JMethod jMethod : listenerType.getCallbacks(1)) {
                    method = this.getListenerMethod(cl, jMethod.getName());
                    if (method == null) continue;
                    this._prePersistCallbacks.add(new ListenerCallback(listener, method));
                }
                for (JMethod jMethod : listenerType.getCallbacks(2)) {
                    method = this.getListenerMethod(cl, jMethod.getName());
                    if (method == null) continue;
                    this._postPersistCallbacks.add(new ListenerCallback(listener, method));
                }
                for (JMethod jMethod : listenerType.getCallbacks(7)) {
                    method = this.getListenerMethod(cl, jMethod.getName());
                    if (method == null) continue;
                    this._postLoadCallbacks.add(new ListenerCallback(listener, method));
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private Method getListenerMethod(Class cl, String methodName) {
        if (cl == null || cl.equals(Object.class)) {
            return null;
        }
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (!methods[i].getName().equals(methodName) || paramTypes.length != 1 || !this.getBeanClass().isAssignableTo(paramTypes[0])) continue;
            return methods[i];
        }
        return this.getListenerMethod(cl.getSuperclass(), methodName);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("aConn.loadProxy(\"" + this.getName() + "\", ");
        index = this.getId().generateLoadForeign(out, rs, indexVar, index);
        out.println(");");
        return index;
    }

    public boolean hasLoadGroup(int loadGroupIndex) {
        if (loadGroupIndex == 0) {
            return true;
        }
        for (AmberField field : this.getFields()) {
            if (!field.hasLoadGroup(loadGroupIndex)) continue;
            return true;
        }
        return false;
    }

    public int generatePostLoadSelect(JavaWriter out, int index, int loadGroupIndex) throws IOException {
        if (loadGroupIndex == 0 && this.getDiscriminator() != null) {
            ++index;
        }
        for (EntityType type = this; type != null; type = type.getParentType()) {
            index = this.generatePostLoadSelect(out, index, type.getMappedSuperclassFields());
            index = this.generatePostLoadSelect(out, index, type.getFields());
        }
        return index;
    }

    private int generatePostLoadSelect(JavaWriter out, int index, ArrayList<AmberField> fields) throws IOException {
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                AmberField field = fields.get(i);
                index = field.generatePostLoadSelect(out, index);
            }
        }
        return index;
    }

    public void generateLoadNative(JavaWriter out) throws IOException {
        int index = 0;
        for (AmberField field : this.getFields()) {
            index = field.generateLoadNative(out, index);
        }
    }

    public void generateNativeColumnNames(ArrayList<String> names) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generateNativeColumnNames(names);
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (this.getId() != null) {
            this.getId().generateSet(out, pstmt, index, value);
        }
    }

    @Override
    public Object getObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().loadLazy(aConn, rs, index);
    }

    @Override
    public EntityItem findItem(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().findItem(aConn, rs, index);
    }

    public Object getLoadObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getHome().loadFull(aConn, rs, index);
    }

    public boolean isSequenceGenerator() {
        return this._isSequenceGenerator;
    }

    public boolean isIdentityGenerator() {
        return this._isIdentityGenerator;
    }

    public void setGenerator(String name, IdGenerator gen) {
        Thread.dumpStack();
        this._idGenMap.put(name, gen);
    }

    public IdGenerator getGenerator(String name) {
        return this._idGenMap.get(name);
    }

    public long nextGeneratorId(AmberConnection aConn, String name) throws SQLException {
        IdGenerator idGen = this._idGenMap.get(name);
        return idGen.allocate(aConn);
    }

    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        this.getId().generateLoadFromObject(out, obj);
        for (AmberField field : this.getFields()) {
            field.generateLoadFromObject(out, obj);
        }
    }

    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadGroup) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateCopyLoadObject(out, dst, src, loadGroup);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (AmberField field : fields) {
            field.generateCopyLoadObject(out, dst, src, loadGroup);
        }
    }

    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateMergeFrom(out, dst, src);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateMergeFrom(out, dst, src);
        }
    }

    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateCopyUpdateObject(out, dst, src, updateIndex);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateCopyUpdateObject(out, dst, src, updateIndex);
        }
    }

    public void generateDumpRelationships(JavaWriter out, int updateIndex) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateDumpRelationships(out, updateIndex);
        }
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            AmberField field = fields.get(i);
            field.generateDumpRelationships(out, updateIndex);
        }
    }

    public String generateKeyLoadSelect(String id) {
        String select = this.getId().generateLoadSelect(id);
        if (this.getDiscriminator() != null) {
            if (select != null && !select.equals("")) {
                select = select + ", ";
            }
            select = select + this.getDiscriminator().getName();
        }
        return select;
    }

    public String generateFullLoadSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        String idSelect = this.getId().generateSelect(id);
        if (idSelect != null) {
            cb.append(idSelect);
        }
        String loadSelect = this.generateLoadSelect(id);
        if (!idSelect.equals("") && !loadSelect.equals("")) {
            cb.append(",");
        }
        cb.append(loadSelect);
        return cb.close();
    }

    public String generateLoadSelect(String id) {
        return this.generateLoadSelect(this.getTable(), id);
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        StringBuilder sb = new StringBuilder();
        if (this.getTable() == table && this.getDiscriminator() != null && id != null) {
            if (this.getDiscriminator().getTable() == this.getTable()) {
                sb.append(id + ".");
                sb.append(this.getDiscriminator().getName());
            } else {
                sb.append("'" + this.getDiscriminatorValue() + "'");
            }
        }
        this.generateLoadSelect(sb, table, id, 0);
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    @Override
    public void generateLoadSelect(StringBuilder sb, Table table, String id, int loadGroup) {
        if (this._parentType != null) {
            this._parentType.generateLoadSelect(sb, table, id, loadGroup);
        }
        super.generateLoadSelect(sb, table, id, loadGroup);
    }

    public String generateAutoCreateSQL(Table table) {
        return this.generateCreateSQL(table, true);
    }

    public String generateCreateSQL(Table table) {
        return this.generateCreateSQL(table, false);
    }

    private String generateCreateSQL(Table table, boolean isAuto) {
        int i;
        CharBuffer sql = new CharBuffer();
        sql.append("insert into ");
        sql.append(JavaWriter.escapeJavaString(table.getName()) + " (");
        boolean isFirst = true;
        ArrayList<String> idColumns = new ArrayList<String>();
        for (IdField field : this.getId().getKeys()) {
            if (isAuto && field.getGenerator() != null) continue;
            for (Column key : field.getColumns()) {
                String name = table == key.getTable() ? key.getName() : table.getDependentIdLink().getSourceColumn(key).getName();
                idColumns.add(name);
                if (!isFirst) {
                    sql.append(", ");
                }
                isFirst = false;
                sql.append(name);
            }
        }
        if (table == this.getTable() && this.getDiscriminator() != null) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append(this.getDiscriminator().getName());
        }
        ArrayList<String> columns = new ArrayList<String>();
        this.generateInsertColumns(table, columns);
        for (String columnName : columns) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append(columnName);
        }
        sql.append(") values (");
        isFirst = true;
        for (i = 0; i < idColumns.size(); ++i) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append("?");
        }
        if (table == this.getTable() && this.getDiscriminator() != null) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append("'" + this.getDiscriminatorValue() + "'");
        }
        for (i = 0; i < columns.size(); ++i) {
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    protected void generateInsertColumns(Table table, ArrayList<String> columns) {
        if (this.getParentType() != null) {
            this.getParentType().generateInsertColumns(table, columns);
        }
        for (AmberField field : this.getFields()) {
            if (field.getTable() != table) continue;
            field.generateInsertColumns(columns);
        }
    }

    public void generateInsertSet(JavaWriter out, Table table, String pstmt, String query, String obj) throws IOException {
        if (this.getParentType() != null) {
            this.getParentType().generateInsertSet(out, table, pstmt, query, obj);
        }
        for (AmberField field : this.getFields()) {
            if (field.getTable() != table) continue;
            field.generateInsertSet(out, pstmt, query, obj);
        }
    }

    public String generateIdSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(this.getId().generateSelect(id));
        if (this.getDiscriminator() != null) {
            cb.append(", ");
            cb.append(this.getDiscriminator().getName());
        }
        return cb.close();
    }

    public void generateUpdateSQLPrefix(CharBuffer sql) {
        sql.append("update " + this.getTable().getName() + " set ");
    }

    public boolean generateUpdateSQLComponent(CharBuffer sql, int group, long mask, boolean isFirst) {
        AmberField field;
        ArrayList<AmberField> fields = this.getFields();
        while (mask != 0L) {
            int i = 0;
            i = 0;
            while ((mask & 1L << i) == 0L) {
                ++i;
            }
            mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            field = null;
            for (int j = 0; j < fields.size() && (field = fields.get(j)).getIndex() != i + group * 64; ++j) {
                field = null;
            }
            if (field == null || field instanceof VersionField) continue;
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            field.generateUpdate(sql);
        }
        for (int j = 0; j < fields.size(); ++j) {
            field = fields.get(j);
            if (!(field instanceof VersionField)) continue;
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            field.generateUpdate(sql);
            break;
        }
        return isFirst;
    }

    public void generateUpdateSQLSuffix(CharBuffer sql) {
        sql.append(" where ");
        sql.append(this.getId().generateMatchArgWhere(null));
        if (this._versionField != null) {
            sql.append(" and ");
            sql.append(this._versionField.generateMatchArgWhere(null));
        }
    }

    public String generateUpdateSQL(long mask) {
        if (mask == 0L) {
            return null;
        }
        CharBuffer sql = CharBuffer.allocate();
        sql.append("update " + this.getTable().getName() + " set ");
        boolean isFirst = true;
        ArrayList<AmberField> fields = this.getFields();
        while (mask != 0L) {
            int i = 0;
            i = 0;
            while ((mask & 1L << i) == 0L) {
                ++i;
            }
            mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
            AmberField field = null;
            for (int j = 0; j < fields.size() && (field = fields.get(j)).getIndex() != i; ++j) {
                field = null;
            }
            if (field == null) continue;
            if (!isFirst) {
                sql.append(", ");
            }
            isFirst = false;
            field.generateUpdate(sql);
        }
        if (isFirst) {
            return null;
        }
        sql.append(" where ");
        sql.append(this.getId().generateMatchArgWhere(null));
        return sql.toString();
    }

    public void generatePreDelete(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePreDelete(out);
        }
    }

    public void generatePostDelete(JavaWriter out) throws IOException {
        for (AmberField field : this.getFields()) {
            field.generatePostDelete(out);
        }
    }

    public void delete(AmberConnection aConn, Object key) throws SQLException {
        this.getHome().delete(aConn, key);
    }

    public void update(Entity entity) throws SQLException {
    }

    public int updateFlushPriority(ArrayList<EntityType> updatingEntities) {
        this._flushPriority = 0;
        ArrayList<AmberField> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            int targetPriority;
            EntityManyToOneField manyToOne;
            EntityType targetRelatedType;
            AmberField field = fields.get(i);
            if (!(field instanceof EntityManyToOneField) || !((targetRelatedType = (manyToOne = (EntityManyToOneField)field).getEntityTargetType()) instanceof EntityType)) continue;
            EntityType targetType = targetRelatedType;
            if (!updatingEntities.contains(targetType)) {
                updatingEntities.add(targetType);
                targetType.updateFlushPriority(updatingEntities);
            }
            if ((targetPriority = targetType.getFlushPriority()) < this._flushPriority) continue;
            EntityType type = null;
            if (!manyToOne.isAnnotatedManyToOne()) {
                EntityManyToOneField targetManyToOne;
                AmberField targetField;
                Iterator<AmberField> i$ = targetType.getFields().iterator();
                while (!(!i$.hasNext() || (targetField = i$.next()) instanceof EntityManyToOneField && this == (type = (targetManyToOne = (EntityManyToOneField)targetField).getEntityTargetType()) && targetManyToOne.isAnnotatedManyToOne())) {
                }
            }
            if (this == type) continue;
            this._flushPriority = targetPriority + 1;
        }
        return this._flushPriority;
    }

    public AmberCompletion createManyToOneCompletion(String name, Entity source, Object newTarget) {
        AmberField field = this.getField(name);
        EntityType parentType = this;
        while (field == null && (parentType = parentType.getParentType()) != null) {
            field = parentType.getField(name);
        }
        if (field instanceof EntityManyToOneField) {
            EntityManyToOneField manyToOne = (EntityManyToOneField)field;
            return this.getTable().getInvalidateCompletion();
        }
        throw new IllegalStateException();
    }

    public boolean isEJBProxy(String typeName) {
        return this.getBeanClass() != this.getProxyClass() && this.getProxyClass().getName().equals(typeName);
    }

    public void prePersist(Entity entity) {
        for (int i = 0; i < this._prePersistCallbacks.size(); ++i) {
            this._prePersistCallbacks.get(i).invoke(entity);
        }
    }

    public void postPersist(Entity entity) {
        for (int i = 0; i < this._postPersistCallbacks.size(); ++i) {
            this._postPersistCallbacks.get(i).invoke(entity);
        }
    }

    public void preUpdate(Entity entity) {
        for (int i = 0; i < this._preUpdateCallbacks.size(); ++i) {
            this._preUpdateCallbacks.get(i).invoke(entity);
        }
    }

    public void postUpdate(Entity entity) {
        for (int i = 0; i < this._postUpdateCallbacks.size(); ++i) {
            this._postUpdateCallbacks.get(i).invoke(entity);
        }
    }

    public void preRemove(Entity entity) {
        for (int i = 0; i < this._preRemoveCallbacks.size(); ++i) {
            this._preRemoveCallbacks.get(i).invoke(entity);
        }
    }

    public void postRemove(Entity entity) {
        for (int i = 0; i < this._postRemoveCallbacks.size(); ++i) {
            this._postRemoveCallbacks.get(i).invoke(entity);
        }
    }

    public void postLoad(Entity entity) {
        for (int i = 0; i < this._postLoadCallbacks.size(); ++i) {
            this._postLoadCallbacks.get(i).invoke(entity);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanClass.getName() + "]";
    }
}

