/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FloatType
extends Type {
    private static final L10N L = new L10N(FloatType.class);
    private static final FloatType FLOAT_TYPE = new FloatType();

    private FloatType() {
    }

    public static FloatType create() {
        return FLOAT_TYPE;
    }

    public String getName() {
        return "java.lang.Float";
    }

    public boolean isNumeric() {
        return true;
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(7, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.FloatType.toFloat(" + rs + ".getFloat(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.FloatType.toFloat(rs.getFloat(columnNames[" + index + "])," + "rs.wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.REAL);");
        out.println("else");
        out.println("  " + pstmt + ".setFloat(" + index + "++, " + value + ".floatValue());");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.REAL);");
    }

    public static Float toFloat(float value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Float(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        float value = rs.getFloat(index);
        return rs.wasNull() ? null : new Float(value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 6);
        } else {
            pstmt.setFloat(index, ((Float)value).floatValue());
        }
    }
}

