/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.idgen.AmberTableGenerator;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.HashMap;

public class GeneratorTableType
extends Type {
    private static final L10N L = new L10N(GeneratorTableType.class);
    private AmberPersistenceUnit _amberPersistenceUnit;
    private Table _table;
    private String _keyColumn = "GEN_KEY";
    private String _valueColumn = "GEN_VALUE";
    private HashMap<String, AmberTableGenerator> _genMap = new HashMap();

    public GeneratorTableType(AmberPersistenceUnit amberPersistenceUnit, String name) {
        this._amberPersistenceUnit = amberPersistenceUnit;
        this._table = amberPersistenceUnit.createTable(name);
    }

    public AmberPersistenceUnit getAmberManager() {
        return this._amberPersistenceUnit;
    }

    public String getName() {
        return "Generator";
    }

    public Table getTable() {
        return this._table;
    }

    public String getKeyColumn() {
        return this._keyColumn;
    }

    public String getValueColumn() {
        return this._valueColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmberTableGenerator createGenerator(String name) {
        HashMap<String, AmberTableGenerator> hashMap = this._genMap;
        synchronized (hashMap) {
            AmberTableGenerator gen = this._genMap.get(name);
            if (gen == null) {
                gen = new AmberTableGenerator(this.getAmberManager(), this, name);
                this._genMap.put(name, gen);
            }
            return gen;
        }
    }

    public void init() throws ConfigException {
        Column keyColumn = this.getTable().createColumn(this._keyColumn, StringType.create());
        keyColumn.setPrimaryKey(true);
        keyColumn.setLength(254);
        Column valueColumn = this.getTable().createColumn(this._valueColumn, LongType.create());
        if (this.getAmberManager().getCreateDatabaseTables()) {
            this.getTable().createDatabaseTable(this.getAmberManager());
        }
        for (AmberTableGenerator gen : this._genMap.values()) {
            try {
                gen.init(this.getAmberManager());
            }
            catch (SQLException e) {
                throw ConfigException.create((Throwable)e);
            }
        }
    }

    public String toString() {
        return "GeneratorTableType[" + this.getName() + "]";
    }
}

