/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectType
extends Type {
    private static final L10N L = new L10N(ObjectType.class);
    private static final ObjectType OBJECT_TYPE = new ObjectType();

    private ObjectType() {
    }

    public static ObjectType create() {
        return OBJECT_TYPE;
    }

    public String getName() {
        return "java.lang.Object";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getObject(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setObject(" + index + "++, " + value + ");");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setObject(index, value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }
}

