/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.ByteType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PrimitiveByteType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveByteType.class);
    private static final PrimitiveByteType BYTE_TYPE = new PrimitiveByteType();

    private PrimitiveByteType() {
    }

    public static PrimitiveByteType create() {
        return BYTE_TYPE;
    }

    public String getName() {
        return "byte";
    }

    public boolean isNumeric() {
        return true;
    }

    public Type getForeignType() {
        return ByteType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-6, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getByte(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getByte(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setByte(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.TINYINT);");
    }

    public String toObject(String value) {
        return "new Byte(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").byteValue()";
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

