/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.DoubleType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PrimitiveDoubleType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveDoubleType.class);
    private static final PrimitiveDoubleType DOUBLE_TYPE = new PrimitiveDoubleType();

    private PrimitiveDoubleType() {
    }

    public static PrimitiveDoubleType create() {
        return DOUBLE_TYPE;
    }

    public String getName() {
        return "double";
    }

    public boolean isNumeric() {
        return true;
    }

    public Type getForeignType() {
        return DoubleType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(8, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getDouble(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getDouble(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setDouble(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.DOUBLE);");
    }

    public String toObject(String value) {
        return "new Double(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").doubleValue()";
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

