/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.FloatType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PrimitiveFloatType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveFloatType.class);
    private static final PrimitiveFloatType FLOAT_TYPE = new PrimitiveFloatType();

    private PrimitiveFloatType() {
    }

    public static PrimitiveFloatType create() {
        return FLOAT_TYPE;
    }

    public String getName() {
        return "float";
    }

    public boolean isNumeric() {
        return true;
    }

    public Type getForeignType() {
        return FloatType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(7, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getFloat(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getFloat(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setFloat(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.REAL);");
    }

    public String toObject(String value) {
        return "new Float(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").floatValue()";
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

