/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveLongType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveLongType.class);
    private static final PrimitiveLongType LONG_TYPE = new PrimitiveLongType();

    private PrimitiveLongType() {
    }

    public static PrimitiveLongType create() {
        return LONG_TYPE;
    }

    public String getName() {
        return "long";
    }

    public boolean isNumeric() {
        return true;
    }

    public Type getForeignType() {
        return LongType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-5, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getLong(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getLong(columnNames[" + index + "])");
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveLongType.toForeignLong(" + rs + ".getLong(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setLong(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setLong(" + index + "++, " + value + " + 1);");
    }

    public String toObject(String value) {
        return "new Long(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").longValue()";
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        long v = rs.getLong(index);
        return rs.wasNull() ? null : new Long(v);
    }

    public static Long toForeignLong(long value, boolean wasNull) {
        if (wasNull || value == 0L) {
            return null;
        }
        return new Long(value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setString(index, null);
        } else if (value instanceof Number) {
            pstmt.setString(index, value.toString());
        } else {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
    }
}

