/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlDateType
extends Type {
    private static final L10N L = new L10N(SqlDateType.class);
    private static final SqlDateType SQL_DATE_TYPE = new SqlDateType();

    private SqlDateType() {
    }

    public static SqlDateType create() {
        return SQL_DATE_TYPE;
    }

    public String getName() {
        return "java.sql.Date";
    }

    public boolean isAssignableTo(JClass javaType) {
        return javaType.isAssignableFrom(Date.class);
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(91, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getDate(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getDate(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.DATE);");
        out.println("else");
        out.println("  " + pstmt + ".setDate(" + index + "++, " + value + ");");
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setDate(index, (Date)value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getDate(index);
    }
}

