/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StringType
extends Type {
    private static final L10N L = new L10N(StringType.class);
    private static final StringType STRING_TYPE = new StringType();

    private StringType() {
    }

    public static StringType create() {
        return STRING_TYPE;
    }

    public String getName() {
        return "java.lang.String";
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        if (length == 0) {
            length = 255;
        }
        return "varchar(" + length + ")";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getString(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getString(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (pstmt.startsWith("query")) {
            out.println(pstmt + ".setString(" + index + "++, " + value + ");");
        } else {
            out.println("StringType.setString(" + pstmt + ", " + index + "++, " + value + ");");
        }
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setString(index, null);
        } else if (value instanceof String) {
            pstmt.setString(index, (String)value);
        } else {
            pstmt.setObject(index, value);
        }
    }

    public void setParameter(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 12);
        } else {
            pstmt.setString(index, value);
        }
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getString(index);
    }

    public static void setString(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setString(index, null);
        } else if (value instanceof String) {
            pstmt.setString(index, (String)value);
        } else {
            pstmt.setObject(index, value);
        }
    }

    public static void setString(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 12);
        } else {
            pstmt.setString(index, value);
        }
    }
}

