/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.bytecode.JClass;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class Type {
    private static final L10N L = new L10N(Type.class);

    public abstract String getName();

    public boolean isBoolean() {
        return false;
    }

    public boolean isNumeric() {
        return false;
    }

    public String getJavaTypeName() {
        return this.getName();
    }

    public int getColumnCount() {
        return 1;
    }

    public void init() throws ConfigException {
    }

    public Type getForeignType() {
        return this;
    }

    public String getForeignTypeName() {
        return this.getForeignType().getJavaTypeName();
    }

    public boolean isAssignableTo(JClass javaType) {
        return true;
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        if (length == 0) {
            length = 255;
        }
        return manager.getCreateColumnSQL(12, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index, JClass targetType) throws IOException {
        String i = indexVar + " + " + index;
        if ("java.lang.Byte".equals(targetType.getName())) {
            out.print("new Byte((byte) " + rs + ".getInt(" + i + "))");
        } else if ("java.lang.Short".equals(targetType.getName())) {
            out.print("new Short((short) " + rs + ".getInt(" + i + "))");
        } else if ("java.lang.Integer".equals(targetType.getName())) {
            out.print("new Integer(" + rs + ".getInt(" + i + "))");
        } else if ("java.lang.Long".equals(targetType.getName())) {
            out.print("new Long(" + rs + ".getLong(" + i + "))");
        } else if ("java.lang.Float".equals(targetType.getName())) {
            out.print("new Float((float) " + rs + ".getDouble(" + i + "))");
        } else if ("java.lang.Double".equals(targetType.getName())) {
            out.print("new Double(" + rs + ".getDouble(" + i + "))");
        } else if ("java.lang.String".equals(targetType.getName())) {
            out.print(rs + ".getString(" + i + ")");
        } else {
            out.print("(" + targetType.getName() + ") ");
            out.print(rs + ".getObject(" + i + ")");
        }
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.getForeignType().generateLoad(out, rs, indexVar, index);
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String generateIncrementVersion(String value) throws IOException {
        return value + " + 1";
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        this.generateSet(out, pstmt, index, null);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setObject(index, value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getObject(index);
    }

    public EntityItem findItem(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object getObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getObject(rs, index);
    }

    public String toObject(String value) {
        return value;
    }

    public String fromObject(String value) {
        return this.generateCastFromObject(value);
    }

    public Object toObject(long value) {
        return new Long(value);
    }

    public String generateCastFromObject(String value) {
        return "((" + this.getName() + ") " + value + ")";
    }

    public String generateEquals(String a, String b) {
        return a + ".equals(" + b + ")";
    }

    public String generateIsNull(String value) {
        return "(" + value + " == " + this.generateNull() + ")";
    }

    public String generateNull() {
        return "null";
    }

    public boolean isAutoIncrement() {
        return false;
    }
}

