/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.ManagementConfig;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;

public class BootManager
implements EnvironmentBean {
    private static final L10N L = new L10N(BootManager.class);
    private boolean _isWatchdogManagerConfig;
    private ArrayList<ContainerProgram> _clusterDefaultList = new ArrayList();
    private HashMap<String, WatchdogClient> _watchdogMap = new HashMap();
    private ClassLoader _classLoader;
    private WatchdogArgs _args;
    private Path _resinHome;
    private Path _rootDirectory;
    private ManagementConfig _management;
    private String _password;

    BootManager(WatchdogArgs args) {
        this._args = args;
        this._classLoader = new EnvironmentClassLoader();
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    public Path getResinHome() {
        if (this._resinHome != null) {
            return this._resinHome;
        }
        return this._args.getResinHome();
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getRootDirectory() {
        if (this._rootDirectory != null) {
            return this._rootDirectory;
        }
        return this._args.getRootDirectory();
    }

    public Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setManagement(ManagementConfig management) {
        this._management = management;
    }

    public String getAdminCookie() {
        if (this._management != null) {
            return this._management.getAdminCookie();
        }
        return this._password;
    }

    public WatchdogClient findClient(String id) {
        return this._watchdogMap.get(id);
    }

    public void addClient(WatchdogClient client) {
        this._watchdogMap.put(client.getId(), client);
    }

    public WatchdogManagerConfig createWatchdogManager() {
        this._isWatchdogManagerConfig = true;
        return new WatchdogManagerConfig();
    }

    public void addClusterDefault(ContainerProgram program) {
        this._clusterDefaultList.add(program);
    }

    public ClusterConfig createCluster() {
        ClusterConfig cluster = new ClusterConfig();
        for (int i = 0; i < this._clusterDefaultList.size(); ++i) {
            this._clusterDefaultList.get(i).configure(cluster);
        }
        return cluster;
    }

    public ServerCompatConfig createServer() {
        return new ServerCompatConfig();
    }

    public void addThreadPool(ConfigProgram program) {
    }

    public void setGroupName(ConfigProgram program) {
    }

    public void setUserName(ConfigProgram program) {
    }

    public void setMinFreeMemory(ConfigProgram program) {
    }

    public void setSecurityManager(ConfigProgram program) {
    }

    public void addSecurityProvider(Class providerClass) {
    }

    public void setEnvironmentSystemProperties(ConfigProgram program) {
    }

    public class SrunCompatConfig {
        private String _id = "";

        public void setId(String id) {
            this._id = id;
        }

        public void setServerId(String id) {
            this._id = id;
        }

        public void addBuilderProgram(ConfigProgram program) {
        }

        @PostConstruct
        public void init() {
            if (BootManager.this._isWatchdogManagerConfig) {
                return;
            }
            WatchdogClient client = BootManager.this.findClient(this._id);
            if (client != null) {
                return;
            }
            WatchdogConfig config = new WatchdogConfig(BootManager.this.getArgs());
            client = new WatchdogClient(BootManager.this, config);
            BootManager.this._watchdogMap.put(this._id, client);
        }
    }

    public class ClusterCompatConfig {
        public SrunCompatConfig createSrun() {
            return new SrunCompatConfig();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class ServerCompatConfig {
        public ClusterCompatConfig createCluster() {
            return new ClusterCompatConfig();
        }

        public SrunCompatConfig createHttp() {
            return new SrunCompatConfig();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class ClusterConfig {
        private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();

        public void addServerDefault(ContainerProgram program) {
            this._serverDefaultList.add(program);
        }

        public void addManagement(ManagementConfig management) {
            BootManager.this.setManagement(management);
        }

        public WatchdogConfig createServer() {
            WatchdogConfig config = new WatchdogConfig(BootManager.this.getArgs());
            for (int i = 0; i < this._serverDefaultList.size(); ++i) {
                this._serverDefaultList.get(i).configure(config);
            }
            return config;
        }

        public void addServer(WatchdogConfig config) throws ConfigException {
            if (BootManager.this._isWatchdogManagerConfig) {
                return;
            }
            if (BootManager.this.findClient(config.getId()) != null) {
                throw new ConfigException(L.l("<server id='{0}'> is a duplicate server.  servers must have unique ids.", (Object)config.getId()));
            }
            BootManager.this.addClient(new WatchdogClient(BootManager.this, config));
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class WatchdogManagerConfig {
        private ArrayList<ContainerProgram> _watchdogDefaultList = new ArrayList();

        public void setWatchdogPort(int watchdogPort) {
            if (BootManager.this._args.getWatchdogPort() == 0) {
                BootManager.this._args.setWatchdogPort(watchdogPort);
            }
        }

        public void addWatchdogDefault(ContainerProgram program) {
            this._watchdogDefaultList.add(program);
        }

        public WatchdogConfig createWatchdog() {
            WatchdogConfig config = new WatchdogConfig(BootManager.this.getArgs());
            for (int i = 0; i < this._watchdogDefaultList.size(); ++i) {
                this._watchdogDefaultList.get(i).configure(config);
            }
            return config;
        }

        public void addWatchdog(WatchdogConfig config) throws ConfigException {
            if (BootManager.this.findClient(config.getId()) != null) {
                throw new ConfigException(L.l("<server id='{0}'> is a duplicate server.  servers must have unique ids.", (Object)config.getId()));
            }
            BootManager.this.addClient(new WatchdogClient(BootManager.this, config));
        }
    }
}

