/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.admin.ManagementAuthenticator;
import com.caucho.server.security.PasswordUser;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ManagementConfig {
    private static L10N L = new L10N(ManagementConfig.class);
    private static Logger log = Logger.getLogger(ManagementConfig.class.getName());
    private ManagementAuthenticator _auth;

    public void addUser(User user) {
        if (this._auth == null) {
            this._auth = new ManagementAuthenticator();
        }
        this._auth.addUser(user.getName(), user.getPasswordUser());
    }

    public String getAdminCookie() {
        if (this._auth != null) {
            return this._auth.getHash();
        }
        return null;
    }

    public void addBuilderProgram(ConfigProgram program) {
    }

    @PostConstruct
    public void init() {
        try {
            if (this._auth != null) {
                this._auth.init();
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public static class User {
        private String _name;
        private String _password;
        private boolean _isDisabled;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getPassword() {
            return this._password;
        }

        public void setDisable(boolean isDisabled) {
            this._isDisabled = isDisabled;
        }

        public boolean isDisable() {
            return this._isDisabled;
        }

        PasswordUser getPasswordUser() {
            if (this._name == null) {
                throw new ConfigException(L.l("management <user> requires a 'name' attribute"));
            }
            boolean isAnonymous = false;
            return new PasswordUser(new BasicPrincipal(this._name), this._password.toCharArray(), this._isDisabled, isAnonymous, new String[]{"resin-admin"});
        }
    }
}

