/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.security.CodeSource;
import java.security.SecureClassLoader;

public class ProLoader
extends SecureClassLoader {
    private Path _resinHome;
    private Path _libexec;
    private JarPath _proJar;
    private JarPath _licenseJar;

    private ProLoader(Path resinHome) {
        super(ClassLoader.getSystemClassLoader());
        this._resinHome = resinHome;
        boolean is64bit = "64".equals(System.getProperty("sun.arch.data.model"));
        this._libexec = is64bit ? this._resinHome.lookup("libexec64") : this._resinHome.lookup("libexec");
        this._proJar = JarPath.create(this._resinHome.lookup("lib/pro.jar"));
        this._licenseJar = JarPath.create(this._resinHome.lookup("lib/license.jar"));
    }

    static ProLoader create(Path resinHome) {
        if (resinHome.lookup("lib/pro.jar").canRead()) {
            return new ProLoader(resinHome);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int length;
        String className = name.replace('.', '/') + ".class";
        Path path = this._proJar.lookup(className);
        if (path.getLength() < 0L) {
            path = this._licenseJar.lookup(className);
        }
        if ((length = (int)path.getLength()) <= 0) {
            return super.loadClass(name, resolve);
        }
        byte[] buffer = new byte[length];
        try {
            Class<?> clazz;
            ReadStream is = null;
            try {
                Class<?> cl;
                is = path.openRead();
                is.readAll(buffer, 0, buffer.length);
                clazz = cl = this.defineClass(name, buffer, 0, buffer.length, (CodeSource)null);
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return clazz;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    public String findLibrary(String name) {
        Path path = this._libexec.lookup("lib" + name + ".so");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this._libexec.lookup("lib" + name + ".jnilib");
        if (path.canRead()) {
            return path.getNativePath();
        }
        return super.findLibrary(name);
    }
}

