/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.Version;
import com.caucho.boot.BootManager;
import com.caucho.boot.ProLoader;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.loader.Environment;
import com.caucho.server.resin.ResinELContext;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinBoot {
    private static L10N _L;
    private static Logger _log;
    private WatchdogArgs _args;
    private WatchdogClient _client;

    ResinBoot(String[] argv) throws Exception {
        this._args = new WatchdogArgs(argv);
        Path resinHome = this._args.getResinHome();
        ProLoader loader = ProLoader.create(resinHome);
        if (loader != null) {
            System.setProperty("resin.home", resinHome.getNativePath());
            Thread.currentThread().setContextClassLoader(loader);
            Vfs.initJNI();
            resinHome = Vfs.lookup(resinHome.getFullPath());
            this._args.setResinHome(resinHome);
        }
        Environment.init();
        System.setProperty("resin.home", resinHome.getNativePath());
        if (!this._args.getResinConf().canRead()) {
            throw new ConfigException(ResinBoot.L().l("Resin/{0} can't open configuration file '{1}'", (Object)Version.VERSION, (Object)this._args.getResinConf().getNativePath()));
        }
        Config config = new Config();
        BootManager bootManager = new BootManager(this._args);
        ResinELContext elContext = this._args.getELContext();
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.addSingletonByName(elContext.getResinHome(), "resinHome");
        webBeans.addSingletonByName(elContext.getJavaVar(), "java");
        webBeans.addSingletonByName(elContext.getResinVar(), "resin");
        webBeans.addSingletonByName(elContext.getServerVar(), "server");
        config.configure((Object)bootManager, this._args.getResinConf(), "com/caucho/server/resin/resin.rnc");
        this._client = bootManager.findClient(this._args.getServerId());
        if (this._client == null) {
            throw new ConfigException(ResinBoot.L().l("Resin/{0}: -server '{1}' does not match any defined <server>\nin {2}.", (Object)Version.VERSION, (Object)this._args.getServerId(), (Object)this._args.getResinConf()));
        }
        Path logDirectory = bootManager.getLogDirectory();
        if (!logDirectory.exists()) {
            logDirectory.mkdirs();
            if (this._client.getUserName() != null) {
                logDirectory.changeOwner(this._client.getUserName());
            }
            if (this._client.getGroupName() != null) {
                logDirectory.changeOwner(this._client.getGroupName());
            }
        }
    }

    boolean start() throws Exception {
        if (this._args.isStatus()) {
            try {
                String status = this._client.statusWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} status for watchdog at {1}:{2}", (Object)Version.VERSION, (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort()));
                System.out.println(status);
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort(), (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isStart()) {
            try {
                this._client.startWatchdog(this._args.getArgv());
                System.out.println(ResinBoot.L().l("Resin/{0} started -server '{1}' for watchdog at {2}:{3}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort(), (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isStop()) {
            try {
                this._client.stopWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} stopped -server '{1}' for watchdog at {2}:{3}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't stop -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort(), (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isKill()) {
            try {
                this._client.killWatchdog();
                System.out.println(ResinBoot.L().l("Resin/{0} killed -server '{1}' for watchdog at {2}:{3}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't kill -server '{1}' for watchdog at {2}:{3}.\n{4}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort(), (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isRestart()) {
            try {
                this._client.restartWatchdog(this._args.getArgv());
                System.out.println(ResinBoot.L().l("Resin/{0} stopped -server '{1}' for watchdog at {2}:{3}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)this._client.getWatchdogAddress(), (Object)this._client.getWatchdogPort()));
            }
            catch (Exception e) {
                System.out.println(ResinBoot.L().l("Resin/{0} can't restart -server '{1}'.\n{2}", (Object)Version.VERSION, (Object)this._client.getId(), (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isShutdown()) {
            try {
                this._client.shutdown();
                System.err.println(ResinBoot.L().l("Resin/{0} shutdown ResinWatchdogManager", (Object)Version.VERSION));
            }
            catch (Exception e) {
                System.err.println(ResinBoot.L().l("Resin/{0} can't shutdown ResinWatchdogManager.\n{1}", (Object)Version.VERSION, (Object)e.toString()));
                ResinBoot.log().log(Level.FINE, e.toString(), e);
                System.exit(1);
            }
            return false;
        }
        if (this._args.isSingle()) {
            return this._client.startSingle() != 0;
        }
        throw new IllegalStateException(ResinBoot.L().l("Unknown start mode"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        try {
            ResinBoot boot = new ResinBoot(argv);
            while (boot.start()) {
                try {
                    ResinBoot resinBoot = boot;
                    synchronized (resinBoot) {
                        boot.wait(5000L);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ConfigException) {
                System.out.println(e.getMessage());
                System.exit(2);
            }
            e.printStackTrace();
            System.exit(3);
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(ResinBoot.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ResinBoot.class.getName());
        }
        return _log;
    }
}

