/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogTask;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.WatchdogMXBean;
import com.caucho.server.port.Port;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Watchdog {
    private static final L10N L = new L10N(Watchdog.class);
    private static final Logger log = Logger.getLogger(Watchdog.class.getName());
    private final String _id;
    private WatchdogConfig _config;
    private boolean _isSingle;
    private WatchdogTask _task;
    private Date _initialStartTime;
    private Date _lastStartTime;
    private int _startCount;
    private WatchdogAdmin _admin;

    Watchdog(String id, WatchdogArgs args) {
        this._id = id;
        this._config = new WatchdogConfig(args);
        this._admin = new WatchdogAdmin();
    }

    Watchdog(WatchdogConfig config) {
        this._id = config.getId();
        this._config = config;
        this._admin = new WatchdogAdmin();
    }

    public String getId() {
        return this._id;
    }

    WatchdogArgs getArgs() {
        return this._config.getArgs();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    public WatchdogConfig getConfig() {
        return this._config;
    }

    public void setConfig(WatchdogConfig config) {
        this._config = config;
    }

    public Path getJavaHome() {
        return this._config.getJavaHome();
    }

    public String getJavaExe() {
        return this._config.getJavaExe();
    }

    public ArrayList<String> getJvmArgs() {
        return this._config.getJvmArgs();
    }

    public ArrayList<String> getJvmClasspath() {
        return this._config.getJvmClasspath();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public boolean isSingle() {
        return this._isSingle;
    }

    public Path getLogPath() {
        return this._config.getLogPath();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    Iterable<Port> getPorts() {
        return this._config.getPorts();
    }

    Path getChroot() {
        return this._config.getChroot();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._config.getResinHome();
    }

    Path getResinRoot() {
        return this._config.getResinRoot();
    }

    Path getResinConf() {
        return this._config.getResinConf();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    public String getState() {
        WatchdogTask task = this._task;
        if (task == null) {
            return "inactive";
        }
        return task.getState();
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public int startSingle() {
        if (this._task != null) {
            return -1;
        }
        this._isSingle = true;
        this._task = new WatchdogTask(this);
        this._task.start();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        WatchdogTask task = null;
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this._task != null) {
                throw new IllegalStateException(L.l("Can't start new task because of old task '{0}'", (Object)this._task));
            }
            this._task = task = new WatchdogTask(this);
        }
        task.start();
    }

    public void stop() {
        WatchdogTask task = this._task;
        this._task = null;
        if (task != null) {
            task.stop();
        }
    }

    public void kill() {
        WatchdogTask task = this._task;
        this._task = null;
        if (task != null) {
            task.kill();
        }
    }

    void notifyTaskStarted() {
        ++this._startCount;
        this._lastStartTime = new Date(Alarm.getExactTime());
        if (this._initialStartTime == null) {
            this._initialStartTime = this._lastStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeTask(WatchdogTask task) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            if (this._task == task) {
                this._task = null;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    class WatchdogAdmin
    extends AbstractManagedObject
    implements WatchdogMXBean {
        WatchdogAdmin() {
            this.registerSelf();
        }

        public String getId() {
            return Watchdog.this.getId();
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "Watchdog";
        }

        public String getResinHome() {
            return Watchdog.this.getResinHome().getNativePath();
        }

        public String getResinRoot() {
            return Watchdog.this.getResinRoot().getNativePath();
        }

        public String getResinConf() {
            return Watchdog.this.getResinConf().getNativePath();
        }

        public String getUserName() {
            String userName = Watchdog.this.getUserName();
            if (userName != null) {
                return userName;
            }
            return System.getProperty("user.name");
        }

        public String getState() {
            WatchdogTask task = Watchdog.this._task;
            if (task == null) {
                return "inactive";
            }
            return task.getState();
        }

        public Date getInitialStartTime() {
            return Watchdog.this._initialStartTime;
        }

        public Date getStartTime() {
            return Watchdog.this._lastStartTime;
        }

        public int getStartCount() {
            return Watchdog.this._startCount;
        }

        public void start() {
            Watchdog.this.start();
        }

        public void stop() {
            Watchdog.this.stop();
        }

        public void kill() {
            Watchdog.this.kill();
        }
    }
}

