/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.Version;
import com.caucho.boot.Boot;
import com.caucho.boot.BootManager;
import com.caucho.boot.Watchdog;
import com.caucho.boot.WatchdogAPI;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.HessianHmuxProxy;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchdogClient {
    private static final L10N L = new L10N(WatchdogClient.class);
    private static final Logger log = Logger.getLogger(WatchdogClient.class.getName());
    private final BootManager _bootManager;
    private String _id = "";
    private WatchdogConfig _config;
    private Watchdog _watchdog;
    private Boot _jniBoot;

    WatchdogClient(BootManager bootManager, WatchdogConfig config) {
        this._bootManager = bootManager;
        this._config = config;
        this._id = config.getId();
    }

    public String getId() {
        return this._id;
    }

    public String getAdminCookie() {
        return this._bootManager.getAdminCookie();
    }

    public String getWatchdogAddress() {
        return this._config.getWatchdogAddress();
    }

    public int getWatchdogPort() {
        return this._config.getWatchdogPort();
    }

    String[] getArgv() {
        return this._config.getArgv();
    }

    Path getPwd() {
        return this._config.getPwd();
    }

    Path getResinHome() {
        return this._bootManager.getResinHome();
    }

    Path getRootDirectory() {
        return this._bootManager.getRootDirectory();
    }

    boolean hasXmx() {
        return this._config.hasXmx();
    }

    boolean hasXss() {
        return this._config.hasXss();
    }

    boolean is64bit() {
        return this._config.is64bit();
    }

    boolean isVerbose() {
        return this._config.isVerbose();
    }

    public String getGroupName() {
        return this._config.getGroupName();
    }

    public String getUserName() {
        return this._config.getUserName();
    }

    public Path getLogDirectory() {
        return this._bootManager.getLogDirectory();
    }

    public long getShutdownWaitTime() {
        return this._config.getShutdownWaitTime();
    }

    public String statusWatchdog() throws IOException {
        WatchdogAPI watchdog = this.getProxy();
        try {
            return watchdog.status(this.getAdminCookie());
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable e1 = e;
            while (e1.getCause() != null) {
                e1 = e1.getCause();
            }
            log.log(Level.FINE, e.toString(), e);
            return e1.toString();
        }
    }

    public void startWatchdog(String[] argv) throws ConfigException, IOException {
        if (this.getUserName() != null && !this.hasBoot()) {
            throw new ConfigException(L.l("<user-name> requires Resin Professional and compiled JNI.  Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin.so and check for a valid license in $RESIN_HOME/licenses."));
        }
        if (this.getGroupName() != null && !this.hasBoot()) {
            throw new ConfigException(L.l("<group-name> requires Resin Professional and compiled JNI.  Check the $RESIN_HOME/libexec or $RESIN_HOME/libexec64 directory for libresin.so and check for a valid license in $RESIN_HOME/licenses."));
        }
        WatchdogAPI watchdog = this.getProxy();
        try {
            watchdog.start(this.getAdminCookie(), argv);
            return;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ConnectException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.launchManager(argv);
    }

    public void stopWatchdog() throws IOException {
        WatchdogAPI watchdog = this.getProxy();
        try {
            watchdog.stop(this.getAdminCookie(), this.getId());
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException(L.l("Can't connect to ResinWatchdogManager.\n{1}", (Object)Version.VERSION, (Object)e.toString()), e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void killWatchdog() throws IOException {
        WatchdogAPI watchdog = this.getProxy();
        try {
            watchdog.kill(this.getAdminCookie(), this.getId());
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException(L.l("Can't connect to ResinWatchdogManager.\n{1}", (Object)Version.VERSION, (Object)e.toString()), e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void restartWatchdog(String[] argv) throws IOException {
        try {
            this.stopWatchdog();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        this.startWatchdog(argv);
    }

    public int startSingle() throws IOException {
        if (this._watchdog == null) {
            this._watchdog = new Watchdog(this._config);
        }
        return this._watchdog.startSingle();
    }

    public boolean shutdown() throws IOException {
        WatchdogAPI watchdog = this.getProxy();
        try {
            return watchdog.shutdown(this.getAdminCookie());
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException(L.l("Can't connect to ResinWatchdogManager.\n{1}", (Object)Version.VERSION, (Object)e.toString()), e);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    private WatchdogAPI getProxy() {
        String url = "hmux://" + this.getWatchdogAddress() + ":" + this.getWatchdogPort() + "/watchdog";
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("host", "resin-admin");
        Path path = Vfs.lookup(url, attr);
        return HessianHmuxProxy.create(path, WatchdogAPI.class);
    }

    public void launchManager(String[] argv) throws IOException {
        int i;
        String libexecPath;
        log.fine(this + " starting ResinWatchdogManager");
        Path resinHome = this.getResinHome();
        Path resinRoot = this.getRootDirectory();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File(resinRoot.getNativePath()));
        Map<String, String> env = builder.environment();
        env.putAll(System.getenv());
        String classPath = WatchdogArgs.calculateClassPath(resinHome);
        env.put("CLASSPATH", classPath);
        String ldLibraryPath = env.get("LD_LIBRARY_PATH");
        String dyldLibraryPath = env.get("DYLD_LIBRARY_PATH");
        if (this.is64bit()) {
            libexecPath = resinHome.lookup("libexec64").getNativePath();
            this.appendEnvPath(env, "PATH", resinHome.lookup("win64").getNativePath());
        } else {
            libexecPath = resinHome.lookup("libexec").getNativePath();
            this.appendEnvPath(env, "PATH", resinHome.lookup("win32").getNativePath());
        }
        if (ldLibraryPath == null || "".equals(ldLibraryPath)) {
            ldLibraryPath = ldLibraryPath + libexecPath;
        } else if (ldLibraryPath.indexOf(libexecPath) < 0) {
            ldLibraryPath = ldLibraryPath + File.pathSeparatorChar + libexecPath;
        }
        if (dyldLibraryPath == null || "".equals(dyldLibraryPath)) {
            dyldLibraryPath = dyldLibraryPath + libexecPath;
        } else if (ldLibraryPath.indexOf(libexecPath) < 0) {
            dyldLibraryPath = dyldLibraryPath + File.pathSeparatorChar + libexecPath;
        }
        env.put("LD_LIBRARY_PATH", ldLibraryPath);
        env.put("DYLD_LIBRARY_PATH", dyldLibraryPath);
        ArrayList<String> list = new ArrayList<String>();
        list.add(this._config.getJavaExe());
        list.add("-Djava.util.logging.manager=com.caucho.log.LogManagerImpl");
        list.add("-Djavax.management.builder.initial=com.caucho.jmx.MBeanServerBuilderImpl");
        list.add("-Djava.awt.headless=true");
        list.add("-Dresin.home=" + resinHome.getPath());
        list.add("-Dresin.root=" + resinRoot.getPath());
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-Djava.class.path=") || !argv[i].startsWith("-J")) continue;
            list.add(argv[i].substring(2));
        }
        list.add("-Xrs");
        if (!this._config.hasWatchdogXss()) {
            list.add("-Xss256k");
        }
        if (!this._config.hasWatchdogXmx()) {
            list.add("-Xmx32m");
        }
        list.addAll(this._config.getWatchdogJvmArgs());
        if (!list.contains("-d32") && !list.contains("-d64") && this.is64bit() && !CauchoSystem.isWindows()) {
            list.add("-d64");
        }
        list.add("com.caucho.boot.WatchdogManager");
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-conf") || argv[i].equals("--conf")) {
                list.add(argv[i]);
                list.add(resinHome.lookup(argv[i + 1]).getNativePath());
                ++i;
                continue;
            }
            list.add(argv[i]);
        }
        builder = builder.command(list);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream stdIs = process.getInputStream();
        OutputStream stdOs = process.getOutputStream();
        stdIs.close();
        stdOs.close();
    }

    private void appendEnvPath(Map<String, String> env, String prop, String value) {
        String oldValue = env.get(prop);
        if (oldValue != null && !"".equals(oldValue)) {
            value = value + File.pathSeparator + oldValue;
        }
        env.put(prop, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    Boot getJniBoot() {
        if (this._jniBoot != null) {
            return this._jniBoot.isValid() ? this._jniBoot : null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.boot.JniBoot", false, loader);
            this._jniBoot = (Boot)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
        }
        catch (IllegalStateException e) {
            log.fine(e.toString());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return this._jniBoot != null && this._jniBoot.isValid() ? this._jniBoot : null;
    }

    private boolean hasBoot() {
        try {
            Boot boot = this.getJniBoot();
            return boot.isValid();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }
}

