/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.WatchdogArgs;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.server.port.Port;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchdogConfig {
    private static final L10N L = new L10N(WatchdogConfig.class);
    private static final Logger log = Logger.getLogger(WatchdogConfig.class.getName());
    private static final int WATCHDOG_PORT_DEFAULT = 6600;
    private String _id = "";
    private WatchdogArgs _args;
    private Path _javaHome;
    private Path _javaExe;
    private ArrayList<String> _jvmArgs = new ArrayList();
    private ArrayList<String> _jvmClasspath = new ArrayList();
    private ArrayList<String> _watchdogJvmArgs = new ArrayList();
    private Path _resinHome;
    private Path _resinRoot;
    private Path _resinConf;
    private Path _logPath;
    private boolean _is64bit;
    private boolean _hasXss;
    private boolean _hasXmx;
    private Path _chroot;
    private Path _pwd;
    private String _watchdogAddress = "127.0.0.1";
    private int _watchdogPort;
    private String _userName;
    private String _groupName;
    private ArrayList<Port> _ports = new ArrayList();
    private long _shutdownWaitTime = 60000L;
    private boolean _isVerbose;
    private boolean _isWatchdog64bit;
    private boolean _hasWatchdogXss;
    private boolean _hasWatchdogXmx;

    WatchdogConfig(WatchdogArgs args) {
        this._args = args;
        this._pwd = Vfs.getPwd();
        this._is64bit = "64".equals(System.getProperty("sun.arch.data.model"));
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    String[] getArgv() {
        return this._args.getArgv();
    }

    public void setVerbose(boolean isVerbose) {
        this._isVerbose = isVerbose;
    }

    public void setJavaExe(Path javaExe) {
        this._javaExe = javaExe;
    }

    public void setJavaHome(Path javaHome) {
        this._javaHome = javaHome;
    }

    public Path getJavaHome() {
        if (this._javaHome != null) {
            return this._javaHome;
        }
        return this._args.getJavaHome();
    }

    public void addJvmArg(String arg) {
        this._jvmArgs.add(arg);
        if (arg.equals("-d64")) {
            this._is64bit = true;
        } else if (arg.startsWith("-Xss")) {
            this._hasXss = true;
        } else if (arg.startsWith("-Xmx")) {
            this._hasXmx = true;
        }
    }

    public ArrayList<String> getJvmArgs() {
        return this._jvmArgs;
    }

    public void addJvmClasspath(String item) {
        if (item == null) {
            return;
        }
        for (String cp : item.split("[" + File.pathSeparatorChar + "]")) {
            if (this._jvmClasspath.contains(cp)) continue;
            this._jvmClasspath.add(cp);
        }
    }

    public ArrayList<String> getJvmClasspath() {
        return this._jvmClasspath;
    }

    public void addWatchdogJvmArg(String arg) {
        this._watchdogJvmArgs.add(arg);
        if (arg.equals("-d64")) {
            this._isWatchdog64bit = true;
        } else if (arg.startsWith("-Xss")) {
            this._hasWatchdogXss = true;
        } else if (arg.startsWith("-Xmx")) {
            this._hasWatchdogXmx = true;
        }
    }

    public ArrayList<String> getWatchdogJvmArgs() {
        return this._watchdogJvmArgs;
    }

    public void addHttp(Port port) throws ConfigException {
        this._ports.add(port);
    }

    public void addProtocol(Port port) throws ConfigException {
        this._ports.add(port);
    }

    public void addOpenPort(Port port) {
        this._ports.add(port);
    }

    public void setUserName(String user) {
        this._userName = user;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setGroupName(String group) {
        this._groupName = group;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public Path getLogPath() {
        if (this._logPath != null) {
            return this._logPath;
        }
        String name = "".equals(this._id) ? "jvm-default.log" : "jvm-" + this._id + ".log";
        return this.getLogDirectory().lookup(name);
    }

    public Path getRootDirectory() {
        return this._args.getRootDirectory();
    }

    public Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    public long getShutdownWaitTime() {
        return this._shutdownWaitTime;
    }

    public int getWatchdogPort() {
        if (this._args.getWatchdogPort() > 0) {
            return this._args.getWatchdogPort();
        }
        if (this._watchdogPort > 0) {
            return this._watchdogPort;
        }
        return 6600;
    }

    public void setWatchdogPort(int port) {
        this._watchdogPort = port;
    }

    public String getWatchdogAddress() {
        if (this._watchdogAddress != null) {
            return this._watchdogAddress;
        }
        return "127.0.0.1";
    }

    public void setWatchdogAddress(String addr) {
        this._watchdogAddress = addr;
    }

    public void setAcceptListenBacklog(ConfigProgram program) {
    }

    public void setAcceptThreadMin(ConfigProgram program) {
    }

    public void setAcceptThreadMax(ConfigProgram program) {
    }

    public void setBindPortsAfterStart(ConfigProgram program) {
    }

    public void setConnectionMax(ConfigProgram program) {
    }

    public void setKeepaliveMax(ConfigProgram program) {
    }

    public void setKeepaliveConnectionTimeMax(ConfigProgram program) {
    }

    public void setKeepaliveSelectEnable(ConfigProgram program) {
    }

    public void setKeepaliveSelectMax(ConfigProgram program) {
    }

    public void setKeepaliveSelectThreadTimeout(ConfigProgram program) {
    }

    public void setKeepaliveThreadTimeout(ConfigProgram program) {
    }

    public void setKeepaliveTimeout(ConfigProgram program) {
    }

    public void setAddress(ConfigProgram program) {
    }

    public void setBackup(ConfigProgram program) {
    }

    public void setLoadBalanceConnectTimeout(ConfigProgram program) {
    }

    public void setLoadBalanceSocketTimeout(ConfigProgram program) {
    }

    public void setLoadBalanceIdleTime(ConfigProgram program) {
    }

    public void setLoadBalanceRecoverTime(ConfigProgram program) {
    }

    public void setLoadBalanceWarmupTime(ConfigProgram program) {
    }

    public void setLoadBalanceWeight(ConfigProgram program) {
    }

    public void setManagement(ConfigProgram program) {
    }

    public void setMemoryFreeMin(ConfigProgram program) {
    }

    public void addProtocol(ConfigProgram program) {
    }

    public void setPort(int port) {
    }

    public void addClusterPort(ConfigProgram program) {
    }

    public void setRedeployMode(ConfigProgram program) {
    }

    public void setShutdownWaitMax(ConfigProgram program) {
    }

    public void setSocketTimeout(ConfigProgram program) {
    }

    public void setSuspendTimeMax(ConfigProgram program) {
    }

    public void setThreadMax(ConfigProgram program) {
    }

    public void setThreadExecutorTaskMax(ConfigProgram program) {
    }

    public void setThreadIdleMin(ConfigProgram program) {
    }

    public void setThreadIdleMax(ConfigProgram program) {
    }

    public void setWatchdogArg(ConfigProgram program) {
    }

    WatchdogArgs getArgs() {
        return this._args;
    }

    Iterable<Port> getPorts() {
        return this._ports;
    }

    Path getChroot() {
        return this._chroot;
    }

    public void setChroot(Path chroot) {
        this._chroot = chroot;
    }

    Path getPwd() {
        return this._pwd;
    }

    Path getResinHome() {
        if (this._resinHome != null) {
            return this._resinHome;
        }
        return this._args.getResinHome();
    }

    public void setResinRoot(Path root) {
        this._resinRoot = root;
    }

    Path getResinRoot() {
        if (this._resinRoot != null) {
            return this._resinRoot;
        }
        return this._args.getRootDirectory();
    }

    public void setResinConf(Path resinConf) {
        this._resinConf = resinConf;
    }

    public Path getResinConf() {
        if (this._resinConf != null) {
            return this._resinConf;
        }
        return this._args.getResinConf();
    }

    boolean hasWatchdogXmx() {
        return this._hasWatchdogXmx;
    }

    boolean hasWatchdogXss() {
        return this._hasWatchdogXss;
    }

    boolean hasXmx() {
        return this._hasXmx;
    }

    boolean hasXss() {
        return this._hasXss;
    }

    boolean is64bit() {
        return this._is64bit;
    }

    boolean isVerbose() {
        if (this._isVerbose) {
            return this._isVerbose;
        }
        return this._args.isVerbose();
    }

    String getJavaExe() {
        if (this._javaExe != null) {
            return this._javaExe.getNativePath();
        }
        Path javaHome = Vfs.lookup(System.getProperty("java.home"));
        if (javaHome.getTail().equals("jre")) {
            javaHome = javaHome.getParent();
        }
        if (javaHome.lookup("bin/javaw.exe").canRead()) {
            return javaHome.lookup("bin/javaw").getNativePath();
        }
        if (javaHome.lookup("bin/java.exe").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        if (javaHome.lookup("bin/java").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        javaHome = Vfs.lookup(System.getProperty("java.home"));
        if (javaHome.lookup("bin/javaw.exe").canRead()) {
            return javaHome.lookup("bin/javaw").getNativePath();
        }
        if (javaHome.lookup("bin/java.exe").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        if (javaHome.lookup("bin/java").canRead()) {
            return javaHome.lookup("bin/java").getNativePath();
        }
        return "java";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

