/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.ManagementConfig;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.Watchdog;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogConfig;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.log.EnvironmentStream;
import com.caucho.log.LogConfig;
import com.caucho.log.RotateStream;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.port.ProtocolDispatchServer;
import com.caucho.server.resin.ResinELContext;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class WatchdogManager
extends ProtocolDispatchServer {
    private static L10N _L;
    private static Logger _log;
    private static WatchdogManager _watchdog;
    private WatchdogArgs _args;
    private Lifecycle _lifecycle = new Lifecycle();
    private int _watchdogPort;
    private String _adminCookie;
    private ManagementConfig _management;
    private Server _dispatchServer;
    private boolean _isWatchdogManagerConfig;
    private HashMap<String, Watchdog> _watchdogMap = new HashMap();

    WatchdogManager(String[] argv) throws Exception {
        _watchdog = this;
        this._args = new WatchdogArgs(argv);
        Vfs.setPwd(this._args.getRootDirectory());
        Path logPath = this.getLogDirectory().lookup("watchdog-manager.log");
        RotateStream stream = RotateStream.create(logPath);
        stream.getRolloverLog().setRolloverSize(new Bytes(0x4000000L));
        stream.init();
        WriteStream out = stream.getStream();
        out.setDisableClose(true);
        EnvironmentStream.setStdout((OutputStream)out);
        EnvironmentStream.setStderr((OutputStream)out);
        LogConfig log = new LogConfig();
        log.setName("");
        log.setPath(logPath);
        log.init();
        ThreadPool.getThreadPool().setThreadIdleMin(1);
        ThreadPool.getThreadPool().setThreadIdleMax(5);
        ResinELContext elContext = this._args.getELContext();
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.addSingletonByName(elContext.getResinHome(), "resinHome");
        webBeans.addSingletonByName(elContext.getJavaVar(), "java");
        webBeans.addSingletonByName(elContext.getResinVar(), "resin");
        webBeans.addSingletonByName(elContext.getServerVar(), "server");
        this._watchdogPort = this._args.getWatchdogPort();
        this.readConfig(this._args);
        Watchdog server = this._watchdogMap.get(this._args.getServerId());
        if (server == null) {
            throw new IllegalStateException(WatchdogManager.L().l("'{0}' is an unknown server", (Object)this._args.getServerId()));
        }
        Cluster cluster = new Cluster();
        ClusterServer clusterServer = new ClusterServer(cluster);
        if (this._watchdogPort > 0) {
            clusterServer.setPort(this._watchdogPort);
        } else {
            clusterServer.setPort(server.getWatchdogPort());
        }
        clusterServer.setAddress(server.getWatchdogAddress());
        clusterServer.getClusterPort().setMinSpareListen(1);
        clusterServer.getClusterPort().setMaxSpareListen(2);
        this._dispatchServer = new Server(clusterServer);
        HostConfig hostConfig = new HostConfig();
        hostConfig.setId("resin-admin");
        hostConfig.init();
        this._dispatchServer.addHost(hostConfig);
        this._dispatchServer.init();
        this._dispatchServer.start();
        Host host = this._dispatchServer.getHost("resin-admin", 0);
        WebAppConfig webAppConfig = new WebAppConfig();
        webAppConfig.setId("");
        webAppConfig.setRootDirectory(new RawString("watchdog-manager"));
        host.addWebApp(webAppConfig);
        WebApp webApp = host.findWebAppByURI("/");
        ServletMapping servlet = webApp.createServletMapping();
        servlet.setServletName("watchdog");
        servlet.addURLPattern("/watchdog");
        servlet.setServletClass("com.caucho.boot.WatchdogServlet");
        servlet.init();
        webApp.addServletMapping(servlet);
        try {
            host.updateWebAppDeploy("/");
        }
        catch (Throwable e) {
            WatchdogManager.log().log(Level.WARNING, e.toString(), e);
        }
        webApp.start();
    }

    static WatchdogManager getWatchdog() {
        return _watchdog;
    }

    public void setAdminCookie(String cookie) {
        if (this._adminCookie == null) {
            this._adminCookie = cookie;
        }
    }

    public String getAdminCookie() {
        if (this._adminCookie != null) {
            return this._adminCookie;
        }
        if (this._management != null) {
            return this._management.getAdminCookie();
        }
        return null;
    }

    Path getRootDirectory() {
        return this._args.getRootDirectory();
    }

    Path getLogDirectory() {
        Path logDirectory = this._args.getLogDirectory();
        if (logDirectory != null) {
            return logDirectory;
        }
        return this.getRootDirectory().lookup("log");
    }

    boolean authenticate(String password) {
        String cookie = this.getAdminCookie();
        if (password == null && cookie == null) {
            return true;
        }
        return password != null && password.equals(this.getAdminCookie());
    }

    Watchdog findServer(String id) {
        return this._watchdogMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String status() {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Watchdog> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            ArrayList<String> keys = new ArrayList<String>(this._watchdogMap.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                Watchdog watchdog = this._watchdogMap.get(key);
                sb.append("\n");
                sb.append("server '" + key + "' : " + watchdog.getState() + "\n");
                if (this.getAdminCookie() == null) {
                    sb.append("  password: missing\n");
                } else {
                    sb.append("  password: ok\n");
                }
                sb.append("  user: " + System.getProperty("user.name"));
                if (watchdog.getGroupName() != null) {
                    sb.append("(" + watchdog.getGroupName() + ")");
                }
                sb.append("\n");
                sb.append("  root: " + watchdog.getResinRoot() + "\n");
                sb.append("  conf: " + watchdog.getResinConf() + "\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startServer(String[] argv) throws ConfigException {
        HashMap<String, Watchdog> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            WatchdogArgs args = new WatchdogArgs(argv);
            String serverId = args.getServerId();
            Vfs.setPwd(this._args.getRootDirectory());
            try {
                this.readConfig(args);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
            Watchdog watchdog = this._watchdogMap.get(serverId);
            if (watchdog == null) {
                throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in '{1}'", (Object)serverId, (Object)this._args.getResinConf()));
            }
            watchdog.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopServer(String serverId) {
        HashMap<String, Watchdog> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            Watchdog watchdog = this._watchdogMap.get(serverId);
            if (watchdog == null) {
                throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in {1}", (Object)serverId, (Object)this._args.getResinConf()));
            }
            watchdog.stop();
        }
    }

    void killServer(String serverId) {
        Watchdog watchdog = this._watchdogMap.get(serverId);
        if (watchdog == null) {
            throw new ConfigException(WatchdogManager.L().l("No matching <server> found for -server '{0}' in {1}", (Object)serverId, (Object)this._args.getResinConf()));
        }
        watchdog.kill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restartServer(String serverId, String[] argv) {
        HashMap<String, Watchdog> hashMap = this._watchdogMap;
        synchronized (hashMap) {
            Watchdog server = this._watchdogMap.get(serverId);
            if (server != null) {
                server.stop();
            }
            this.startServer(argv);
        }
    }

    private void readConfig(WatchdogArgs args) throws Exception {
        Config config = new Config();
        config.setIgnoreEnvironment(true);
        Vfs.setPwd(args.getRootDirectory());
        ResinConfig resin = new ResinConfig(args);
        config.configure((Object)resin, args.getResinConf(), "com/caucho/server/resin/resin.rnc");
    }

    public static void main(String[] argv) throws Exception {
        WatchdogManager manager = new WatchdogManager(argv);
        manager.startServer(argv);
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(ResinBoot.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ResinBoot.class.getName());
        }
        return _log;
    }

    public class SrunCompatConfig {
        private String _id = "";

        public void setId(String id) {
            this._id = id;
        }

        public void setServerId(String id) {
            this._id = id;
        }

        public void addBuilderProgram(ConfigProgram program) {
        }

        @PostConstruct
        public void init() {
            if (WatchdogManager.this._isWatchdogManagerConfig) {
                return;
            }
            Watchdog server = WatchdogManager.this.findServer(this._id);
            if (server != null) {
                return;
            }
            server = new Watchdog(this._id, WatchdogManager.this._args);
            WatchdogManager.this._watchdogMap.put(this._id, server);
        }
    }

    public class ClusterCompatConfig {
        public SrunCompatConfig createSrun() {
            return new SrunCompatConfig();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class ServerCompatConfig {
        public ClusterCompatConfig createCluster() {
            return new ClusterCompatConfig();
        }

        public SrunCompatConfig createHttp() {
            return new SrunCompatConfig();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class ClusterConfig {
        private ResinConfig _resin;
        private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();

        ClusterConfig(ResinConfig resin) {
            this._resin = resin;
        }

        public void addServerDefault(ContainerProgram program) {
            this._serverDefaultList.add(program);
        }

        public void addManagement(ManagementConfig management) {
            if (WatchdogManager.this._management == null) {
                WatchdogManager.this._management = management;
            }
        }

        public WatchdogConfig createServer() {
            WatchdogConfig config = new WatchdogConfig(this._resin.getArgs());
            for (int i = 0; i < this._serverDefaultList.size(); ++i) {
                this._serverDefaultList.get(i).configure(config);
            }
            return config;
        }

        public void addServer(WatchdogConfig config) throws ConfigException {
            if (WatchdogManager.this._isWatchdogManagerConfig) {
                return;
            }
            Watchdog watchdog = (Watchdog)WatchdogManager.this._watchdogMap.get(config.getId());
            if (watchdog == null) {
                WatchdogManager.this._watchdogMap.put(config.getId(), new Watchdog(config));
            } else if (this._resin.getId().equals(config.getId())) {
                watchdog.setConfig(config);
            }
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public class WatchdogManagerConfig {
        private ResinConfig _resin;
        private ArrayList<ContainerProgram> _watchdogDefaultList = new ArrayList();

        WatchdogManagerConfig(ResinConfig resin) {
            this._resin = resin;
        }

        public void setWatchdogPort(int port) {
            if (WatchdogManager.this._args.getWatchdogPort() == 0) {
                WatchdogManager.this._args.setWatchdogPort(port);
            }
        }

        public void addWatchdogDefault(ContainerProgram program) {
            this._watchdogDefaultList.add(program);
        }

        public WatchdogConfig createWatchdog() {
            WatchdogConfig config = new WatchdogConfig(this._resin.getArgs());
            for (int i = 0; i < this._watchdogDefaultList.size(); ++i) {
                this._watchdogDefaultList.get(i).configure(config);
            }
            return config;
        }

        public void addWatchdog(WatchdogConfig config) throws ConfigException {
            Watchdog watchdog = (Watchdog)WatchdogManager.this._watchdogMap.get(config.getId());
            if (watchdog == null) {
                WatchdogManager.this._watchdogMap.put(config.getId(), new Watchdog(config));
            } else if (this._resin.getId().equals(watchdog.getId())) {
                watchdog.setConfig(config);
            }
        }
    }

    class ResinConfig {
        private WatchdogArgs _args;
        private ArrayList<ContainerProgram> _clusterDefaultList = new ArrayList();

        ResinConfig() {
            this._args = WatchdogManager.this._args;
        }

        ResinConfig(WatchdogArgs args) {
            this._args = args;
        }

        public WatchdogArgs getArgs() {
            return this._args;
        }

        public String getId() {
            if (this._args == null) {
                return "default";
            }
            return this._args.getServerId();
        }

        public void setManagement(ManagementConfig management) {
            if (WatchdogManager.this._management == null) {
                WatchdogManager.this._management = management;
            }
        }

        public void addClusterDefault(ContainerProgram program) {
            this._clusterDefaultList.add(program);
        }

        public WatchdogManagerConfig createWatchdogManager() {
            WatchdogManager.this._isWatchdogManagerConfig = true;
            return new WatchdogManagerConfig(this);
        }

        public ClusterConfig createCluster() {
            ClusterConfig cluster = new ClusterConfig(this);
            for (int i = 0; i < this._clusterDefaultList.size(); ++i) {
                this._clusterDefaultList.get(i).configure(cluster);
            }
            return cluster;
        }

        public ServerCompatConfig createServer() {
            return new ServerCompatConfig();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }
}

