/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.Boot;
import com.caucho.boot.Watchdog;
import com.caucho.boot.WatchdogArgs;
import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.log.RotateStream;
import com.caucho.server.port.Port;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchdogProcess {
    private static final L10N L = new L10N(WatchdogProcess.class);
    private static final Logger log = Logger.getLogger(WatchdogProcess.class.getName());
    private static Boot _jniBoot;
    private final String _id;
    private final Watchdog _watchdog;
    private final Lifecycle _lifecycle = new Lifecycle();
    private ServerSocket _ss;
    private Process _process;

    WatchdogProcess(String id, Watchdog watchdog) {
        this._id = id;
        this._watchdog = watchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        WriteStream jvmOut = null;
        this._ss = new ServerSocket(0, 5, InetAddress.getByName("127.0.0.1"));
        int port = this._ss.getLocalPort();
        log.info(this + " starting Resin");
        jvmOut = this.createJvmOut();
        this._process = this.createProcess(port, jvmOut);
        if (this._process != null) {
            try {
                this.runInstance(jvmOut, this._ss, this._process);
                Object var4_4 = null;
                this.destroy();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.destroy();
                throw throwable;
            }
        }
        Object var6_8 = null;
        if (jvmOut == null || this._watchdog.isSingle()) return;
        try {
            jvmOut.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                log.log(Level.INFO, e.toString(), e);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                }
                Object var6_9 = null;
                if (jvmOut == null || this._watchdog.isSingle()) return;
                try {
                    jvmOut.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (jvmOut == null || this._watchdog.isSingle()) throw throwable;
            try {
                jvmOut.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    void stop() {
        this._lifecycle.toDestroy();
    }

    void destroy() {
        if (this._process != null) {
            try {
                this._process.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                this._process.waitFor();
                this._process = null;
            }
            catch (Exception e) {
                log.log(Level.INFO, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInstance(WriteStream jvmOut, ServerSocket ss, Process process) throws IOException {
        Exception e52;
        Socket s;
        block21: {
            InputStream stdIs = null;
            OutputStream stdOs = null;
            InputStream watchdogIs = null;
            s = null;
            try {
                int stdoutTimeoutMax;
                stdIs = process.getInputStream();
                stdOs = process.getOutputStream();
                ss.setSoTimeout(60000);
                boolean isLive = true;
                int stdoutTimeout = stdoutTimeoutMax = 10;
                byte[] data = new byte[1024];
                s = this.connectToChild(ss, stdIs, jvmOut, process, data);
                if (s == null) {
                    log.warning(this + " watchdog socket timed out");
                }
                if (s != null) {
                    watchdogIs = s.getInputStream();
                }
                this.runInstance(stdIs, jvmOut, process, data);
                try {
                    if (watchdogIs != null) {
                        watchdogIs.close();
                    }
                }
                catch (Exception e2) {
                    log.log(Level.WARNING, e2.toString(), e2);
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e3) {
                    log.log(Level.WARNING, e3.toString(), e3);
                }
                try {
                    stdOs.close();
                }
                catch (Exception e4) {
                    log.log(Level.WARNING, e4.toString(), e4);
                }
                log.info(this + " stopping Resin");
                this.closeInstance(stdIs, jvmOut, process, data);
                Object var15_16 = null;
                if (watchdogIs == null) break block21;
            }
            catch (Throwable throwable) {
                Exception e52;
                Object var15_17 = null;
                if (watchdogIs != null) {
                    try {
                        watchdogIs.close();
                    }
                    catch (IOException e52) {
                        // empty catch block
                    }
                }
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e52) {
                    log.log(Level.WARNING, e52.toString(), e52);
                }
                throw throwable;
            }
            try {
                watchdogIs.close();
            }
            catch (IOException e52) {
                // empty catch block
            }
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e52) {
            log.log(Level.WARNING, e52.toString(), e52);
        }
    }

    private WriteStream createJvmOut() throws IOException {
        if (!this._watchdog.isSingle()) {
            String id = this._watchdog.getId();
            Path jvmPath = this._watchdog.getLogPath();
            try {
                Path dir = jvmPath.getParent();
                if (!dir.exists()) {
                    String groupName;
                    dir.mkdirs();
                    String userName = this._watchdog.getUserName();
                    if (userName != null) {
                        dir.changeOwner(userName);
                    }
                    if ((groupName = this._watchdog.getGroupName()) != null) {
                        dir.changeGroup(groupName);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            RotateStream rotateStream = RotateStream.create(jvmPath);
            rotateStream.getRolloverLog().setRolloverSize(new Bytes(0x4000000L));
            rotateStream.init();
            return rotateStream.getStream();
        }
        return Vfs.openWrite(System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Socket connectToChild(ServerSocket ss, InputStream stdIs, WriteStream jvmOut, Process process, byte[] data) throws IOException {
        Socket socket;
        try {
            try {
                Socket s = null;
                for (int i = 0; i < 120 && s == null; ++i) {
                    Socket socket2;
                    int len;
                    try {
                        s = ss.accept();
                    }
                    catch (SocketTimeoutException e) {
                        // empty catch block
                    }
                    while (stdIs.available() > 0 && (len = stdIs.read(data, 0, data.length)) >= 0) {
                        jvmOut.write(data, 0, len);
                        jvmOut.flush();
                    }
                    try {
                        int status = process.exitValue();
                        if (s != null) {
                            s.close();
                        }
                        socket2 = null;
                    }
                    catch (IllegalThreadStateException e) {
                        continue;
                    }
                    Object var11_16 = null;
                    ss.close();
                    return socket2;
                }
                socket = s;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                Socket socket3 = null;
                Object var11_18 = null;
                ss.close();
                return socket3;
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            ss.close();
            throw throwable;
        }
        Object var11_17 = null;
        ss.close();
        return socket;
    }

    private void closeInstance(InputStream stdIs, WriteStream jvmOut, Process process, byte[] data) {
        long endTime = Alarm.getCurrentTime() + this._watchdog.getShutdownWaitTime();
        boolean isLive = true;
        while (isLive && Alarm.getCurrentTime() < endTime) {
            try {
                while (stdIs.available() > 0) {
                    int len = stdIs.read(data, 0, data.length);
                    if (len <= 0) {
                        isLive = false;
                        break;
                    }
                    jvmOut.write(data, 0, len);
                    jvmOut.flush();
                }
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
            try {
                int status = process.exitValue();
                isLive = false;
            }
            catch (IllegalThreadStateException e) {}
        }
        try {
            stdIs.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInstance(InputStream stdIs, WriteStream jvmOut, Process process, byte[] data) throws IOException {
        int stdoutTimeoutMax;
        boolean isLive = true;
        int stdoutTimeout = stdoutTimeoutMax = 10;
        while (isLive && this._lifecycle.isActive()) {
            int len;
            while (stdIs.available() > 0 && (len = stdIs.read(data, 0, data.length)) > 0) {
                stdoutTimeout = stdoutTimeoutMax;
                jvmOut.write(data, 0, len);
                jvmOut.flush();
            }
            try {
                process.exitValue();
                isLive = false;
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            try {
                Lifecycle e = this._lifecycle;
                synchronized (e) {
                    if (stdoutTimeout-- > 0) {
                        this._lifecycle.wait(100 * (stdoutTimeoutMax - stdoutTimeout));
                    } else {
                        this._lifecycle.wait(100 * stdoutTimeoutMax);
                    }
                }
            }
            catch (Exception e) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private Process createProcess(int socketPort, WriteStream out) throws IOException {
        ArrayList<String> list;
        HashMap<String, String> env;
        Path processPwd;
        block43: {
            Boot boot;
            int i;
            Path chroot = this._watchdog.getChroot();
            processPwd = this._watchdog.getPwd();
            Path resinHome = this._watchdog.getResinHome();
            Path resinRoot = this._watchdog.getResinRoot();
            ArrayList<String> classPathList = new ArrayList<String>();
            classPathList.addAll(this._watchdog.getJvmClasspath());
            String classPath = WatchdogArgs.calculateClassPath(classPathList, resinHome);
            env = new HashMap<String, String>();
            env.putAll(System.getenv());
            env.put("CLASSPATH", classPath);
            if (this._watchdog.is64bit()) {
                this.appendEnvPath(env, "LD_LIBRARY_PATH", resinHome.lookup("libexec64").getNativePath());
                this.appendEnvPath(env, "DYLD_LIBRARY_PATH", resinHome.lookup("libexec64").getNativePath());
                this.appendEnvPath(env, "PATH", resinHome.lookup("win64").getNativePath());
            } else {
                this.appendEnvPath(env, "LD_LIBRARY_PATH", resinHome.lookup("libexec").getNativePath());
                this.appendEnvPath(env, "DYLD_LIBRARY_PATH", resinHome.lookup("libexec").getNativePath());
                this.appendEnvPath(env, "PATH", resinHome.lookup("win32").getNativePath());
            }
            list = new ArrayList<String>();
            list.add(this._watchdog.getJavaExe());
            list.add("-Djava.util.logging.manager=com.caucho.log.LogManagerImpl");
            list.add("-Djava.system.class.loader=com.caucho.loader.SystemClassLoader");
            list.add("-Djavax.management.builder.initial=com.caucho.jmx.MBeanServerBuilderImpl");
            list.add("-Djava.awt.headless=true");
            list.add("-Dresin.home=" + resinHome.getFullPath());
            if (!this._watchdog.hasXss()) {
                list.add("-Xss1m");
            }
            if (!this._watchdog.hasXmx()) {
                list.add("-Xmx256m");
            }
            if (!list.contains("-d32") && !list.contains("-d64") && this._watchdog.is64bit() && !CauchoSystem.isWindows()) {
                list.add("-d64");
            }
            for (String arg : this._watchdog.getJvmArgs()) {
                if (arg.startsWith("-Djava.class.path")) continue;
                list.add(arg);
            }
            for (String arg : this._watchdog.getArgv()) {
                if (arg.startsWith("-D") || arg.startsWith("-X")) {
                    list.add(arg);
                    continue;
                }
                if (!arg.startsWith("-J")) continue;
                list.add(arg.substring(2));
            }
            ArrayList<String> resinArgs = new ArrayList<String>();
            String[] argv = this._watchdog.getArgv();
            for (i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-conf")) {
                    ++i;
                    continue;
                }
                if (argv[i].startsWith("-Djava.class.path=")) continue;
                if (argv[i].startsWith("-J")) {
                    list.add(argv[i].substring(2));
                    continue;
                }
                if (argv[i].startsWith("-Djava.class.path")) continue;
                resinArgs.add(argv[i]);
            }
            list.add("com.caucho.server.resin.Resin");
            if (resinRoot != null) {
                list.add("--root-directory");
                list.add(resinRoot.getFullPath());
            }
            if (this._watchdog.getResinConf() != null) {
                list.add("-conf");
                list.add(this._watchdog.getResinConf().getNativePath());
            }
            list.add("-socketwait");
            list.add(String.valueOf(socketPort));
            list.addAll(resinArgs);
            if (this._watchdog.isVerbose()) {
                for (i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        out.print("  ");
                    }
                    out.print((String)list.get(i));
                    if (i + 1 < list.size()) {
                        out.println(" \\");
                        continue;
                    }
                    out.println();
                }
                for (Map.Entry<String, String> envEntry : env.entrySet()) {
                    out.println("" + envEntry.getKey() + ": " + envEntry.getValue());
                }
            }
            if ((boot = this.getJniBoot()) != null) {
                ArrayList<QServerSocket> boundSockets;
                block42: {
                    Process process;
                    boot.clearSaveOnExec();
                    boundSockets = new ArrayList<QServerSocket>();
                    try {
                        Process process2;
                        if (this._watchdog.getUserName() != null) {
                            for (Port port : this._watchdog.getPorts()) {
                                QServerSocket ss = port.bindForWatchdog();
                                boundSockets.add(ss);
                                if (!ss.setSaveOnExec()) continue;
                                list.add("-port");
                                list.add(String.valueOf(ss.getSystemFD()));
                                list.add(String.valueOf(port.getAddress()));
                                list.add(String.valueOf(port.getPort()));
                            }
                        }
                        String chrootPath = null;
                        if (chroot != null) {
                            chrootPath = chroot.getNativePath();
                        }
                        if ((process2 = boot.exec(list, env, chrootPath, processPwd.getNativePath(), this._watchdog.getUserName(), this._watchdog.getGroupName())) == null) break block42;
                        process = process2;
                        Object var19_24 = null;
                    }
                    catch (Throwable throwable) {
                        Object var19_28 = null;
                        for (int i2 = 0; i2 < boundSockets.size(); ++i2) {
                            try {
                                ((QServerSocket)boundSockets.get(i2)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    for (int i2 = 0; i2 < boundSockets.size(); ++i2) {
                        try {
                            ((QServerSocket)boundSockets.get(i2)).close();
                            continue;
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                    }
                    return process;
                }
                Object var19_25 = null;
                for (int i2 = 0; i2 < boundSockets.size(); ++i2) {
                    try {
                        ((QServerSocket)boundSockets.get(i2)).close();
                        continue;
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                {
                    break block43;
                    catch (ConfigException e) {
                        log.warning(e.getMessage());
                        Object var19_26 = null;
                        for (int i2 = 0; i2 < boundSockets.size(); ++i2) {
                            try {
                                ((QServerSocket)boundSockets.get(i2)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                        break block43;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        Object var19_27 = null;
                        for (int i2 = 0; i2 < boundSockets.size(); ++i2) {
                            try {
                                ((QServerSocket)boundSockets.get(i2)).close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        if (this._watchdog.getUserName() != null) {
            if (this._watchdog.isSingle()) {
                throw new ConfigException(L.l("<user-name> requires Resin Professional and compiled JNI started with 'start'.  Resin cannot use <user-name> when started as a foreground process."));
            }
            throw new ConfigException(L.l("<user-name> requires Resin Professional and compiled JNI."));
        }
        if (this._watchdog.getGroupName() != null) {
            if (this._watchdog.isSingle()) {
                throw new ConfigException(L.l("<group-name> requires Resin Professional and compiled JNI started with 'start'.  Resin cannot use <group-name> when started as a foreground process."));
            }
            throw new ConfigException(L.l("<group-name> requires Resin Professional and compiled JNI."));
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File(processPwd.getNativePath()));
        builder.environment().putAll(env);
        builder = builder.command(list);
        builder.redirectErrorStream(true);
        return builder.start();
    }

    private void appendEnvPath(Map<String, String> env, String prop, String value) {
        String oldValue = env.get(prop);
        if (oldValue != null && !"".equals(oldValue)) {
            value = value + File.pathSeparator + oldValue;
        }
        env.put(prop, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._watchdog + "," + this._id + "]";
    }

    Boot getJniBoot() {
        if (_jniBoot != null) {
            return _jniBoot.isValid() ? _jniBoot : null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.boot.JniBoot", false, loader);
            _jniBoot = (Boot)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.fine(e.toString());
        }
        catch (IllegalStateException e) {
            log.fine(e.toString());
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return _jniBoot != null && _jniBoot.isValid() ? _jniBoot : null;
    }
}

