/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.WatchdogAPI;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.hessian.server.HessianServlet;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class WatchdogServlet
extends HessianServlet
implements WatchdogAPI {
    private static final L10N L = new L10N(WatchdogServlet.class);
    private static final Logger log = Logger.getLogger(WatchdogServlet.class.getName());
    private WatchdogManager _watchdogManager;

    public void init() {
        this._watchdogManager = WatchdogManager.getWatchdog();
    }

    public String status(String password) throws ConfigException, IllegalStateException {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog status authentication failure");
            throw new ConfigException(L.l("watchdog start forbidden - authentication failed."));
        }
        return this._watchdogManager.status();
    }

    public void start(String password, String[] argv) throws ConfigException, IllegalStateException {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog start authentication failure");
            throw new ConfigException(L.l("watchdog start forbidden - authentication failed."));
        }
        this._watchdogManager.startServer(argv);
    }

    public void restart(String password, String serverId, String[] argv) {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog restart authentication failure");
            throw new ConfigException(L.l("watchdog restart forbidden - authentication failed"));
        }
        this._watchdogManager.restartServer(serverId, argv);
    }

    public void stop(String password, String serverId) {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog stop authentication failure");
            throw new ConfigException(L.l("watchdog stop forbidden - authentication failed"));
        }
        log.info("Watchdog stop: " + serverId);
        this._watchdogManager.stopServer(serverId);
    }

    public void kill(String password, String serverId) {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog kill authentication failure");
            throw new ConfigException(L.l("watchdog kill forbidden - authentication failed"));
        }
        log.info("Watchdog kill: " + serverId);
        this._watchdogManager.killServer(serverId);
    }

    public boolean shutdown(String password) {
        if (!this._watchdogManager.authenticate(password)) {
            log.warning("watchdog stop authentication failure");
            throw new ConfigException(L.l("watchdog shutdown forbidden - authentication failed"));
        }
        log.info("Watchdog shutdown");
        new Thread(new Shutdown()).start();
        return true;
    }

    static class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

