/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.Watchdog;
import com.caucho.boot.WatchdogProcess;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

class WatchdogTask
implements Runnable {
    private static final L10N L = new L10N(WatchdogTask.class);
    private static final Logger log = Logger.getLogger(WatchdogTask.class.getName());
    private final Watchdog _watchdog;
    private final Lifecycle _lifecycle = new Lifecycle();
    private WatchdogProcess _process;

    WatchdogTask(Watchdog watchdog) {
        this._watchdog = watchdog;
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    String getState() {
        return this._lifecycle.getStateName();
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        Thread thread = new Thread((Runnable)this, "watchdog-" + this._watchdog.getId());
        thread.setDaemon(false);
        thread.start();
    }

    public void stop() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        WatchdogProcess process = this._process;
        if (process != null) {
            process.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int i = 0;
            long retry = Long.MAX_VALUE;
            while (this._lifecycle.isActive() && (long)i++ < retry) {
                WatchdogProcess process;
                Object var7_5;
                String id = String.valueOf(i);
                this._watchdog.notifyTaskStarted();
                this._process = new WatchdogProcess(id, this._watchdog);
                try {
                    try {
                        this._process.run();
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e.toString(), e);
                        var7_5 = null;
                        process = this._process;
                        this._process = null;
                        if (process == null) continue;
                        process.destroy();
                        continue;
                    }
                    var7_5 = null;
                    process = this._process;
                    this._process = null;
                    if (process == null) continue;
                    process.destroy();
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    process = this._process;
                    this._process = null;
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
            }
            Object var10_8 = null;
            this._lifecycle.toDestroy();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this._lifecycle.toDestroy();
            this._watchdog.completeTask(this);
            throw throwable;
        }
        this._watchdog.completeTask(this);
    }

    void kill() {
        WatchdogProcess process = this._process;
        this._process = null;
        if (process != null) {
            process.destroy();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._watchdog + "]";
    }
}

