/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteCodeClassScanner {
    private static final Logger log = Logger.getLogger(ByteCodeClassScanner.class.getName());
    private static final L10N L = new L10N(ByteCodeClassScanner.class);
    private final String _className;
    private final InputStream _is;
    private final ByteCodeClassMatcher _matcher;
    private CharBuffer _cb = new CharBuffer();

    public ByteCodeClassScanner(String className, InputStream is, ByteCodeClassMatcher matcher) {
        this._className = className;
        this._is = is;
        this._matcher = matcher;
    }

    public boolean scan() {
        try {
            int magic = this.readInt();
            if (magic != -889275714) {
                throw this.error(L.l("bad magic number in class file"));
            }
            this._is.skip(2L);
            this._is.skip(2L);
            return this.parseConstantPool();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "failed scanning class " + this._className + "\n" + e.toString(), e);
            return false;
        }
    }

    public boolean parseConstantPool() throws IOException {
        int count = this.readShort();
        int i = 1;
        block13: while (i < count) {
            int code = this._is.read();
            i = code == 5 || code == 6 ? (i += 2) : ++i;
            switch (code) {
                case 7: {
                    this._is.skip(2L);
                    continue block13;
                }
                case 9: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 10: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 11: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 8: {
                    this._is.skip(2L);
                    continue block13;
                }
                case 3: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 4: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 5: {
                    this._is.skip(8L);
                    continue block13;
                }
                case 6: {
                    this._is.skip(8L);
                    continue block13;
                }
                case 12: {
                    this._is.skip(4L);
                    continue block13;
                }
                case 1: {
                    int length = this.readShort();
                    if (!this.parseUtf8ForAnnotation(this._cb, length) || !this._matcher.isMatch(this._cb)) continue block13;
                    return true;
                }
            }
            throw this.error(L.l("'{0}' is an unknown constant pool type.", (long)code));
        }
        return false;
    }

    private boolean parseUtf8ForAnnotation(CharBuffer cb, int len) throws IOException {
        InputStream is = this._is;
        int ch = is.read();
        --len;
        if (ch != 76) {
            is.skip(len);
            return false;
        }
        cb.ensureCapacity(len);
        char[] cBuf = cb.getBuffer();
        int cLen = 0;
        while (len > 0) {
            int d2;
            int d1 = is.read();
            if (d1 == 47) {
                cBuf[cLen++] = 46;
                --len;
                continue;
            }
            if (d1 < 128) {
                cBuf[cLen++] = (char)d1;
                --len;
                continue;
            }
            if (d1 < 224) {
                d2 = is.read() & 0x3F;
                cBuf[cLen++] = (char)(((d1 & 0x1F) << 6) + d2);
                len -= 2;
                continue;
            }
            if (d1 < 240) {
                d2 = is.read() & 0x3F;
                int d3 = is.read() & 0x3F;
                cBuf[cLen++] = (char)(((d1 & 0xF) << 12) + (d2 << 6) + d3);
                len -= 3;
                continue;
            }
            throw new IllegalStateException();
        }
        if (cLen > 0 && cBuf[cLen - 1] == ';') {
            cb.setLength(cLen - 1);
            return true;
        }
        return false;
    }

    private int readInt() throws IOException {
        return this._is.read() << 24 | this._is.read() << 16 | this._is.read() << 8 | this._is.read();
    }

    private int readShort() throws IOException {
        int c1 = this._is.read();
        int c2 = this._is.read();
        return c1 << 8 | c2;
    }

    private IllegalStateException error(String message) {
        return new IllegalStateException(this._className + ": " + message);
    }
}

