/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.util.ByteBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.OutputStream;

public class ByteCodeWriter {
    private static final L10N L = new L10N(ByteCodeWriter.class);
    private OutputStream _os;
    private JavaClass _javaClass;
    private ByteBuffer _bb = new ByteBuffer();

    ByteCodeWriter(OutputStream os, JavaClass javaClass) {
        this._os = os;
        this._javaClass = javaClass;
    }

    public JavaClass getJavaClass() {
        return this._javaClass;
    }

    public void writeClass(String className) throws IOException {
        ConstantPool pool = this._javaClass.getConstantPool();
        ClassConstant classConst = pool.getClass(className);
        if (classConst != null) {
            this.writeShort(classConst.getIndex());
        } else {
            this.writeShort(0);
        }
    }

    public void writeUTF8Const(String value) throws IOException {
        ConstantPool pool = this._javaClass.getConstantPool();
        Utf8Constant entry = pool.getUTF8(value);
        if (entry == null) {
            throw new NullPointerException(L.l("utf8 constant {0} does not exist", (Object)value));
        }
        this.writeShort(entry.getIndex());
    }

    public void write(int v) throws IOException {
        this._os.write(v);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._os.write(buffer, offset, length);
    }

    public void writeShort(int v) throws IOException {
        this._os.write(v >> 8);
        this._os.write(v);
    }

    public void writeInt(int v) throws IOException {
        this._os.write(v >> 24);
        this._os.write(v >> 16);
        this._os.write(v >> 8);
        this._os.write(v);
    }

    public void writeLong(long v) throws IOException {
        this._os.write((int)(v >> 56));
        this._os.write((int)(v >> 48));
        this._os.write((int)(v >> 40));
        this._os.write((int)(v >> 32));
        this._os.write((int)(v >> 24));
        this._os.write((int)(v >> 16));
        this._os.write((int)(v >> 8));
        this._os.write((int)v);
    }

    public void writeFloat(float v) throws IOException {
        int bits = Float.floatToIntBits(v);
        this._os.write(bits >> 24);
        this._os.write(bits >> 16);
        this._os.write(bits >> 8);
        this._os.write(bits);
    }

    public void writeDouble(double v) throws IOException {
        long bits = Double.doubleToLongBits(v);
        this._os.write((int)(bits >> 56));
        this._os.write((int)(bits >> 48));
        this._os.write((int)(bits >> 40));
        this._os.write((int)(bits >> 32));
        this._os.write((int)(bits >> 24));
        this._os.write((int)(bits >> 16));
        this._os.write((int)(bits >> 8));
        this._os.write((int)bits);
    }

    public void writeUTF8(String value) throws IOException {
        this.writeUTF8(this._bb, value);
        this.writeShort(this._bb.size());
        this._os.write(this._bb.getBuffer(), 0, this._bb.size());
    }

    public void writeIntUTF8(String value) throws IOException {
        this.writeUTF8(this._bb, value);
        this.writeInt(this._bb.size());
        this._os.write(this._bb.getBuffer(), 0, this._bb.size());
    }

    public void writeUTF8(ByteBuffer bb, String value) {
        bb.clear();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch > '\u0000' && ch < '\u0080') {
                bb.append((int)ch);
                continue;
            }
            if (ch < '\u0800') {
                bb.append(192 + (ch >> 6));
                bb.append(128 + (ch & 0x3F));
                continue;
            }
            bb.append(224 + (ch >> 12));
            bb.append(128 + (ch >> 6 & 0x3F));
            bb.append(128 + (ch & 0x3F));
        }
    }
}

