/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeVisitor {
    private static final Logger log = Log.open(CodeVisitor.class);
    private static final L10N L = new L10N(CodeVisitor.class);
    private JavaClass _javaClass;
    protected CodeAttribute _codeAttr;
    private byte[] _code;
    protected int _offset;
    public static final int NOP = 0;
    public static final int ACONST_NULL = 1;
    public static final int ICONST_M1 = 2;
    public static final int ICONST_0 = 3;
    public static final int ICONST_1 = 4;
    public static final int ICONST_2 = 5;
    public static final int ICONST_3 = 6;
    public static final int ICONST_4 = 7;
    public static final int ICONST_5 = 8;
    public static final int LCONST_0 = 9;
    public static final int LCONST_1 = 10;
    public static final int FCONST_0 = 11;
    public static final int FCONST_1 = 12;
    public static final int FCONST_2 = 13;
    public static final int DCONST_0 = 14;
    public static final int DCONST_1 = 15;
    public static final int BIPUSH = 16;
    public static final int SIPUSH = 17;
    public static final int LDC = 18;
    public static final int LDC_W = 19;
    public static final int LDC2_W = 20;
    public static final int ILOAD = 21;
    public static final int LLOAD = 22;
    public static final int FLOAD = 23;
    public static final int DLOAD = 24;
    public static final int ALOAD = 25;
    public static final int ILOAD_0 = 26;
    public static final int ILOAD_1 = 27;
    public static final int ILOAD_2 = 28;
    public static final int ILOAD_3 = 29;
    public static final int LLOAD_0 = 30;
    public static final int LLOAD_1 = 31;
    public static final int LLOAD_2 = 32;
    public static final int LLOAD_3 = 33;
    public static final int FLOAD_0 = 34;
    public static final int FLOAD_1 = 35;
    public static final int FLOAD_2 = 36;
    public static final int FLOAD_3 = 37;
    public static final int DLOAD_0 = 38;
    public static final int DLOAD_1 = 39;
    public static final int DLOAD_2 = 40;
    public static final int DLOAD_3 = 41;
    public static final int ALOAD_0 = 42;
    public static final int ALOAD_1 = 43;
    public static final int ALOAD_2 = 44;
    public static final int ALOAD_3 = 45;
    public static final int IALOAD = 46;
    public static final int LALOAD = 47;
    public static final int FALOAD = 48;
    public static final int DALOAD = 49;
    public static final int AALOAD = 50;
    public static final int BALOAD = 51;
    public static final int CALOAD = 52;
    public static final int SALOAD = 53;
    public static final int ISTORE = 54;
    public static final int LSTORE = 55;
    public static final int FSTORE = 56;
    public static final int DSTORE = 57;
    public static final int ASTORE = 58;
    public static final int ISTORE_0 = 59;
    public static final int ISTORE_1 = 60;
    public static final int ISTORE_2 = 61;
    public static final int ISTORE_3 = 62;
    public static final int LSTORE_0 = 63;
    public static final int LSTORE_1 = 64;
    public static final int LSTORE_2 = 65;
    public static final int LSTORE_3 = 66;
    public static final int FSTORE_0 = 67;
    public static final int FSTORE_1 = 68;
    public static final int FSTORE_2 = 69;
    public static final int FSTORE_3 = 70;
    public static final int DSTORE_0 = 71;
    public static final int DSTORE_1 = 72;
    public static final int DSTORE_2 = 73;
    public static final int DSTORE_3 = 74;
    public static final int ASTORE_0 = 75;
    public static final int ASTORE_1 = 76;
    public static final int ASTORE_2 = 77;
    public static final int ASTORE_3 = 78;
    public static final int IASTORE = 79;
    public static final int LASTORE = 80;
    public static final int FASTORE = 81;
    public static final int DASTORE = 82;
    public static final int AASTORE = 83;
    public static final int BASTORE = 84;
    public static final int CASTORE = 85;
    public static final int SASTORE = 86;
    public static final int POP = 87;
    public static final int POP2 = 88;
    public static final int DUP = 89;
    public static final int DUP_X1 = 90;
    public static final int DUP_X2 = 91;
    public static final int DUP2 = 92;
    public static final int DUP2_X1 = 93;
    public static final int DUP2_X2 = 94;
    public static final int SWAP = 95;
    public static final int IADD = 96;
    public static final int LADD = 97;
    public static final int FADD = 98;
    public static final int DADD = 99;
    public static final int ISUB = 100;
    public static final int LSUB = 101;
    public static final int FSUB = 102;
    public static final int DSUB = 103;
    public static final int IMUL = 104;
    public static final int LMUL = 105;
    public static final int FMUL = 106;
    public static final int DMUL = 107;
    public static final int IDIV = 108;
    public static final int LDIV = 109;
    public static final int FDIV = 110;
    public static final int DDIV = 111;
    public static final int IREM = 112;
    public static final int LREM = 113;
    public static final int FREM = 114;
    public static final int DREM = 115;
    public static final int INEG = 116;
    public static final int LNEG = 117;
    public static final int FNEG = 118;
    public static final int DNEG = 119;
    public static final int ISHL = 120;
    public static final int LSHL = 121;
    public static final int ISHR = 122;
    public static final int LSHR = 123;
    public static final int IUSHR = 124;
    public static final int LUSHR = 125;
    public static final int IAND = 126;
    public static final int LAND = 127;
    public static final int IOR = 128;
    public static final int LOR = 129;
    public static final int IXOR = 130;
    public static final int LXOR = 131;
    public static final int IINC = 132;
    public static final int I2L = 133;
    public static final int I2F = 134;
    public static final int I2D = 135;
    public static final int L2I = 136;
    public static final int L2F = 137;
    public static final int L2D = 138;
    public static final int F2I = 139;
    public static final int F2L = 140;
    public static final int F2D = 141;
    public static final int D2I = 142;
    public static final int D2L = 143;
    public static final int D2F = 144;
    public static final int I2B = 145;
    public static final int I2C = 146;
    public static final int I2S = 147;
    public static final int LCMP = 148;
    public static final int FCMPL = 149;
    public static final int FCMPG = 150;
    public static final int DCMPL = 151;
    public static final int DCMPG = 152;
    public static final int IFEQ = 153;
    public static final int IFNE = 154;
    public static final int IFLT = 155;
    public static final int IFGE = 156;
    public static final int IFGT = 157;
    public static final int IFLE = 158;
    public static final int IF_ICMPEQ = 159;
    public static final int IF_ICMPNE = 160;
    public static final int IF_ICMPLT = 161;
    public static final int IF_ICMPGE = 162;
    public static final int IF_ICMPGT = 163;
    public static final int IF_ICMPLE = 164;
    public static final int IF_ACMPEQ = 165;
    public static final int IF_ACMPNE = 166;
    public static final int GOTO = 167;
    public static final int JSR = 168;
    public static final int RET = 169;
    public static final int TABLESWITCH = 170;
    public static final int LOOKUPSWITCH = 171;
    public static final int IRETURN = 172;
    public static final int LRETURN = 173;
    public static final int FRETURN = 174;
    public static final int DRETURN = 175;
    public static final int ARETURN = 176;
    public static final int RETURN = 177;
    public static final int GETSTATIC = 178;
    public static final int PUTSTATIC = 179;
    public static final int GETFIELD = 180;
    public static final int PUTFIELD = 181;
    public static final int INVOKEVIRTUAL = 182;
    public static final int INVOKESPECIAL = 183;
    public static final int INVOKESTATIC = 184;
    public static final int INVOKEINTERFACE = 185;
    public static final int RESERVED_0 = 186;
    public static final int NEW = 187;
    public static final int NEWARRAY = 188;
    public static final int ANEWARRAY = 189;
    public static final int ARRAYLENGTH = 190;
    public static final int ATHROW = 191;
    public static final int CHECKCAST = 192;
    public static final int INSTANCEOF = 193;
    public static final int MONITORENTER = 194;
    public static final int MONITOREXIT = 195;
    public static final int WIDE = 196;
    public static final int MULTIANEWARRAY = 197;
    public static final int IFNULL = 198;
    public static final int IFNONNULL = 199;
    public static final int GOTO_W = 200;
    public static final int JSR_W = 201;
    private static final int[] OP_LEN = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 99, 99, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 4, -1, 2, 1, 2, 0, 0, 2, 2, 0, 0, 99, 3, 2, 2, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public CodeVisitor() {
    }

    public CodeVisitor(JavaClass javaClass, CodeAttribute codeAttr) {
        this.init(javaClass, codeAttr);
    }

    public void init(JavaClass javaClass, CodeAttribute codeAttr) {
        this._javaClass = javaClass;
        this._codeAttr = codeAttr;
        this._code = codeAttr.getCode();
        this._offset = 0;
    }

    public JavaClass getJavaClass() {
        return this._javaClass;
    }

    public CodeAttribute getCodeAttribute() {
        return this._codeAttr;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public byte[] getCode() {
        return this._code;
    }

    public ArrayList<CodeAttribute.ExceptionItem> getExceptions() {
        return this._codeAttr.getExceptions();
    }

    public int getOpcode() {
        int op = this.getCode()[this._offset] & 0xFF;
        if (op == 196) {
            return this.getCode()[this._offset + 1] & 0xFF;
        }
        return op;
    }

    public boolean next() {
        this._offset = this.nextOffset();
        return this._offset >= 0;
    }

    protected int nextOffset() {
        int opcode = this.getCode()[this._offset] & 0xFF;
        int length = OP_LEN[opcode];
        switch (opcode) {
            case 167: 
            case 169: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: 
            case 200: {
                return -1;
            }
            case 170: {
                int arg = this._offset + 1;
                arg += (4 - arg % 4) % 4;
                int low = this.getInt(arg + 4);
                int high = this.getInt(arg + 8);
                return arg + 12 + (high - low + 1) * 4;
            }
            case 171: {
                return -1;
            }
            case 196: {
                int op2 = this.getCode()[this._offset + 1] & 0xFF;
                if (op2 == 132) {
                    length = 5;
                    break;
                }
                length = 3;
                break;
            }
        }
        if (length < 0 || length > 16) {
            throw new UnsupportedOperationException(L.l("{0}: can't handle opcode {1}", (Object)("" + this._offset), (Object)("" + this.getOpcode())));
        }
        return this._offset + length + 1;
    }

    public boolean isBranch() {
        switch (this.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                return true;
            }
        }
        return false;
    }

    public int getBranchTarget() {
        switch (this.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return this._offset + this.getShortArg();
            }
            case 200: 
            case 201: {
                return this._offset + this.getIntArg();
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSwitch() {
        switch (this.getOpcode()) {
            case 170: 
            case 171: {
                return true;
            }
        }
        return false;
    }

    public int[] getSwitchTargets() {
        switch (this.getOpcode()) {
            case 170: {
                int arg = this._offset + 1;
                arg += (4 - arg % 4) % 4;
                int low = this.getInt(arg + 4);
                int high = this.getInt(arg + 8);
                int[] targets = new int[high - low + 2];
                targets[0] = this.getInt(arg) + this._offset;
                for (int i = 0; i <= high - low; ++i) {
                    targets[i + 1] = this.getInt(arg + 12 + i * 4) + this._offset;
                }
                return targets;
            }
            case 171: {
                int arg = this._offset + 1;
                arg += (4 - arg % 4) % 4;
                int n = this.getInt(arg + 4);
                int[] targets = new int[n + 1];
                targets[0] = this.getInt(arg) + this._offset;
                for (int i = 0; i < n; ++i) {
                    int off = arg + 8 + i * 8 + 4;
                    targets[i + 1] = this.getInt(off) + this._offset;
                }
                return targets;
            }
        }
        throw new UnsupportedOperationException("getSwitchTargets");
    }

    public ConstantPoolEntry getConstantArg() {
        switch (this.getOpcode()) {
            case 18: {
                return this._javaClass.getConstantPool().getEntry(this.getByteArg());
            }
            case 19: {
                return this._javaClass.getConstantPool().getEntry(this.getShortArg());
            }
        }
        throw new UnsupportedOperationException();
    }

    public int getByteArg() {
        return this.getCode()[this._offset + 1];
    }

    public int getByteArg(int offset) {
        return this.getByte(this._offset + offset);
    }

    public void setByteArg(int offset, int value) {
        this.getCode()[this._offset + offset + 0] = (byte)value;
    }

    public int getShortArg() {
        return this.getShort(this._offset + 1);
    }

    public int getShortArg(int offset) {
        return this.getShort(this._offset + offset);
    }

    public void setShortArg(int offset, int value) {
        this.setShort(this._offset + offset, value);
    }

    public void setShort(int offset, int value) {
        byte[] code = this.getCode();
        code[offset + 0] = (byte)(value >> 8);
        code[offset + 1] = (byte)value;
    }

    public int getIntArg() {
        return this.getInt(this._offset + 1);
    }

    public void setInt(int offset, int value) {
        byte[] code = this.getCode();
        code[offset + 0] = (byte)(value >> 24);
        code[offset + 1] = (byte)(value >> 16);
        code[offset + 2] = (byte)(value >> 8);
        code[offset + 3] = (byte)value;
    }

    public int getByte(int offset) {
        return this.getCode()[offset + 0] & 0xFF;
    }

    public int getShort(int offset) {
        int b0 = this.getCode()[offset + 0] & 0xFF;
        int b1 = this.getCode()[offset + 1] & 0xFF;
        return (short)((b0 << 8) + b1);
    }

    public int getInt(int offset) {
        byte[] code = this.getCode();
        int b0 = code[offset + 0] & 0xFF;
        int b1 = code[offset + 1] & 0xFF;
        int b2 = code[offset + 2] & 0xFF;
        int b3 = code[offset + 3] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    public void analyze(Analyzer analyzer) throws Exception {
        this.analyze(analyzer, true);
    }

    public void analyze(Analyzer analyzer, boolean allowFlow) throws Exception {
        this.analyzeImpl(analyzer, allowFlow, new IntArray(), new IntArray());
    }

    protected void analyzeImpl(Analyzer analyzer, boolean allowFlow, IntArray pendingTargets, IntArray completedTargets) throws Exception {
        this.setOffset(0);
        pendingTargets.add(0);
        ArrayList<CodeAttribute.ExceptionItem> exns = this.getExceptions();
        for (int i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            pendingTargets.add(exn.getHandler());
        }
        this.analyze(analyzer, allowFlow, pendingTargets, completedTargets);
    }

    private void analyze(Analyzer analyzer, boolean allowFlow, IntArray pendingTargets, IntArray completedTargets) throws Exception {
        block0: while (pendingTargets.size() > 0) {
            int pc = pendingTargets.pop();
            if (allowFlow) {
                if (completedTargets.contains(pc)) continue;
                completedTargets.add(pc);
            }
            this.setOffset(pc);
            do {
                if ((pc = this.getOffset()) < 0) {
                    throw new IllegalStateException();
                }
                if (!allowFlow) {
                    if (completedTargets.contains(pc)) continue block0;
                    completedTargets.add(pc);
                }
                if (this.isBranch()) {
                    int targetPC = this.getBranchTarget();
                    if (!pendingTargets.contains(targetPC)) {
                        pendingTargets.add(targetPC);
                    }
                } else if (this.isSwitch()) {
                    int[] switchTargets = this.getSwitchTargets();
                    for (int i = 0; i < switchTargets.length; ++i) {
                        if (pendingTargets.contains(switchTargets[i])) continue;
                        pendingTargets.add(switchTargets[i]);
                    }
                }
                analyzer.analyze(this);
            } while (this.next());
        }
    }
}

