/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ClassConstant;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.Utf8Constant;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;

public class CodeWriterAttribute
extends CodeAttribute {
    private static final Logger log = Logger.getLogger(CodeAttribute.class.getName());
    private int _stack;
    private ByteArrayOutputStream _bos;

    public CodeWriterAttribute(JavaClass jClass) {
        this.setJavaClass(jClass);
        this.addUTF8("Code");
        this._bos = new ByteArrayOutputStream();
    }

    public void cast(String className) {
        int index = this.addClass(className);
        this.write(192);
        this.write(index >> 8);
        this.write(index);
    }

    public void getField(String className, String fieldName, String sig) {
        int index = this.addFieldRef(className, fieldName, sig);
        this.write(180);
        this.write(index >> 8);
        this.write(index);
    }

    public void putField(String className, String fieldName, String sig) {
        int index = this.addFieldRef(className, fieldName, sig);
        this.write(181);
        this.write(index >> 8);
        this.write(index);
    }

    public void getStatic(String className, String fieldName, String sig) {
        int index = this.addFieldRef(className, fieldName, sig);
        this.write(178);
        this.write(index >> 8);
        this.write(index);
    }

    public void putStatic(String className, String fieldName, String sig) {
        int index = this.addFieldRef(className, fieldName, sig);
        this.write(179);
        this.write(index >> 8);
        this.write(index);
    }

    public void getArrayObject() {
        this.write(50);
    }

    public void setArrayObject() {
        this.write(83);
    }

    public void pushObjectVar(int index) {
        ++this._stack;
        if (index <= 3) {
            this.write(42 + index);
        } else {
            this.write(25);
            this.write(index >> 8);
            this.write(index);
        }
    }

    public void pushIntVar(int index) {
        ++this._stack;
        if (index <= 3) {
            this.write(26 + index);
        } else {
            this.write(21);
            this.write(index >> 8);
            this.write(index);
        }
    }

    public void pushLongVar(int index) {
        this._stack += 2;
        if (index <= 3) {
            this.write(30 + index);
        } else {
            this.write(22);
            this.write(index >> 8);
            this.write(index);
        }
    }

    public void pushFloatVar(int index) {
        ++this._stack;
        if (index <= 3) {
            this.write(34 + index);
        } else {
            this.write(23);
            this.write(index >> 8);
            this.write(index);
        }
    }

    public void pushDoubleVar(int index) {
        this._stack += 2;
        if (index <= 3) {
            this.write(38 + index);
        } else {
            this.write(24);
            this.write(index >> 8);
            this.write(index);
        }
    }

    public void pushNull() {
        ++this._stack;
        this.write(1);
    }

    public void pushInt(int value) {
        ++this._stack;
        this.write(17);
        this.write(value >> 8);
        this.write(value);
    }

    public void invoke(String className, String methodName, String signature, int argStack, int returnStack) {
        this._stack += returnStack - argStack;
        int index = this.addMethodRef(className, methodName, signature);
        this.write(182);
        this.write(index >> 8);
        this.write(index);
    }

    public void newInstance(String className) {
        ++this._stack;
        int index = this.addClass(className);
        this.write(187);
        this.write(index >> 8);
        this.write(index);
    }

    public void newObjectArray(String className) {
        ++this._stack;
        int index = this.addClass(className);
        this.write(189);
        this.write(index >> 8);
        this.write(index);
    }

    public void dup() {
        ++this._stack;
        this.write(89);
    }

    public void invokespecial(String className, String methodName, String signature, int argStack, int returnStack) {
        this._stack += returnStack - argStack;
        int index = this.addMethodRef(className, methodName, signature);
        this.write(183);
        this.write(index >> 8);
        this.write(index);
    }

    public void addReturn() {
        this.write(177);
    }

    public void addIntReturn() {
        this.write(172);
    }

    public void addLongReturn() {
        this.write(173);
    }

    public void addFloatReturn() {
        this.write(174);
    }

    public void addDoubleReturn() {
        this.write(175);
    }

    public void addObjectReturn() {
        this.write(176);
    }

    public int addFieldRef(String className, String fieldName, String sig) {
        FieldRefConstant ref = this.getConstantPool().addFieldRef(className, fieldName, sig);
        return ref.getIndex();
    }

    public int addMethodRef(String className, String methodName, String sig) {
        MethodRefConstant ref = this.getConstantPool().addMethodRef(className, methodName, sig);
        return ref.getIndex();
    }

    public int addUTF8(String code) {
        Utf8Constant value = this.getConstantPool().addUTF8(code);
        return value.getIndex();
    }

    public int addClass(String className) {
        ClassConstant value = this.getConstantPool().addClass(className);
        return value.getIndex();
    }

    public ConstantPool getConstantPool() {
        return this.getJavaClass().getConstantPool();
    }

    private void write(int v) {
        this._bos.write(v);
    }

    public void close() {
        if (this._bos != null) {
            this.setCode(this._bos.toByteArray());
            this._bos = null;
        }
    }
}

