/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import java.io.IOException;
import java.util.logging.Logger;

public class DoubleConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(DoubleConstant.class);
    private double _value;

    DoubleConstant(ConstantPool pool, int index, double value) {
        super(pool, index);
        this._value = value;
    }

    public double getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(6);
        out.writeDouble(this._value);
    }

    public int export(ConstantPool target) {
        return target.addDouble(this._value).getIndex();
    }

    public String toString() {
        return "DoubleConstant[" + this._value + "]";
    }
}

