/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import java.io.IOException;
import java.util.logging.Logger;

public class IntegerConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(IntegerConstant.class);
    private int _value;

    IntegerConstant(ConstantPool pool, int index, int value) {
        super(pool, index);
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(3);
        out.writeInt(this._value);
    }

    public int export(ConstantPool target) {
        return target.addInteger(this._value).getIndex();
    }

    public String toString() {
        return "IntegerConstant[" + this._value + "]";
    }
}

