/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import com.caucho.vfs.PersistentDependency;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JClassDependency
implements PersistentDependency {
    private static final Logger log = Log.open(JClassDependency.class);
    private final String _className;
    private boolean _checkFields = true;
    private boolean _checkStatic = true;
    private boolean _checkProtected = true;
    private boolean _checkPrivate = true;
    private boolean _isDigestModified;

    public JClassDependency(JClass cl) {
        this._className = cl.getName();
    }

    public JClassDependency(JClass cl, String digest) {
        this._className = cl.getName();
        String newDigest = this.getDigest();
        if (!newDigest.equals(digest)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._className + " digest is modified.");
            }
            this._isDigestModified = true;
        }
    }

    public JClassDependency(String className, String digest) {
        this._className = className;
        String newDigest = this.getDigest();
        if (!newDigest.equals(digest)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._className + " digest is modified.");
            }
            this._isDigestModified = true;
        }
    }

    public boolean isModified() {
        return this._isDigestModified;
    }

    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._className + " is modified");
            return true;
        }
        return false;
    }

    public String getDigest() {
        try {
            if (this._className == null || "".equals(this._className)) {
                return "";
            }
            DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
            ClassLoader tmpLoader = loader.getNewTempClassLoader();
            Class<?> cl = Class.forName(this._className, false, tmpLoader);
            if (cl == null) {
                return "";
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            JClassDependency.addDigest(digest, cl.getName());
            JClassDependency.addDigest(digest, cl.getModifiers());
            Class<?> superClass = cl.getSuperclass();
            if (superClass != null) {
                JClassDependency.addDigest(digest, superClass.getName());
            }
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                JClassDependency.addDigest(digest, interfaces[i].getName());
            }
            Field[] fields = cl.getDeclaredFields();
            Arrays.sort(fields, new FieldComparator());
            if (this._checkFields) {
                for (Field field : fields) {
                    if (Modifier.isPrivate(field.getModifiers()) && !this._checkPrivate || Modifier.isProtected(field.getModifiers()) && !this._checkProtected) continue;
                    JClassDependency.addDigest(digest, field.getName());
                    JClassDependency.addDigest(digest, field.getModifiers());
                    JClassDependency.addDigest(digest, field.getType().getName());
                    JClassDependency.addDigest(digest, field.getAnnotations());
                }
            }
            Method[] methods = cl.getDeclaredMethods();
            Arrays.sort(methods, new MethodComparator());
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (Modifier.isPrivate(method.getModifiers()) && !this._checkPrivate || Modifier.isProtected(method.getModifiers()) && !this._checkProtected || Modifier.isStatic(method.getModifiers()) && !this._checkStatic) continue;
                JClassDependency.addDigest(digest, method.getName());
                JClassDependency.addDigest(digest, method.getModifiers());
                JClassDependency.addDigest(digest, method.getName());
                Class<?>[] param = method.getParameterTypes();
                for (int j = 0; j < param.length; ++j) {
                    JClassDependency.addDigest(digest, param[j].getName());
                }
                JClassDependency.addDigest(digest, method.getReturnType().getName());
                Class<?>[] exn = method.getExceptionTypes();
                for (int j = 0; j < exn.length; ++j) {
                    JClassDependency.addDigest(digest, exn[j].getName());
                }
                JClassDependency.addDigest(digest, method.getAnnotations());
            }
            byte[] digestBytes = new byte[256];
            int len = digest.digest(digestBytes, 0, digestBytes.length);
            return this.digestToBase64(digestBytes, len);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return "";
        }
    }

    public String getJavaCreateString() {
        return "new com.caucho.bytecode.JClassDependency(\"" + this._className + "\", \"" + this.getDigest() + "\")";
    }

    private static void addDigest(MessageDigest digest, Annotation[] annList) {
        if (annList == null) {
            return;
        }
        for (Annotation ann : annList) {
            JClassDependency.addDigest(digest, ann);
        }
    }

    private static void addDigest(MessageDigest digest, Annotation ann) {
        JClassDependency.addDigest(digest, ann.annotationType().getName());
    }

    private static void addDigest(MessageDigest digest, int v) {
        digest.update((byte)(v >> 24));
        digest.update((byte)(v >> 16));
        digest.update((byte)(v >> 8));
        digest.update((byte)v);
    }

    private static void addDigest(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                digest.update((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                digest.update((byte)(192 + (ch >> 6)));
                digest.update((byte)(128 + (ch & 0x3F)));
                continue;
            }
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    private String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode((CharBuffer)cb, (byte[])digest, (int)0, (int)len);
        return cb.close();
    }

    public boolean isEqual(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JClassDependency)) {
            return false;
        }
        JClassDependency depend = (JClassDependency)o;
        return this._className.equals(depend._className);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodComparator
    implements Comparator<Method> {
        MethodComparator() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?>[] paramB;
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Class<?>[] paramA = a.getParameterTypes();
            if (paramA.length < (paramB = b.getParameterTypes()).length) {
                return -1;
            }
            if (paramB.length < paramA.length) {
                return 1;
            }
            for (int i = 0; i < paramA.length; ++i) {
                cmp = paramA[i].getName().compareTo(paramB[i].getName());
                if (cmp == 0) continue;
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldComparator
    implements Comparator<Field> {
        FieldComparator() {
        }

        @Override
        public int compare(Field a, Field b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getType().getName().compareTo(b.getType().getName());
        }
    }
}

