/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JAnnotation;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JavaAnnotation;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.OpaqueAttribute;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends JClass {
    private static final Logger log = Logger.getLogger(JavaClass.class.getName());
    public static final int MAGIC = -889275714;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    private JavaClassLoader _loader;
    private URL _url;
    private int _major;
    private int _minor;
    private ConstantPool _constantPool = new ConstantPool();
    private int _accessFlags;
    private String _thisClass;
    private String _superClass;
    private ArrayList<String> _interfaces = new ArrayList();
    private ArrayList<JavaField> _fields = new ArrayList();
    private ArrayList<JavaMethod> _methods = new ArrayList();
    private ArrayList<Attribute> _attributes = new ArrayList();
    private JavaAnnotation[] _annotations;
    private boolean _isWrite;

    public JavaClass(JavaClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this._loader = loader;
    }

    public JavaClassLoader getClassLoader() {
        return this._loader;
    }

    public void setWrite(boolean isWrite) {
        this._isWrite = isWrite;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public void setMajor(int major) {
        this._major = major;
    }

    public int getMajor() {
        return this._major;
    }

    public void setMinor(int minor) {
        this._minor = minor;
    }

    public int getMinor() {
        return this._minor;
    }

    public ConstantPool getConstantPool() {
        return this._constantPool;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        this.lazyLoad();
        return this._accessFlags;
    }

    public void setThisClass(String className) {
        this._thisClass = className;
        if (this._isWrite) {
            this.getConstantPool().addClass(className);
        }
    }

    public String getThisClass() {
        return this._thisClass;
    }

    public void setSuperClass(String className) {
        this._superClass = className;
        this.getConstantPool().addClass(className);
    }

    public String getSuperClassName() {
        this.lazyLoad();
        return this._superClass;
    }

    @Override
    public JClass getSuperClass() {
        this.lazyLoad();
        if (this._superClass == null) {
            return null;
        }
        return this.getClassLoader().forName(this._superClass.replace('/', '.'));
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getAccessFlags());
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getAccessFlags());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getAccessFlags());
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public void addInterface(String className) {
        this._interfaces.add(className);
        if (this._isWrite) {
            this.getConstantPool().addClass(className);
        }
    }

    public ArrayList<String> getInterfaceNames() {
        return this._interfaces;
    }

    @Override
    public JClass[] getInterfaces() {
        this.lazyLoad();
        JClass[] interfaces = new JClass[this._interfaces.size()];
        for (int i = 0; i < this._interfaces.size(); ++i) {
            String name = this._interfaces.get(i);
            name = name.replace('/', '.');
            interfaces[i] = this.getClassLoader().forName(name);
        }
        return interfaces;
    }

    public void addField(JavaField field) {
        this._fields.add(field);
    }

    public JavaField createField(String name, String descriptor) {
        if (!this._isWrite) {
            throw new IllegalStateException("create field requires write");
        }
        JavaField jField = new JavaField();
        jField.setWrite(true);
        jField.setJavaClass(this);
        jField.setName(name);
        jField.setDescriptor(descriptor);
        this._fields.add(jField);
        return jField;
    }

    public ArrayList<JavaField> getFieldList() {
        this.lazyLoad();
        return this._fields;
    }

    public JavaField getField(String name) {
        ArrayList<JavaField> fieldList = this.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            JavaField field = fieldList.get(i);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public void addMethod(JavaMethod method) {
        this._methods.add(method);
    }

    public JavaMethod createMethod(String name, String descriptor) {
        if (!this._isWrite) {
            throw new IllegalStateException("create method requires write");
        }
        JavaMethod jMethod = new JavaMethod();
        jMethod.setWrite(true);
        jMethod.setJavaClass(this);
        jMethod.setName(name);
        jMethod.setDescriptor(descriptor);
        this._methods.add(jMethod);
        return jMethod;
    }

    public ArrayList<JavaMethod> getMethodList() {
        this.lazyLoad();
        return this._methods;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isInterface() {
        this.lazyLoad();
        return Modifier.isInterface(this._accessFlags);
    }

    public JavaMethod getMethod(String name) {
        ArrayList<JavaMethod> methodList = this.getMethodList();
        for (int i = 0; i < methodList.size(); ++i) {
            JavaMethod method = methodList.get(i);
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public JavaMethod findMethod(String name, String descriptor) {
        ArrayList<JavaMethod> methodList = this.getMethodList();
        for (int i = 0; i < methodList.size(); ++i) {
            JavaMethod method = methodList.get(i);
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
        attr.addConstants(this);
    }

    public ArrayList<Attribute> getAttributeList() {
        this.lazyLoad();
        return this._attributes;
    }

    public Attribute getAttribute(String name) {
        ArrayList<Attribute> attributeList = this.getAttributeList();
        for (int i = attributeList.size() - 1; i >= 0; --i) {
            Attribute attr = attributeList.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getThisClass().replace('/', '.');
    }

    @Override
    public boolean isAssignableFrom(JClass cl) {
        if (this.getName().equals(cl.getName())) {
            return true;
        }
        JClass[] ifc = cl.getInterfaces();
        for (int i = 0; i < ifc.length; ++i) {
            if (!this.isAssignableFrom(ifc[i])) continue;
            return true;
        }
        if (cl.getSuperClass() != null) {
            return this.isAssignableFrom(cl.getSuperClass());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(Class cl) {
        if (this.getName().equals(cl.getName())) {
            return true;
        }
        Class<?>[] ifc = cl.getInterfaces();
        for (int i = 0; i < ifc.length; ++i) {
            if (!this.isAssignableFrom(ifc[i])) continue;
            return true;
        }
        if (cl.getSuperclass() != null) {
            return this.isAssignableFrom(cl.getSuperclass());
        }
        return false;
    }

    @Override
    public boolean isAssignableTo(Class cl) {
        if (this.getName().equals(cl.getName())) {
            return true;
        }
        JClass[] ifc = this.getInterfaces();
        for (int i = 0; i < ifc.length; ++i) {
            if (!ifc[i].isAssignableTo(cl)) continue;
            return true;
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().isAssignableTo(cl);
        }
        return false;
    }

    @Override
    public JMethod[] getDeclaredMethods() {
        ArrayList<JavaMethod> methodList = this.getMethodList();
        JMethod[] methods = new JMethod[methodList.size()];
        methodList.toArray(methods);
        return methods;
    }

    @Override
    public JMethod[] getConstructors() {
        ArrayList<JavaMethod> ctorList = new ArrayList<JavaMethod>();
        for (JavaMethod method : this.getMethodList()) {
            if (!method.getName().equals("<init>")) continue;
            ctorList.add(method);
        }
        JMethod[] methods = new JMethod[ctorList.size()];
        ctorList.toArray(methods);
        return methods;
    }

    @Override
    public JMethod getMethod(String name, JClass[] paramTypes) {
        block0: for (JMethod method : this.getMethods()) {
            JClass[] mParamTypes;
            if (!method.getName().equals(name) || (mParamTypes = method.getParameterTypes()).length != paramTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].getName().equals(mParamTypes[i].getName())) continue block0;
            }
            return method;
        }
        return null;
    }

    @Override
    public JMethod[] getMethods() {
        ArrayList<JMethod> methodList = new ArrayList<JMethod>();
        this.getMethods(methodList);
        JMethod[] methods = new JMethod[methodList.size()];
        methodList.toArray(methods);
        return methods;
    }

    private void getMethods(ArrayList<JMethod> methodList) {
        for (JMethod method : this.getDeclaredMethods()) {
            if (methodList.contains(method)) continue;
            methodList.add(method);
        }
        if (this.getSuperClass() != null) {
            for (JMethod method : this.getSuperClass().getMethods()) {
                if (methodList.contains(method)) continue;
                methodList.add(method);
            }
        }
    }

    @Override
    public JField[] getDeclaredFields() {
        ArrayList<JavaField> fieldList = this.getFieldList();
        JField[] fields = new JField[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    @Override
    public JField[] getFields() {
        ArrayList<JField> fieldList = new ArrayList<JField>();
        this.getFields(fieldList);
        JField[] fields = new JField[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    private void getFields(ArrayList<JField> fieldList) {
        for (JField field : this.getDeclaredFields()) {
            if (fieldList.contains(field)) continue;
            fieldList.add(field);
        }
        if (this.getSuperClass() != null) {
            for (JField field : this.getSuperClass().getFields()) {
                if (fieldList.contains(field)) continue;
                fieldList.add(field);
            }
        }
    }

    @Override
    public JAnnotation[] getDeclaredAnnotations() {
        if (this._annotations == null) {
            Attribute attr = this.getAttribute("RuntimeVisibleAnnotations");
            if (attr instanceof OpaqueAttribute) {
                byte[] buffer = ((OpaqueAttribute)attr).getValue();
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    ConstantPool cp = this.getConstantPool();
                    this._annotations = JavaAnnotation.parseAnnotations(is, cp, this.getClassLoader());
                }
                catch (IOException e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            if (this._annotations == null) {
                this._annotations = new JavaAnnotation[0];
            }
        }
        return this._annotations;
    }

    @Override
    public JAnnotation getAnnotation(String className) {
        JAnnotation[] annList = this.getDeclaredAnnotations();
        for (int i = 0; i < annList.length; ++i) {
            if (!annList[i].getType().equals(className)) continue;
            return annList[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyLoad() {
        if (this._major > 0) {
            return;
        }
        try {
            if (this._url == null) {
                throw new IllegalStateException();
            }
            InputStream is = this._url.openStream();
            ReadStream rs = Vfs.openRead(is);
            try {
                this._major = 1;
                ByteCodeParser parser = new ByteCodeParser();
                parser.setClassLoader(this._loader);
                parser.setJavaClass(this);
                parser.parse((InputStream)rs);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                rs.close();
                is.close();
                throw throwable;
            }
            rs.close();
            is.close();
            {
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(WriteStream os) throws IOException {
        int i;
        ByteCodeWriter out = new ByteCodeWriter((OutputStream)os, this);
        out.writeInt(-889275714);
        out.writeShort(this._minor);
        out.writeShort(this._major);
        this._constantPool.write(out);
        out.writeShort(this._accessFlags);
        out.writeClass(this._thisClass);
        out.writeClass(this._superClass);
        out.writeShort(this._interfaces.size());
        for (i = 0; i < this._interfaces.size(); ++i) {
            String className = this._interfaces.get(i);
            out.writeClass(className);
        }
        out.writeShort(this._fields.size());
        for (i = 0; i < this._fields.size(); ++i) {
            JavaField field = this._fields.get(i);
            field.write(out);
        }
        out.writeShort(this._methods.size());
        for (i = 0; i < this._methods.size(); ++i) {
            JavaMethod method = this._methods.get(i);
            method.write(out);
        }
        out.writeShort(this._attributes.size());
        for (i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    @Override
    public String toString() {
        return "JavaClass[" + this._thisClass + "]";
    }
}

