/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import java.io.IOException;
import java.util.logging.Logger;

public class NameAndTypeConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(NameAndTypeConstant.class);
    private int _nameIndex;
    private int _descriptorIndex;

    NameAndTypeConstant(ConstantPool pool, int index, int nameIndex, int descriptorIndex) {
        super(pool, index);
        this._nameIndex = nameIndex;
        this._descriptorIndex = descriptorIndex;
    }

    public String getName() {
        return this.getConstantPool().getUtf8(this._nameIndex).getValue();
    }

    public String getType() {
        return this.getConstantPool().getUtf8(this._descriptorIndex).getValue();
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(12);
        out.writeShort(this._nameIndex);
        out.writeShort(this._descriptorIndex);
    }

    public int export(ConstantPool target) {
        return target.addNameAndType(this.getName(), this.getType()).getIndex();
    }

    public String toString() {
        return "NameAndTypeConstant[" + this.getName() + ", " + this.getType() + "]";
    }
}

