/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.NodeBuilderChildProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.BeanConfig;
import com.caucho.config.types.InterfaceConfig;
import com.caucho.config.types.Validator;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.loader.Environment;
import com.caucho.util.CompileException;
import com.caucho.util.DisplayableException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.context.DependentScope;
import com.caucho.webbeans.context.ScopeContext;
import com.caucho.xml.QAbstractNode;
import com.caucho.xml.QAttributedNode;
import com.caucho.xml.QDocument;
import com.caucho.xml.QElement;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import com.caucho.xml.XmlUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigContext {
    private static final L10N L = new L10N(ConfigContext.class);
    private static final Logger log = Logger.getLogger(ConfigContext.class.getName());
    private static final QName RESIN_TYPE = new QName("resin:type", null);
    private static final QName RESIN_TYPE_NS = new QName("resin:type", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_CLASS = new QName("resin:class", null);
    private static final QName RESIN_CLASS_NS = new QName("resin:class", "http://caucho.com/ns/resin/core");
    private static final QName RESIN_PARAM = new QName("resin:param", null);
    private static final QName RESIN_PARAM_NS = new QName("resin:param", "http://caucho.com/ns/resin/core");
    private static final QName TEXT = new QName("#text");
    private static final QName VALUE = new QName("value");
    private static final Object NULL = new Object();
    private static final HashSet<QName> _resinClassSet = new HashSet();
    private static ThreadLocal<ConfigContext> _currentBuilder = new ThreadLocal();
    private Config _config;
    private ArrayList<ValidatorEntry> _validators = new ArrayList();
    private ConfigELContext _elContext = new ConfigELContext();
    private DependentScope _dependentScope;
    private ArrayList<Dependency> _dependList;
    private Document _dependDocument;
    private String _baseUri;

    public ConfigContext() {
    }

    public ConfigContext(ComponentImpl component, Object value, ScopeContext scope) {
        this();
        this._dependentScope = new DependentScope(component, value, scope);
    }

    public ConfigContext(ScopeContext scope) {
        this();
        this._dependentScope = new DependentScope(scope);
    }

    ConfigContext(Config config) {
        this._config = config;
    }

    public static ConfigContext create() {
        ConfigContext env = _currentBuilder.get();
        if (env != null) {
            return env;
        }
        return new ConfigContext();
    }

    public static ConfigContext createForProgram() {
        return new ConfigContext();
    }

    public static ConfigContext getCurrentBuilder() {
        return _currentBuilder.get();
    }

    public static ConfigContext getCurrent() {
        return _currentBuilder.get();
    }

    static void setCurrentBuilder(ConfigContext builder) {
        _currentBuilder.set(builder);
    }

    public String getBaseUri() {
        return this._baseUri;
    }

    public void addDestructor(ComponentImpl comp, Object value) {
        if (this._dependentScope != null) {
            this._dependentScope.addDestructor(comp, value);
        } else if (comp instanceof Closeable) {
            Environment.addCloseListener((Closeable)((Object)comp));
        }
    }

    public boolean canInject(ScopeContext scope) {
        return this._dependentScope == null || this._dependentScope.canInject(scope);
    }

    public Object get(ComponentImpl comp) {
        if (this._dependentScope != null) {
            return this._dependentScope.get(comp);
        }
        return null;
    }

    public Config getConfig() {
        return this._config;
    }

    public void put(ComponentImpl comp, Object obj) {
        if (this._dependentScope == null) {
            this._dependentScope = new DependentScope();
        }
        this._dependentScope.put(comp, obj);
    }

    private boolean isEL() {
        return this._config == null || this._config.isEL();
    }

    public boolean isIgnoreEnvironment() {
        return this._config != null && this._config.isIgnoreEnvironment();
    }

    public Object configure(Object bean, Node top) throws LineConfigException {
        if (bean == null) {
            throw new NullPointerException(L.l("unexpected null bean at node '{0}'", (Object)top));
        }
        ConfigContext oldBuilder = _currentBuilder.get();
        try {
            _currentBuilder.set(this);
            ConfigType type = TypeFactory.getType(bean.getClass());
            this.configureBean(bean, top);
            type.init(bean);
            Object object = type.replaceObject(bean);
            return object;
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, top);
        }
        finally {
            _currentBuilder.set(oldBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureBean(Object bean, Node top) throws LineConfigException {
        ConfigContext oldBuilder = _currentBuilder.get();
        String oldFile = this._baseUri;
        ArrayList<Dependency> oldDependList = this._dependList;
        try {
            _currentBuilder.set(this);
            if (top instanceof QNode) {
                QNode qNode = (QNode)top;
                this._baseUri = qNode.getBaseURI();
            }
            this._dependList = this.getDependencyList(top);
            ConfigType type = TypeFactory.getType(bean.getClass());
            this.configureNode(top, bean, type);
        }
        finally {
            _currentBuilder.set(oldBuilder);
            this._dependList = oldDependList;
            this._baseUri = oldFile;
        }
    }

    public void configureAttribute(Object bean, Node attribute) throws LineConfigException {
        String attrName = attribute.getNodeName();
        if (attrName.equals("resin:type")) {
            return;
        }
        if (attrName.startsWith("xmlns")) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        ConfigContext oldBuilder = ConfigContext.getCurrentBuilder();
        try {
            ConfigContext.setCurrentBuilder(this);
            ConfigType type = TypeFactory.getType(bean.getClass());
            QName qName = ((QAbstractNode)attribute).getQName();
            type.beforeConfigure(this, bean, attribute);
            this.configureChildNode(attribute, qName, bean, type, false);
            type.afterConfigure(this, bean);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, attribute);
        }
        finally {
            ConfigContext.setCurrentBuilder(oldBuilder);
            thread.setContextClassLoader(oldLoader);
        }
    }

    private Object configureNode(Node node, Object bean, ConfigType type) throws LineConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            type.beforeConfigure(this, bean, node);
            type.beforeConfigureBean(this, bean, node);
            this.configureNodeAttributes(node, bean, type);
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                QName qName = ((QAbstractNode)childNode).getQName();
                this.configureChildNode(childNode, qName, bean, type, false);
            }
            type.afterConfigure(this, bean);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, node);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return bean;
    }

    private void configureNodeAttributes(Node node, Object bean, ConfigType type) throws Exception {
        block3: {
            block2: {
                if (!(node instanceof QAttributedNode)) break block2;
                for (Node child = ((QAttributedNode)node).getFirstAttribute(); child != null; child = child.getNextSibling()) {
                    Attr attr = child;
                    QName qName = ((QNode)((Object)attr)).getQName();
                    this.configureChildNode(attr, qName, bean, type, false);
                }
                break block3;
            }
            NamedNodeMap attrList = node.getAttributes();
            if (attrList == null) break block3;
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attrList.item(i);
                QName qName = ((QNode)((Object)attr)).getQName();
                this.configureChildNode(attr, qName, bean, type, false);
            }
        }
    }

    private void configureChildNode(Node childNode, QName qName, Object bean, ConfigType type, boolean allowParam) throws Exception {
        if (qName.getName().startsWith("xmlns") || !allowParam && _resinClassSet.contains(qName)) {
            return;
        }
        try {
            String text;
            Object childBean;
            Attribute attrStrategy = type.getAttribute(qName);
            if (attrStrategy == null) {
                attrStrategy = type.getProgramAttribute();
            }
            if (attrStrategy == null) {
                attrStrategy = TypeFactory.getFactory().getEnvironmentAttribute(qName);
            }
            if (attrStrategy == null) {
                if (childNode instanceof Element || childNode instanceof Attr) {
                    throw ConfigContext.error(L.l("'{0}' is an unknown property of '{1}'.", (Object)qName.getName(), (Object)type.getTypeName()), childNode);
                }
                return;
            }
            if (attrStrategy.isProgram()) {
                attrStrategy.setValue(bean, qName, this.buildProgram(attrStrategy, childNode));
                return;
            }
            if (attrStrategy.isNode()) {
                attrStrategy.setValue(bean, qName, childNode);
                return;
            }
            ConfigType childType = null;
            if (childNode instanceof Element && (childBean = this.createResinType(attrStrategy.getConfigType(), (Element)childNode)) != null) {
                ConfigType childBeanType = TypeFactory.getType(childBean.getClass());
                childBean = childBeanType.replaceObject(childBean);
                attrStrategy.setValue(bean, qName, childBean);
                return;
            }
            if (attrStrategy.isAllowText() && (text = this.getTextValue(childNode)) != null) {
                boolean isTrim = this.isTrim(childNode);
                if (this.isEL() && attrStrategy.isEL() && (text.indexOf("#{") >= 0 || text.indexOf("${") >= 0)) {
                    Object elValue;
                    if (isTrim) {
                        text = text.trim();
                    }
                    if ((elValue = this.eval(attrStrategy.getConfigType(), text)) != NULL) {
                        attrStrategy.setValue(bean, qName, elValue);
                    } else {
                        attrStrategy.setValue(bean, qName, null);
                    }
                } else {
                    this.setText(bean, qName, text, attrStrategy, isTrim);
                }
                return;
            }
            childBean = attrStrategy.create(bean);
            if (childBean != null) {
                ConfigType childBeanType = TypeFactory.getType(childBean.getClass());
                if (childNode instanceof Element) {
                    this.configureNode(childNode, childBean, childBeanType);
                } else {
                    this.configureChildNode(childNode, TEXT, childBean, childBeanType, false);
                }
                childBeanType.init(childBean);
                Object newBean = attrStrategy.replaceObject(childBean);
                childBean = newBean != childBean ? newBean : childBeanType.replaceObject(childBean);
                attrStrategy.setValue(bean, qName, childBean);
            } else {
                childBean = this.getElementValue(attrStrategy, childNode);
                if (childBean != null) {
                    if (childBean != NULL) {
                        attrStrategy.setValue(bean, qName, childBean);
                    } else {
                        attrStrategy.setValue(bean, qName, null);
                    }
                } else {
                    ConfigType attrType = attrStrategy.getConfigType();
                    String textValue = attrType.isNoTrim() ? ConfigContext.textValueNoTrim(childNode) : ConfigContext.textValue(childNode);
                    if (this.isEL() && attrType.isEL() && textValue.indexOf("${") >= 0) {
                        childType = attrStrategy.getConfigType();
                        Object value = childType.valueOf(this.evalObject(textValue));
                        attrStrategy.setValue(bean, qName, value);
                    } else {
                        attrStrategy.setText(bean, qName, textValue);
                    }
                }
            }
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, childNode);
        }
    }

    public Object create(Node childNode, ConfigType type) throws ConfigException {
        Object childBean;
        if (childNode instanceof Element && (childBean = this.createResinType(type, (Element)childNode)) != null) {
            ConfigType childBeanType = TypeFactory.getType(childBean.getClass());
            childBeanType.init(childBean);
            return childBeanType.replaceObject(childBean);
        }
        try {
            String text = this.getTextValue(childNode);
            if (text != null) {
                boolean isTrim = this.isTrim(childNode);
                if (this.isEL() && type.isEL() && (text.indexOf("#{") >= 0 || text.indexOf("${") >= 0)) {
                    Object elValue;
                    if (isTrim) {
                        text = text.trim();
                    }
                    if ((elValue = this.eval(type, text)) != NULL) {
                        return elValue;
                    }
                    return null;
                }
                return text;
            }
            childBean = type.create(null);
            if (childBean != null) {
                ConfigType childBeanType = TypeFactory.getType(childBean.getClass());
                if (childNode instanceof Element) {
                    this.configureNode(childNode, childBean, childBeanType);
                } else {
                    this.configureChildNode(childNode, TEXT, childBean, childBeanType, false);
                }
                childBeanType.init(childBean);
                return childBeanType.replaceObject(childBean);
            }
            String textValue = type.isNoTrim() ? ConfigContext.textValueNoTrim(childNode) : ConfigContext.textValue(childNode);
            if (this.isEL() && type.isEL() && textValue.indexOf("${") >= 0) {
                Object value = type.valueOf(this.evalObject(textValue));
                return value;
            }
            return type.valueOf(textValue);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, childNode);
        }
    }

    private void setText(Object bean, QName qName, String text, Attribute attrStrategy, boolean isTrim) throws Exception {
        ConfigType attrType = attrStrategy.getConfigType();
        if (isTrim && !attrType.isNoTrim()) {
            text = text.trim();
        }
        if (this.isEL() && attrType.isEL() && text.indexOf("${") >= 0) {
            ConfigType childType = attrStrategy.getConfigType();
            Object value = childType.valueOf(this.evalObject(text));
            attrStrategy.setValue(bean, qName, value);
        } else {
            attrStrategy.setText(bean, qName, text);
        }
    }

    private boolean isTrim(Node node) {
        Element elt;
        if (node instanceof Attr) {
            return false;
        }
        return !(node instanceof Element) || "".equals((elt = (Element)node).getAttribute("xml:space"));
    }

    private ConfigProgram buildProgram(Attribute attr, Node node) {
        return new NodeBuilderChildProgram(node);
    }

    private void configureChildAttribute(Attr childNode, QName qName, Object bean, ConfigType type) throws Exception {
        if (qName.getName().startsWith("xmlns") || _resinClassSet.contains(qName)) {
            return;
        }
        try {
            Attribute attrStrategy = type.getAttribute(qName);
            if (attrStrategy == null) {
                throw ConfigContext.error(L.l("'{0}' is an unknown property of '{1}'.", (Object)qName.getName(), (Object)type.getTypeName()), (Node)childNode);
            }
            if (attrStrategy.isProgram()) {
                attrStrategy.setValue(bean, qName, this.buildProgram(attrStrategy, childNode));
                return;
            }
            if (attrStrategy.isNode()) {
                attrStrategy.setValue(bean, qName, childNode);
                return;
            }
            String textValue = childNode.getValue();
            attrStrategy.setText(bean, qName, textValue);
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigContext.error(e, (Node)childNode);
        }
    }

    Object configureValue(Node node) {
        String value = ConfigContext.textValue(node);
        if (this.isEL() && value != null && value.startsWith("${") && value.endsWith("}")) {
            return this.evalObject(value);
        }
        return value;
    }

    public void setDependentScope(DependentScope scope) {
        this._dependentScope = scope;
    }

    public DependentScope getDependentScope() {
        if (this._dependentScope == null) {
            this._dependentScope = new DependentScope();
        }
        return this._dependentScope;
    }

    public ArrayList<Dependency> getDependencyList() {
        return this._dependList;
    }

    ArrayList<Dependency> getDependencyList(Node node) {
        ArrayList<Depend> dependList = null;
        if (node instanceof QElement) {
            QElement qelt = (QElement)node;
            QDocument doc = (QDocument)qelt.getOwnerDocument();
            if (doc == null) {
                return null;
            }
            if (doc == this._dependDocument) {
                return this._dependList;
            }
            this._dependDocument = doc;
            ArrayList<Path> pathList = doc.getDependList();
            if (pathList != null) {
                dependList = new ArrayList<Depend>();
                for (int i = 0; i < pathList.size(); ++i) {
                    dependList.add(new Depend(pathList.get(i)));
                }
            }
            this._dependList = dependList;
        }
        return dependList;
    }

    Object createResinType(ConfigType childType, Element node) {
        String typeName = null;
        if (node instanceof QAttributedNode) {
            for (Node child = ((QAttributedNode)((Object)node)).getFirstAttribute(); child != null; child = child.getNextSibling()) {
                Attr attr = child;
                QName qName = ((QNode)((Object)attr)).getQName();
                if (!_resinClassSet.contains(qName)) continue;
                typeName = attr.getValue();
                break;
            }
        } else {
            NamedNodeMap attrList = node.getAttributes();
            if (attrList != null) {
                int length = attrList.getLength();
                for (int i = 0; i < length; ++i) {
                    Attr attr = (Attr)attrList.item(i);
                    QName qName = ((QNode)((Object)attr)).getQName();
                    if (!_resinClassSet.contains(qName)) continue;
                    typeName = attr.getValue();
                    break;
                }
            }
        }
        if (typeName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(typeName, false, loader);
                ConfigType beanConfigType = TypeFactory.getType(BeanConfig.class);
                InterfaceConfig cfg = new InterfaceConfig(cl);
                cfg.setClass(cl);
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    QName qName = ((QAbstractNode)childNode).getQName();
                    if (!qName.equals(RESIN_PARAM) && !qName.equals(RESIN_PARAM_NS)) continue;
                    this.configureChildNode(childNode, qName, cfg, beanConfigType, true);
                }
                cfg.init();
                Object bean = cfg.createObjectNoInit();
                this.configureBean(bean, node);
                Config.init(bean);
                return bean;
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        return null;
    }

    Object configureCreate(Class type, Node node) throws Exception {
        Object value = type.newInstance();
        return this.configure(value, node);
    }

    public ConfigELContext getELContext() {
        return this._elContext;
    }

    void addValidator(Validator validator) {
        if (this._validators == null) {
            this._validators = new ArrayList();
        }
        this._validators.add(new ValidatorEntry(validator));
    }

    static boolean hasChildren(Node node) {
        NamedNodeMap attrList;
        if (node instanceof QAttributedNode) {
            for (Node attr = ((QAttributedNode)node).getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
                if (attr.getNodeName().startsWith("xml")) continue;
                return true;
            }
        } else if (node instanceof Element && (attrList = node.getAttributes()) != null) {
            for (int i = 0; i < attrList.getLength(); ++i) {
                if (attrList.item(i).getNodeName().startsWith("xml")) continue;
                return true;
            }
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            if (!(ptr instanceof Element)) continue;
            return true;
        }
        return false;
    }

    static String getValue(QName name, Node node, String defaultValue) {
        String value;
        if (node instanceof Element && !"".equals(value = ((Element)node).getAttribute(name.getName()))) {
            return value;
        }
        for (Node ptr = node.getFirstChild(); ptr != null; ptr = ptr.getNextSibling()) {
            QName qName = ((QAbstractNode)ptr).getQName();
            if (!name.equals(qName)) continue;
            return ConfigContext.textValue(ptr);
        }
        return defaultValue;
    }

    Object getELValue(Attribute attr, Node node) {
        if (node instanceof Attr) {
            Attr attrNode = (Attr)node;
            String data = attrNode.getNodeValue();
            if (data != null && this.isEL() && attr.isEL() && (data.indexOf("#{") >= 0 || data.indexOf("${") >= 0)) {
                return this.eval(attr.getConfigType(), data);
            }
            return null;
        }
        if (!(node instanceof Element)) {
            return null;
        }
        Element elt = (Element)node;
        Element childElt = null;
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                if (childElt != null) {
                    return null;
                }
                childElt = (Element)child;
                continue;
            }
            if (!(child instanceof CharacterData) || XmlUtil.isWhitespace(((CharacterData)child).getData())) continue;
            String data = ((CharacterData)child).getData();
            if (this.isEL() && attr.isEL() && childElt == null && child.getNextSibling() == null && (data.indexOf("#{") >= 0 || data.indexOf("${") >= 0)) {
                String exprString = data.trim();
                ConfigELContext elContext = this.getELContext();
                ELParser parser = new ELParser(elContext, exprString);
                Expr expr = parser.parse();
                Object value = expr.getValue(elContext);
                return attr.getConfigType().valueOf(value);
            }
            return null;
        }
        return null;
    }

    String getTextValue(Node node) {
        if (node instanceof Attr) {
            Attr attrNode = (Attr)node;
            String data = attrNode.getNodeValue();
            return data;
        }
        if (!(node instanceof Element)) {
            return null;
        }
        Element elt = (Element)node;
        if (elt.getAttributes().getLength() > 0) {
            return null;
        }
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                return null;
            }
            if (!(child instanceof CharacterData)) continue;
            String data = ((CharacterData)child).getData();
            if (child.getNextSibling() == null && !XmlUtil.isWhitespace(data)) {
                return data;
            }
            return null;
        }
        return null;
    }

    private Object eval(ConfigType type, String data) {
        ELParser parser;
        Expr expr;
        ConfigELContext elContext = this.getELContext();
        Object value = type.valueOf(elContext, expr = (parser = new ELParser(elContext, data)).parse());
        if (value != null) {
            return value;
        }
        return NULL;
    }

    Object getElementValue(Attribute attr, Node node) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element elt = (Element)node;
        Element childElt = null;
        for (Node child = elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                if (childElt != null) {
                    return null;
                }
                childElt = (Element)child;
                continue;
            }
            if (!(child instanceof CharacterData) || XmlUtil.isWhitespace(((CharacterData)child).getData())) continue;
            String data = ((CharacterData)child).getData();
            if (this.isEL() && attr.isEL() && childElt == null && child.getNextSibling() == null && (data.indexOf("#{") >= 0 || data.indexOf("${") >= 0)) {
                ConfigELContext elContext = this.getELContext();
                ELParser parser = new ELParser(elContext, data.trim());
                Expr expr = parser.parse();
                Object value = attr.getConfigType().valueOf(elContext, expr);
                if (value != null) {
                    return value;
                }
                return NULL;
            }
            return null;
        }
        if (childElt == null) {
            return null;
        }
        TypeFactory factory = TypeFactory.getFactory();
        ConfigType childType = factory.getEnvironmentType(((QElement)childElt).getQName());
        if (childType != null) {
            Object childBean = childType.create(null);
            this.configureNode(childElt, childBean, childType);
            childType.init(childBean);
            Object value = childType.replaceObject(childBean);
            if (value != null) {
                return value;
            }
            return NULL;
        }
        return null;
    }

    static String textValue(Node node) {
        String space;
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (value == null || value.equals("")) {
            return "";
        }
        if (node instanceof Element && !(space = ((Element)node).getAttribute("xml:space")).equals("")) {
            return value;
        }
        return value.trim();
    }

    static String textValueNoTrim(Node node) {
        if (node instanceof Attr) {
            return node.getNodeValue();
        }
        String value = XmlUtil.textValue(node);
        if (value == null) {
            return "";
        }
        return value;
    }

    public Object evalObject(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0 && this.isEL()) {
            ELParser parser = new ELParser(this.getELContext(), exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.getValue(this.getELContext());
        }
        return exprString;
    }

    public static RuntimeException error(String msg, Node node) {
        String systemId = null;
        String filename = null;
        int line = 0;
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            systemId = qnode.getBaseURI();
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        if (systemId != null) {
            String sourceLines = ConfigContext.getSourceLines(systemId, line);
            msg = msg + sourceLines;
        }
        if (filename != null) {
            return new LineConfigException(filename, line, msg);
        }
        return new LineConfigException(msg);
    }

    public static RuntimeException error(Throwable e, Node node) {
        String sourceLines;
        String systemId = null;
        String filename = null;
        int line = 0;
        if (e instanceof RuntimeException && e instanceof DisplayableException && !ConfigException.class.equals(e.getClass())) {
            return (RuntimeException)e;
        }
        if (node instanceof QAbstractNode) {
            QAbstractNode qnode = (QAbstractNode)node;
            systemId = qnode.getBaseURI();
            filename = qnode.getFilename();
            line = qnode.getLine();
        }
        while (!(e.getCause() == null || e instanceof LineCompileException || e instanceof LineConfigException || e instanceof CompileException)) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            return (LineConfigException)e;
        }
        if (e instanceof LineCompileException) {
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof ConfigException && e.getMessage() != null && filename != null) {
            sourceLines = ConfigContext.getSourceLines(systemId, line);
            return new LineConfigException(filename, line, e.getMessage() + sourceLines, e);
        }
        if (e instanceof CompileException && e.getMessage() != null) {
            return new LineConfigException(filename, line, e);
        }
        sourceLines = ConfigContext.getSourceLines(systemId, line);
        String msg = filename + ":" + line + ": " + e + sourceLines;
        if (e instanceof RuntimeException) {
            throw new LineConfigException(msg, e);
        }
        if (e instanceof Error) {
            throw new LineConfigException(msg, e);
        }
        return new LineConfigException(msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSourceLines(String systemId, int errorLine) {
        if (systemId == null) {
            return "";
        }
        ReadStream is = null;
        try {
            String text;
            is = Vfs.lookup().lookup(systemId).openRead();
            int line = 0;
            StringBuilder sb = new StringBuilder("\n\n");
            while ((text = is.readLine()) != null) {
                if (errorLine - 2 > ++line || line > errorLine + 2) continue;
                sb.append(line);
                sb.append(": ");
                sb.append(text);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
            String string = "";
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._dependentScope + "]";
    }

    static {
        _resinClassSet.add(RESIN_CLASS_NS);
        _resinClassSet.add(RESIN_CLASS);
        _resinClassSet.add(RESIN_TYPE_NS);
        _resinClassSet.add(RESIN_TYPE);
        _resinClassSet.add(RESIN_PARAM_NS);
        _resinClassSet.add(RESIN_PARAM);
    }

    static class ValidatorEntry {
        private Validator _validator;
        private ClassLoader _loader;

        ValidatorEntry(Validator validator) {
            this._validator = validator;
            this._loader = Thread.currentThread().getContextClassLoader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validate() throws ConfigException {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                this._validator.validate();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }
}

