/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

public class CreateAttribute
extends Attribute {
    private final Method _create;
    private final Method _setter;
    private final ConfigType _type;

    public CreateAttribute(Method create, ConfigType type) {
        this._create = create;
        if (this._create != null) {
            this._create.setAccessible(true);
        }
        this._type = type;
        this._setter = null;
    }

    public CreateAttribute(Method create, ConfigType type, Method setter) {
        this._create = create;
        if (this._create != null) {
            this._create.setAccessible(true);
        }
        this._type = type;
        this._setter = setter;
        if (this._setter != null) {
            this._setter.setAccessible(true);
        }
    }

    public ConfigType getConfigType() {
        return this._type;
    }

    public boolean isAllowText() {
        return false;
    }

    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            if (this._setter != null) {
                this._setter.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Method)this._setter, (Throwable)e);
        }
    }

    public Object create(Object parent) throws ConfigException {
        try {
            return this._create.invoke(parent, new Object[0]);
        }
        catch (Exception e) {
            throw ConfigException.create((Method)this._create, (Throwable)e);
        }
    }
}

