/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.attribute;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Method;

public class SetterAttribute
extends Attribute {
    private final L10N L = new L10N(SetterAttribute.class);
    private final Method _setter;
    private final ConfigType _type;

    public SetterAttribute(Method setter, ConfigType type) {
        this._setter = setter;
        this._setter.setAccessible(true);
        this._type = type;
    }

    public ConfigType getConfigType() {
        return this._type;
    }

    public void setText(Object bean, QName name, String value) throws ConfigException {
        try {
            this._setter.invoke(bean, this._type.valueOf(value));
        }
        catch (Exception e) {
            throw ConfigException.create((Method)this._setter, (Throwable)e);
        }
    }

    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            this._setter.invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            throw ConfigException.create((Method)this._setter, (String)this.L.l("'{0}' is an illegal value.", value), (Throwable)e);
        }
        catch (Exception e) {
            throw ConfigException.create((Method)this._setter, (Throwable)e);
        }
    }

    public Object create(Object parent) throws ConfigException {
        try {
            return this._type.create(parent);
        }
        catch (Exception e) {
            throw ConfigException.create((Method)this._setter, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._setter + "]";
    }
}

