/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinControl;
import com.caucho.config.types.FileSetType;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class ResinImport
extends ResinControl {
    private static final L10N L = new L10N(ResinImport.class);
    private static final Logger log = Log.open(ResinImport.class);
    private Path _path;
    private FileSetType _fileSet;
    private boolean _isOptional;

    public void setPath(Path path) {
        if (path == null) {
            throw new NullPointerException(L.l("'path' may not be null for resin:import"));
        }
        this._path = path;
    }

    public void setFileset(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    @PostConstruct
    public void init() throws Exception {
        ArrayList<Object> paths;
        if (this._path == null) {
            if (this._fileSet == null) {
                throw new ConfigException(L.l("'path' attribute missing from resin:import."));
            }
        } else if (!this._path.canRead() || this._path.isDirectory()) {
            if (this._isOptional) {
                log.finer(L.l("resin:import '{0}' is not readable.", (Object)this._path));
                Environment.addDependency((Dependency)new Depend(this._path));
                return;
            }
            throw new ConfigException(L.l("Required file '{0}' can not be read for resin:import.", (Object)this._path.getNativePath()));
        }
        Object object = this.getObject();
        String schema = null;
        if (object instanceof SchemaBean) {
            schema = ((SchemaBean)object).getSchema();
        }
        if (this._fileSet != null) {
            paths = this._fileSet.getPaths();
        } else {
            paths = new ArrayList();
            paths.add(this._path);
        }
        for (int i = 0; i < paths.size(); ++i) {
            Path path = (Path)paths.get(i);
            log.config(L.l("resin:import '{0}'", (Object)path.getNativePath()));
            Environment.addDependency((Dependency)new Depend(path));
            Config config = new Config();
            config.configureBean(object, path, schema);
        }
    }
}

