/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EjbGenerator
extends ValueGenerator {
    private static final Logger log = Logger.getLogger(EjbGenerator.class.getName());
    private static final L10N L = new L10N(EjbGenerator.class);
    private final Class _type;
    private final String _mappedName;
    private final String _beanName;
    private final String _jndiName;
    private final String _location;
    private ComponentImpl _component;
    private boolean _isBound;

    EjbGenerator(Class type, String mappedName, String beanName, String jndiName, String location) {
        this._type = type;
        this._mappedName = mappedName;
        this._beanName = beanName;
        this._jndiName = jndiName;
        this._location = location;
    }

    public Class getType() {
        return this._type;
    }

    public Object create() {
        if (this._component == null && !this._isBound) {
            this._isBound = false;
            WebBeansContainer webBeans = WebBeansContainer.create();
            if (this._mappedName != null && !"".equals(this._mappedName)) {
                this._component = webBeans.bind("error", (Type)this._type, this._mappedName);
                if (this._component == null) {
                    Object value = this.getJndiValue(this._type);
                    if (value != null) {
                        return value;
                    }
                    throw new ConfigException(this._location + L.l("'{0}' with mappedName='{1}' is an unknown @EJB", (Object)this._type.getName(), (Object)this._mappedName));
                }
            } else if (this._beanName != null && !"".equals(this._beanName)) {
                this._component = webBeans.bind("error", (Type)this._type, this._beanName);
                if (this._component == null) {
                    Object value = this.getJndiValue(this._type);
                    if (value != null) {
                        return value;
                    }
                    throw new ConfigException(this._location + L.l("'{0}' with beanName='{1}' is an unknown @EJB", (Object)this._type.getName(), (Object)this._beanName));
                }
            } else {
                this._component = webBeans.bind("error", this._type);
                if (this._component == null) {
                    Object value = this.getJndiValue(this._type);
                    if (value != null) {
                        return value;
                    }
                    throw new ConfigException(this._location + L.l("'{0}'  is an unknown @EJB", (Object)this._type.getName()));
                }
            }
            if (this._component != null && this._jndiName != null && !"".equals(this._jndiName)) {
                try {
                    Jndi.bindDeepShort(this._jndiName, this._component);
                }
                catch (NamingException e) {
                    throw ConfigException.create((Throwable)e);
                }
            }
        }
        if (this._component != null) {
            return this._component.get();
        }
        return this.getJndiValue(this._type);
    }

    private Object getJndiValue(Class type) {
        if (this._jndiName == null || "".equals(this._jndiName)) {
            return null;
        }
        try {
            Object value = Jndi.lookup(this._jndiName);
            if (value != null) {
                return PortableRemoteObject.narrow((Object)value, (Class)type);
            }
            return null;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._type.getName());
        if (this._mappedName != null) {
            sb.append(", mappedName=");
            sb.append(this._mappedName);
        }
        if (this._beanName != null) {
            sb.append(", beanName=");
            sb.append(this._beanName);
        }
        if (this._jndiName != null) {
            sb.append(", jndiName=");
            sb.append(this._jndiName);
        }
        sb.append("]");
        return sb.toString();
    }
}

