/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.j2ee.InjectProgram;
import com.caucho.config.j2ee.PersistenceContextGenerator;
import com.caucho.config.j2ee.PostConstructProgram;
import com.caucho.config.j2ee.PreDestroyInject;
import com.caucho.config.j2ee.PreDestroyProgram;
import com.caucho.config.program.ComponentValueGenerator;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.config.program.SingletonGenerator;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.interceptor.InvocationContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import javax.webbeans.BindingType;
import javax.webbeans.Destroys;
import javax.webbeans.Disposes;
import javax.webbeans.In;
import javax.webbeans.Observes;
import javax.webbeans.Produces;
import javax.xml.ws.WebServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectIntrospector {
    private static final L10N L = new L10N(InjectIntrospector.class);
    private static final Logger log = Log.open(InjectIntrospector.class);
    private static HashMap<Class, Class> _primitiveTypeMap = new HashMap();

    public static InjectProgram introspectProgram(Class type) {
        ArrayList<ConfigProgram> injectList = new ArrayList<ConfigProgram>();
        InjectIntrospector.introspectInject(injectList, type);
        InjectIntrospector.introspectInit(injectList, type);
        return new InjectProgram(injectList);
    }

    public static void introspectInit(ArrayList<ConfigProgram> initList, Class type) throws ConfigException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        InjectIntrospector.introspectInit(initList, type.getSuperclass());
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class) || method.getParameterTypes().length == 1 && InvocationContext.class.equals(method.getParameterTypes()[0])) continue;
            if (method.getParameterTypes().length != 0) {
                throw new ConfigException(InjectIntrospector.location(method) + L.l("{0}: @PostConstruct is requires zero arguments"));
            }
            PostConstructProgram initProgram = new PostConstructProgram(method);
            if (initList.contains(initProgram)) continue;
            initList.add(initProgram);
        }
    }

    public static void introspectDestroy(ArrayList<ConfigProgram> destroyList, Class type) throws ConfigException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        InjectIntrospector.introspectDestroy(destroyList, type.getSuperclass());
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 0) {
                if (types.length == 1 && types[0].equals(InvocationContext.class)) continue;
                throw new ConfigException(InjectIntrospector.location(method) + L.l("@PreDestroy is requires zero arguments"));
            }
            PreDestroyInject destroyProgram = new PreDestroyInject(method);
            if (destroyList.contains(destroyProgram)) continue;
            destroyList.add(destroyProgram);
        }
    }

    public static void introspectConstruct(ArrayList<ConfigProgram> initList, Class type) throws ConfigException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (method.isAnnotationPresent(PostConstruct.class)) {
                if (method.getParameterTypes().length != 0) {
                    throw new ConfigException(L.l("{0}: @PostConstruct is requires zero arguments", (Object)method.getName()));
                }
                PostConstructProgram initProgram = new PostConstructProgram(method);
                if (!initList.contains(initProgram)) {
                    initList.add(initProgram);
                }
            }
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (method.getParameterTypes().length != 0) {
                throw new ConfigException(L.l("{0}: @PreDestroy is requires zero arguments", (Object)method.getName()));
            }
            initList.add(new PreDestroyProgram(method));
        }
        InjectIntrospector.introspectConstruct(initList, type.getSuperclass());
    }

    public static void introspectInject(ArrayList<ConfigProgram> injectList, Class type) throws ConfigException {
        try {
            InjectIntrospector.introspectInjectImpl(injectList, type);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static void introspectInjectImpl(ArrayList<ConfigProgram> injectList, Class type) throws ConfigException, ClassNotFoundException {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        InjectIntrospector.introspectInjectImpl(injectList, type.getSuperclass());
        InjectIntrospector.configureClassResources(injectList, type);
        for (Field field : type.getDeclaredFields()) {
            if (InjectIntrospector.hasBindingAnnotation(field)) {
                WebBeansContainer webBeans = WebBeansContainer.create();
                webBeans.createProgram(injectList, field);
                continue;
            }
            InjectIntrospector.introspect(injectList, field);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            String fieldName = ((Method)accessibleObject).getName();
            Class<?>[] param = ((Method)accessibleObject).getParameterTypes();
            if (InjectIntrospector.hasBindingAnnotation((Method)accessibleObject)) {
                WebBeansContainer webBeans = WebBeansContainer.create();
                webBeans.createProgram(injectList, (Method)accessibleObject);
                continue;
            }
            if (param.length != 1) continue;
            InjectIntrospector.introspect(injectList, (Method)accessibleObject);
        }
    }

    public static void configureClassResources(ArrayList<ConfigProgram> initList, Class type) throws ConfigException {
        PersistenceContext pc;
        Resource resource;
        String location = type.getName() + ": ";
        Resources resources = type.getAnnotation(Resources.class);
        if (resources != null) {
            for (Resource resource2 : resources.value()) {
                InjectIntrospector.introspectClassResource(initList, type, resource2);
            }
        }
        if ((resource = type.getAnnotation(Resource.class)) != null) {
            InjectIntrospector.introspectClassResource(initList, type, resource);
        }
        if ((pc = type.getAnnotation(PersistenceContext.class)) != null) {
            InjectIntrospector.introspectClassPersistenceContext(initList, type, pc);
        }
        EJB ejb = type.getAnnotation(EJB.class);
        EJBs ejbs = type.getAnnotation(EJBs.class);
        if (ejb != null && ejbs != null) {
            throw new ConfigException(L.l("{0} cannot have both @EJBs and @EJB", (Object)type.getName()));
        }
        if (ejb != null) {
            if (Object.class.equals((Object)ejb.beanInterface())) {
                throw new ConfigException(location + L.l("@EJB at the class level must have a beanInterface()"));
            }
            if ("".equals(ejb.name())) {
                throw new ConfigException(location + L.l("@EJB at the class level must have a name()"));
            }
            InjectIntrospector.generateEjb(location, Object.class, "", ejb);
        } else if (ejbs != null) {
            for (EJB childEjb : ejbs.value()) {
                if (Object.class.equals((Object)childEjb.beanInterface())) {
                    throw new ConfigException(location + L.l("@EJB at the class level must have a beanInterface()"));
                }
                if ("".equals(childEjb.name())) {
                    throw new ConfigException(location + L.l("@EJB at the class level must have a name()"));
                }
                InjectIntrospector.generateEjb(location, Object.class, "", childEjb);
            }
        }
    }

    private static void introspectClassResource(ArrayList<ConfigProgram> initList, Class type, Resource resource) throws ConfigException {
        String name = resource.name();
        Field field = InjectIntrospector.findField(type, name);
        if (field != null) {
            ValueGenerator gen = InjectIntrospector.generateResource(InjectIntrospector.location(field), field.getType(), "", resource);
            return;
        }
        Method method = InjectIntrospector.findMethod(type, name);
        if (method != null) {
            ValueGenerator gen = InjectIntrospector.generateResource(InjectIntrospector.location(method), method.getParameterTypes()[0], "", resource);
            return;
        }
    }

    private static void introspectClassPersistenceContext(ArrayList<ConfigProgram> initList, Class type, PersistenceContext pContext) throws ConfigException {
        String location = type.getSimpleName() + ": ";
        ValueGenerator gen = InjectIntrospector.generatePersistenceContext(location, EntityManager.class, "", pContext);
    }

    private static void introspect(ArrayList<ConfigProgram> injectList, Field field) throws ConfigException {
        String location = InjectIntrospector.location(field);
        ValueGenerator gen = null;
        String jndiName = field.getDeclaringClass().getName() + "/" + field.getName();
        if (field.isAnnotationPresent(Resource.class)) {
            Resource resource = field.getAnnotation(Resource.class);
            gen = InjectIntrospector.generateResource(location, field.getType(), jndiName, resource);
        } else if (field.isAnnotationPresent(EJB.class)) {
            EJB ejb = field.getAnnotation(EJB.class);
            gen = InjectIntrospector.generateEjb(location, field.getType(), jndiName, ejb);
        } else if (field.isAnnotationPresent(PersistenceUnit.class)) {
            PersistenceUnit pUnit = field.getAnnotation(PersistenceUnit.class);
            gen = InjectIntrospector.generatePersistenceUnit(location, field.getType(), jndiName, pUnit);
        } else if (field.isAnnotationPresent(PersistenceContext.class)) {
            PersistenceContext pContext = field.getAnnotation(PersistenceContext.class);
            gen = InjectIntrospector.generatePersistenceContext(location, field.getType(), jndiName, pContext);
        } else if (field.isAnnotationPresent(WebServiceRef.class)) {
            WebServiceRef webService = field.getAnnotation(WebServiceRef.class);
            gen = InjectIntrospector.generateWebService(location, field.getType(), jndiName, webService);
        } else if (InjectIntrospector.hasBindingAnnotation(field)) {
            InjectIntrospector.introspectWebBean(injectList, field);
        }
        if (gen != null) {
            injectList.add(new FieldGeneratorProgram(field, gen));
        }
    }

    private static void introspect(ArrayList<ConfigProgram> injectList, Method method) throws ConfigException {
        String location = InjectIntrospector.location(method);
        ValueGenerator gen = null;
        Class<?> type = null;
        String jndiName = method.getDeclaringClass().getName() + "/" + method.getName();
        if (method.getParameterTypes().length > 0) {
            type = method.getParameterTypes()[0];
        }
        if (method.isAnnotationPresent(Resource.class)) {
            Resource resource = method.getAnnotation(Resource.class);
            gen = InjectIntrospector.generateResource(location, type, jndiName, resource);
        } else if (method.isAnnotationPresent(EJB.class)) {
            EJB ejb = method.getAnnotation(EJB.class);
            gen = InjectIntrospector.generateEjb(location, type, jndiName, ejb);
        } else if (method.isAnnotationPresent(PersistenceUnit.class)) {
            PersistenceUnit pUnit = method.getAnnotation(PersistenceUnit.class);
            gen = InjectIntrospector.generatePersistenceUnit(location, type, jndiName, pUnit);
        } else if (method.isAnnotationPresent(PersistenceContext.class)) {
            PersistenceContext pContext = method.getAnnotation(PersistenceContext.class);
            gen = InjectIntrospector.generatePersistenceContext(location, type, jndiName, pContext);
        } else if (method.isAnnotationPresent(WebServiceRef.class)) {
            WebServiceRef webService = method.getAnnotation(WebServiceRef.class);
            gen = InjectIntrospector.generateWebService(location, type, jndiName, webService);
        } else if (InjectIntrospector.hasBindingAnnotation(method)) {
            InjectIntrospector.introspectWebBean(injectList, method);
        }
        if (gen != null) {
            injectList.add(new MethodGeneratorProgram(method, gen));
        }
    }

    private static ValueGenerator generateWebService(String location, Class type, String jndiName, WebServiceRef ref) throws ConfigException {
        String mappedName = ref.mappedName();
        if (!"".equals(ref.name())) {
            jndiName = ref.name();
        }
        return null;
    }

    private static ValueGenerator generatePersistenceContext(String location, Class type, String jndiName, PersistenceContext pContext) throws ConfigException {
        ComponentImpl component;
        AmberContainer.create().start();
        PersistenceContextType pType = pContext.type();
        if (PersistenceContextType.EXTENDED.equals((Object)pType)) {
            return InjectIntrospector.generateExtendedPersistenceContext(location, type, jndiName, pContext);
        }
        if (!type.isAssignableFrom(EntityManager.class)) {
            throw new ConfigException(location + L.l("@PersistenceContext field type '{0}' must be assignable from EntityManager", (Object)type.getName()));
        }
        String unitName = pContext.unitName();
        if (!"".equals(pContext.name())) {
            jndiName = pContext.name();
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        if ("".equals(unitName)) {
            component = webBeans.bind(location, (Type)((Object)EntityManager.class));
            if (component == null) {
                throw new ConfigException(location + L.l("@PersistenceContext cannot find any persistence contexts.  No JPA persistence-units have been deployed"));
            }
        } else {
            component = webBeans.bind(location, (Type)((Object)EntityManager.class), unitName);
            if (component == null) {
                throw new ConfigException(location + L.l("'{0}' is an unknown @PersistenceContext.", (Object)unitName));
            }
        }
        InjectIntrospector.bindJndi(location, jndiName, component);
        return new ComponentValueGenerator(location, component);
    }

    private static ValueGenerator generateExtendedPersistenceContext(String location, Class type, String jndiName, PersistenceContext pContext) throws ConfigException {
        AmberContainer.create().start();
        if (!type.isAssignableFrom(EntityManager.class)) {
            throw new ConfigException(location + L.l("@PersistenceContext field type '{0}' must be assignable from EntityManager", (Object)type.getName()));
        }
        PersistenceContextGenerator gen = new PersistenceContextGenerator(location, pContext);
        InjectIntrospector.bindJndi(location, jndiName, gen);
        return gen;
    }

    private static ValueGenerator generatePersistenceUnit(String location, Class type, String jndiName, PersistenceUnit pUnit) throws ConfigException {
        ComponentImpl component;
        if (!type.isAssignableFrom(EntityManagerFactory.class)) {
            throw new ConfigException(location + L.l("@PersistenceUnit field type '{0}' must be assignable from EntityManagerFactory", (Object)type.getName()));
        }
        String unitName = pUnit.unitName();
        if (!"".equals(pUnit.name())) {
            jndiName = pUnit.name();
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        if ("".equals(unitName)) {
            component = webBeans.bind(location, (Type)((Object)EntityManagerFactory.class));
            if (component == null) {
                throw new ConfigException(location + L.l("@PersistenceUnit cannot find any persistence units.  No JPA persistence-units have been deployed"));
            }
        } else {
            component = webBeans.bind(location, (Type)((Object)EntityManagerFactory.class), unitName);
            if (component == null) {
                throw new ConfigException(location + L.l("@PersistenceUnit(unitName='{0}') is an unknown persistence unit.  No matching JPA persistence-units have been deployed", (Object)unitName));
            }
        }
        InjectIntrospector.bindJndi(location, jndiName, component);
        return new ComponentValueGenerator(location, component);
    }

    private static ValueGenerator generateEjb(String location, Class fieldType, String jndiName, EJB ejb) throws ConfigException {
        Class type = ejb.beanInterface();
        String mappedName = ejb.mappedName();
        String beanName = ejb.beanName();
        if (!"".equals(ejb.name())) {
            jndiName = ejb.name();
        }
        return InjectIntrospector.generateJndiComponent(location, fieldType, type, jndiName, beanName, mappedName);
    }

    private static ValueGenerator generateResource(String location, Class fieldType, String jndiName, Resource resource) throws ConfigException {
        String mappedName = resource.mappedName();
        Class type = resource.type();
        if (!"".equals(resource.name())) {
            jndiName = resource.name();
        }
        return InjectIntrospector.generateJndiComponent(location, fieldType, type, jndiName, mappedName, "");
    }

    private static void introspectWebBean(ArrayList<ConfigProgram> injectList, Field field) throws ConfigException {
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.createProgram(injectList, field);
    }

    private static void introspectWebBean(ArrayList<ConfigProgram> injectList, Method method) throws ConfigException {
        WebBeansContainer webBeans = WebBeansContainer.create();
        webBeans.createProgram(injectList, method);
    }

    private static ValueGenerator generateJndiComponent(String location, Class fieldType, Class type, String jndiName, String mappedName, String beanName) {
        Object value;
        if (!fieldType.isAssignableFrom(type)) {
            type = fieldType;
        }
        if (type.isPrimitive()) {
            type = _primitiveTypeMap.get(type);
        }
        if ((value = Jndi.lookup(jndiName)) != null) {
            return new SingletonGenerator(value);
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentImpl component = null;
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = jndiName;
        }
        if ((component = webBeans.bind(location, (Type)type, mappedName)) != null) {
            InjectIntrospector.bindJndi(location, jndiName, component);
            return new ComponentValueGenerator(location, component);
        }
        if (component == null && beanName != null && !"".equals(beanName) && (component = webBeans.bind(location, (Type)type, beanName)) != null) {
            InjectIntrospector.bindJndi(location, jndiName, component);
            return new ComponentValueGenerator(location, component);
        }
        if (component == null && jndiName != null && !"".equals(jndiName) && (component = webBeans.bind(location, (Type)type, jndiName)) != null) {
            InjectIntrospector.bindJndi(location, jndiName, component);
            return new ComponentValueGenerator(location, component);
        }
        if (component == null) {
            component = webBeans.bind(location, type);
        }
        if (component != null) {
            InjectIntrospector.bindJndi(location, jndiName, component);
            return new ComponentValueGenerator(location, component);
        }
        throw new ConfigException(location + L.l("{0} with mappedName={1}, beanName={2}, and jndiName={3} does not match anything", (Object)type.getName(), (Object)mappedName, (Object)beanName, (Object)jndiName));
    }

    private static void bindJndi(String location, String name, Object value) {
        try {
            if (!"".equals(name)) {
                Jndi.bindDeepShort(name, value);
            }
        }
        catch (NamingException e) {
            throw new ConfigException(location + e.getMessage(), (Throwable)e);
        }
    }

    private static Field findField(Class type, String name) {
        for (Field field : type.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static Method findMethod(Class type, String name) {
        for (Method method : type.getDeclaredMethods()) {
            String methodName;
            if (method.getParameterTypes().length != 1 || !(methodName = method.getName()).startsWith("set") || !name.equals(methodName = Introspector.decapitalize(methodName.substring(3)))) continue;
            return method;
        }
        return null;
    }

    private static boolean hasBindingAnnotation(Field field) {
        if (field.isAnnotationPresent(In.class)) {
            return true;
        }
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(BindingType.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBindingAnnotation(Method method) {
        if (method.isAnnotationPresent(Produces.class)) {
            return false;
        }
        if (method.isAnnotationPresent(Destroys.class)) {
            return false;
        }
        if (method.isAnnotationPresent(In.class)) {
            return true;
        }
        boolean hasBinding = false;
        for (Annotation[] annList : method.getParameterAnnotations()) {
            if (annList == null) continue;
            for (Annotation ann : annList) {
                if (ann.annotationType().equals(Observes.class)) {
                    return false;
                }
                if (ann.annotationType().equals(Disposes.class)) {
                    return false;
                }
                if (!ann.annotationType().isAnnotationPresent(BindingType.class)) continue;
                hasBinding = true;
            }
        }
        return hasBinding;
    }

    private static String toFullName(String jndiName) {
        int colon = jndiName.indexOf(58);
        int slash = jndiName.indexOf(47);
        if (colon < 0 || slash > 0 && slash < colon) {
            jndiName = "java:comp/env/" + jndiName;
        }
        return jndiName;
    }

    private static ConfigException error(Field field, String msg) {
        return new ConfigException(InjectIntrospector.location(field) + msg);
    }

    private static ConfigException error(Method method, String msg) {
        return new ConfigException(InjectIntrospector.location(method) + msg);
    }

    private static String location(Field field) {
        String className = field.getDeclaringClass().getName();
        return className + "." + field.getName() + ": ";
    }

    private static String location(Method method) {
        String className = method.getDeclaringClass().getName();
        return className + "." + method.getName() + ": ";
    }

    static {
        _primitiveTypeMap.put(Boolean.TYPE, Boolean.class);
        _primitiveTypeMap.put(Byte.TYPE, Byte.class);
        _primitiveTypeMap.put(Character.TYPE, Character.class);
        _primitiveTypeMap.put(Short.TYPE, Short.class);
        _primitiveTypeMap.put(Integer.TYPE, Integer.class);
        _primitiveTypeMap.put(Long.TYPE, Long.class);
        _primitiveTypeMap.put(Float.TYPE, Float.class);
        _primitiveTypeMap.put(Double.TYPE, Double.class);
    }
}

