/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

public class PersistenceUnitGenerator
extends ValueGenerator
implements ObjectProxy {
    private static final Logger log = Logger.getLogger(PersistenceUnitGenerator.class.getName());
    private static final L10N L = new L10N(PersistenceUnitGenerator.class);
    private AmberContainer _amber;
    private String _location;
    private String _jndiName;
    private String _unitName;
    private EntityManagerFactory _factory;

    PersistenceUnitGenerator(String location, String jndiName, String unitName) {
        this._location = location;
        this._jndiName = jndiName;
        this._unitName = unitName;
    }

    PersistenceUnitGenerator(String location, PersistenceUnit unit) {
        this._location = location;
        this._jndiName = unit.name();
        this._unitName = unit.unitName();
    }

    public Class getType() {
        return EntityManagerFactory.class;
    }

    public Object create() {
        EntityManagerFactory factory;
        if (this._amber == null) {
            this._amber = AmberContainer.getCurrent();
        }
        if ((factory = this._amber.getEntityManagerFactory(this._unitName)) == null) {
            throw new ConfigException(this._location + L.l("@PersistenceUnit '{0}' is an unknown unit", (Object)this._unitName));
        }
        return factory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jndiName + "," + this._unitName + "]";
    }
}

