/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.lib;

import com.caucho.naming.Jndi;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinConfigLibrary {
    private static Logger _log;

    public static boolean class_exists(String className) {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            return cl != null;
        }
        catch (Throwable e) {
            ResinConfigLibrary.log().log(Level.FINEST, e.toString(), e);
            return false;
        }
    }

    public static Object jndi(String jndiName) {
        return ResinConfigLibrary.jndi_lookup(jndiName);
    }

    public static Object jndi_lookup(String jndiName) {
        return Jndi.lookup(jndiName);
    }

    public static void configure(WebBeansContainer webBeans) {
        try {
            for (Method m : ResinConfigLibrary.class.getMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || m.getName().equals("configure")) continue;
                webBeans.addSingletonByName(m, m.getName());
            }
        }
        catch (Exception e) {
            ResinConfigLibrary.log().log(Level.FINE, e.toString(), e);
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(ResinConfigLibrary.class.getName());
        }
        return _log;
    }
}

